/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.extension;

import io.smallrye.reactive.messaging.ChannelRegistry;
import io.smallrye.reactive.messaging.annotations.Channel;
import io.smallrye.reactive.messaging.annotations.Emitter;
import io.smallrye.reactive.messaging.annotations.OnOverflow;
import io.smallrye.reactive.messaging.extension.ChannelProducer;
import io.smallrye.reactive.messaging.extension.EmitterImpl;
import io.smallrye.reactive.messaging.extension.MediatorManager;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.DeploymentException;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessInjectionPoint;
import javax.enterprise.inject.spi.ProcessManagedBean;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.eclipse.microprofile.reactive.messaging.Outgoing;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReactiveMessagingExtension
implements Extension {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReactiveMessagingExtension.class);
    private List<MediatorBean<?>> mediatorBeans = new ArrayList();
    private List<InjectionPoint> streamInjectionPoints = new ArrayList<InjectionPoint>();
    private List<InjectionPoint> emitterInjectionPoints = new ArrayList<InjectionPoint>();

    <T> void processClassesContainingMediators(@Observes ProcessManagedBean<T> event) {
        AnnotatedType annotatedType = event.getAnnotatedBeanClass();
        if (annotatedType.getMethods().stream().anyMatch(m -> m.isAnnotationPresent(Incoming.class) || m.isAnnotationPresent(Outgoing.class))) {
            this.mediatorBeans.add(new MediatorBean(event.getBean(), event.getAnnotatedBeanClass()));
        }
    }

    <T extends Publisher<?>> void processStreamPublisherInjectionPoint(@Observes ProcessInjectionPoint<?, T> pip) {
        Channel stream = ChannelProducer.getChannelQualifier(pip.getInjectionPoint());
        if (stream != null) {
            this.streamInjectionPoints.add(pip.getInjectionPoint());
        }
    }

    <T extends Emitter<?>> void processStreamEmitterInjectionPoint(@Observes ProcessInjectionPoint<?, T> pip) {
        Channel stream = ChannelProducer.getChannelQualifier(pip.getInjectionPoint());
        if (stream != null) {
            this.emitterInjectionPoints.add(pip.getInjectionPoint());
        }
    }

    <T extends PublisherBuilder<?>> void processStreamPublisherBuilderInjectionPoint(@Observes ProcessInjectionPoint<?, T> pip) {
        Channel stream = ChannelProducer.getChannelQualifier(pip.getInjectionPoint());
        if (stream != null) {
            this.streamInjectionPoints.add(pip.getInjectionPoint());
        }
    }

    void afterDeploymentValidation(@Observes AfterDeploymentValidation done, BeanManager beanManager) {
        Instance instance = beanManager.createInstance();
        ChannelRegistry registry = (ChannelRegistry)instance.select(ChannelRegistry.class, new Annotation[0]).get();
        HashMap<String, OnOverflow> emitters = new HashMap<String, OnOverflow>();
        for (InjectionPoint injectionPoint : this.emitterInjectionPoints) {
            String string = ChannelProducer.getChannelName(injectionPoint);
            OnOverflow onOverflow = (OnOverflow)injectionPoint.getAnnotated().getAnnotation(OnOverflow.class);
            emitters.put(string, onOverflow);
        }
        this.emitterInjectionPoints.stream().map(ChannelProducer::getChannelName).collect(Collectors.toList());
        MediatorManager mediatorManager = (MediatorManager)instance.select(MediatorManager.class, new Annotation[0]).get();
        mediatorManager.initializeEmitters(emitters);
        for (MediatorBean<?> mediatorBean : this.mediatorBeans) {
            LOGGER.info("Analyzing mediator bean: {}", mediatorBean.bean);
            mediatorManager.analyze(mediatorBean.annotatedType, mediatorBean.bean);
        }
        this.mediatorBeans.clear();
        try {
            String name;
            mediatorManager.initializeAndRun();
            Set<String> set = registry.getIncomingNames();
            for (InjectionPoint ip : this.streamInjectionPoints) {
                name = ChannelProducer.getChannelName(ip);
                if (set.contains(name)) continue;
                done.addDeploymentProblem((Throwable)new DeploymentException("No channel found for name: " + name + ", injection point: " + ip));
            }
            this.streamInjectionPoints.clear();
            for (InjectionPoint ip : this.emitterInjectionPoints) {
                name = ChannelProducer.getChannelName(ip);
                EmitterImpl emitter = (EmitterImpl)registry.getEmitter(name);
                if (emitter.isConnected()) continue;
                done.addDeploymentProblem((Throwable)new DeploymentException("No channel found for name: " + name + ", injection point: " + ip));
            }
        }
        catch (Exception exception) {
            if (exception.getCause() == null) {
                done.addDeploymentProblem((Throwable)exception);
            }
            done.addDeploymentProblem(exception.getCause());
        }
    }

    static class MediatorBean<T> {
        final Bean<T> bean;
        final AnnotatedType<T> annotatedType;

        MediatorBean(Bean<T> bean, AnnotatedType<T> annotatedType) {
            this.bean = bean;
            this.annotatedType = annotatedType;
        }
    }
}

