/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.artifact.zip.cache.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.artifact.zip.cache.internal.ZipFileData;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ZipFileDataStore {
    private final String name;
    private final Map<String, Cell> cells;
    private final Cell anchor;
    private static final boolean NULL_DATA = true;
    private static final boolean NON_NULL_DATA = false;
    protected static final boolean DISPLAY_FULLY = true;
    protected static final boolean DISPLAY_SPARSELY = false;
    static final long serialVersionUID = 3042473088738518183L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ZipFileDataStore(String name) {
        this.name = name;
        this.cells = new HashMap<String, Cell>();
        this.anchor.next = this.anchor = new Cell(null);
        this.anchor.prev = this.anchor;
    }

    @Trivial
    public String getName() {
        return this.name;
    }

    @Trivial
    public boolean isEmpty() {
        return this.cells.isEmpty();
    }

    @Trivial
    public int size() {
        return this.cells.size();
    }

    @Trivial
    public boolean hasOne() {
        return this.cells.size() == 1;
    }

    @Trivial
    public Cell getCell(String path) {
        return this.cells.get(path);
    }

    @Trivial
    public Cell getFirstCell() {
        Cell firstCell = this.anchor.next;
        if (firstCell == this.anchor) {
            return null;
        }
        return firstCell;
    }

    @Trivial
    public Cell getLastCell() {
        Cell lastCell = this.anchor.prev;
        if (lastCell == this.anchor) {
            return null;
        }
        return lastCell;
    }

    @Trivial
    public ZipFileData get(String path) {
        Cell cell = this.cells.get(path);
        return cell == null ? null : cell.data;
    }

    @Trivial
    public ZipFileData getFirst() {
        Cell firstCell = this.getFirstCell();
        return firstCell == null ? null : firstCell.data;
    }

    @Trivial
    public ZipFileData getLast() {
        Cell lastCell = this.getLastCell();
        return lastCell == null ? null : lastCell.data;
    }

    @Trivial
    public Iterator<ZipFileData> values() {
        return new CellIterator();
    }

    @Trivial
    public ZipFileData remove(String path) {
        Cell cell = this.cells.remove(path);
        if (cell == null) {
            return null;
        }
        ZipFileData data = cell.data;
        cell.excise();
        return data;
    }

    public ZipFileData addFirst(ZipFileData newFirstData) {
        String newFirstPath = newFirstData.path;
        Cell dupCell = this.cells.get(newFirstPath);
        if (dupCell != null) {
            throw new IllegalArgumentException("Path [ " + newFirstPath + " ] is already stored");
        }
        Cell oldFirstCell = this.anchor.next;
        Cell newFirstCell = new Cell(newFirstData);
        this.cells.put(newFirstPath, newFirstCell);
        newFirstCell.putBetween(this.anchor, oldFirstCell);
        return oldFirstCell.data;
    }

    public ZipFileData addLast(ZipFileData newLastData) {
        String newLastPath = newLastData.path;
        Cell dupCell = this.cells.get(newLastPath);
        if (dupCell != null) {
            throw new IllegalArgumentException("Path [ " + newLastPath + " ] is already stored");
        }
        Cell oldLastCell = this.anchor.prev;
        Cell newLastCell = new Cell(newLastData);
        this.cells.put(newLastPath, newLastCell);
        newLastCell.putBetween(oldLastCell, this.anchor);
        return oldLastCell.data;
    }

    public ZipFileData addLast(ZipFileData newLastData, int maximumSize) {
        if (maximumSize == -1 || this.cells.size() < maximumSize) {
            this.addLast(newLastData);
            return null;
        }
        String newLastPath = newLastData.path;
        Cell dupCell = this.cells.get(newLastPath);
        if (dupCell != null) {
            throw new IllegalArgumentException("Path [ " + newLastPath + " ] is already stored");
        }
        Cell oldFirstCell = this.anchor.next;
        ZipFileData oldFirstData = oldFirstCell.data;
        String oldFirstPath = oldFirstData.path;
        if (oldFirstCell != this.cells.remove(oldFirstPath)) {
            throw new IllegalStateException("Bad cell alignment on path [ " + oldFirstPath + " ]");
        }
        Cell newLastCell = new Cell(newLastData);
        this.cells.put(newLastPath, newLastCell);
        oldFirstCell.excise();
        newLastCell.putBetween(this.anchor.prev, this.anchor);
        return oldFirstData;
    }

    public void display() {
        System.out.println("Store [ " + this.name + " ]");
        int cellNo = 0;
        Cell next = this.anchor;
        this.display(cellNo, next);
        while ((next = next.next) != this.anchor) {
            this.display(++cellNo, next);
        }
    }

    private void display(int cellNo, Cell cell) {
        String thisCell = this.cellText(cellNo, cell);
        String prevCell = this.cellText(cellNo - 1, cell.prev);
        String nextCell = this.cellText(cellNo + 1, cell.next);
        System.out.println("  Cell " + thisCell + " Prev " + prevCell + " Next " + nextCell);
    }

    public void validate() {
        int cellNo = 0;
        Cell next = this.anchor;
        this.validate(0, next, true);
        while ((next = next.next) != this.anchor) {
            this.validate(++cellNo, next, false);
        }
    }

    private String cellText(int cellNo, Cell cell) {
        if (cell == null) {
            return "[ " + this.name + " : " + cellNo + " ] [ *** NULL CELL *** ]";
        }
        ZipFileData data = cell.data;
        if (data == null) {
            return "[ " + this.name + " : " + cellNo + " ]";
        }
        return "[ " + this.name + " : " + cellNo + " ] [ " + data.path + " ]";
    }

    private void validate(int cellNo, Cell cell, boolean nullData) {
        if (nullData) {
            if (cell.data != null) {
                throw new IllegalStateException("Non-null data " + this.cellText(cellNo, cell));
            }
        } else if (cell.data == null) {
            throw new IllegalStateException("Null data " + this.cellText(cellNo, cell));
        }
        if (cell.next == null) {
            throw new IllegalStateException("Null next " + this.cellText(cellNo, cell));
        }
        if (cell.prev == null) {
            throw new IllegalStateException("Null prev " + this.cellText(cellNo, cell));
        }
        if (cell.next.prev == null) {
            throw new IllegalStateException("Null next.prev " + this.cellText(cellNo, cell) + " " + this.cellText(cellNo + 1, cell.next));
        }
        if (cell.next.prev != cell) {
            throw new IllegalStateException("Non-returning next.prev " + this.cellText(cellNo, cell) + " " + this.cellText(cellNo + 1, cell.next) + " " + this.cellText(cellNo, cell.next.prev));
        }
        if (cell.prev.next == null) {
            throw new IllegalStateException("Null prev.next " + this.cellText(cellNo, cell) + " " + this.cellText(cellNo - 1, cell.prev));
        }
        if (cell.prev.next != cell) {
            throw new IllegalStateException("Non-returning prev.next " + this.cellText(cellNo, cell) + " " + this.cellText(cellNo + 1, cell.prev) + " " + this.cellText(cellNo, cell.prev.next));
        }
    }

    protected void introspect(PrintWriter output, boolean displayFully, long introspectAt) {
        output.println();
        output.println("Zip File Data [ " + this.getName() + " ]");
        if (this.isEmpty()) {
            output.println("  ** NONE **");
        } else {
            Iterator<ZipFileData> values = this.values();
            while (values.hasNext()) {
                if (displayFully) {
                    output.println();
                    values.next().introspect(output, introspectAt);
                    continue;
                }
                output.println("  [ " + values.next().getPath() + " ]");
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.zip.cache.internal.ZipFileDataStore", ZipFileDataStore.class, (String)"archive.artifact", null);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class Cell {
        public final ZipFileData data;
        public Cell prev;
        public Cell next;
        static final long serialVersionUID = -7036187261798813463L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Trivial
        public Cell(ZipFileData data) {
            this.data = data;
            this.prev = null;
            this.next = null;
        }

        @Trivial
        public void excise() {
            if (this.next == this) {
                throw new IllegalArgumentException("Cannot excise the anchor");
            }
            this.next.prev = this.prev;
            this.prev.next = this.next;
            this.prev = null;
            this.next = null;
        }

        @Trivial
        public void putBetween(Cell prevCell, Cell nextCell) {
            if (this == prevCell) {
                throw new IllegalArgumentException("Cannot put a cell after itself");
            }
            if (this == nextCell) {
                throw new IllegalArgumentException("Cannot put a cell before itself");
            }
            this.next = nextCell;
            nextCell.prev = this;
            this.prev = prevCell;
            prevCell.next = this;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.zip.cache.internal.ZipFileDataStore$Cell", Cell.class, (String)"archive.artifact", null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class CellIterator
    implements Iterator<ZipFileData> {
        private Cell prev = null;
        private Cell next;
        static final long serialVersionUID = -569095838210730743L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Trivial
        public CellIterator() {
            this.next = ((ZipFileDataStore)ZipFileDataStore.this).anchor.next;
        }

        @Override
        @Trivial
        public boolean hasNext() {
            return this.next != ZipFileDataStore.this.anchor;
        }

        @Override
        @Trivial
        public ZipFileData next() {
            if (this.next == ZipFileDataStore.this.anchor) {
                throw new NoSuchElementException();
            }
            this.prev = this.next;
            this.next = this.prev.next;
            return this.prev.data;
        }

        @Override
        @Trivial
        public void remove() {
            if (this.prev == null) {
                throw new IllegalStateException("'next()' has not been called");
            }
            ZipFileData prevData = ZipFileDataStore.this.remove(this.prev.data.path);
            this.prev = null;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.zip.cache.internal.ZipFileDataStore$CellIterator", CellIterator.class, (String)"archive.artifact", null);
        }
    }
}

