/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.internal.models;

import io.smallrye.openapi.model.BaseExtensibleModel;
import io.smallrye.openapi.model.DataType;
import io.smallrye.openapi.model.OpenApiVersion;
import io.smallrye.openapi.model.PropertyMetadata;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.ExternalDocumentation;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.info.Info;
import org.eclipse.microprofile.openapi.models.security.SecurityRequirement;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.eclipse.microprofile.openapi.models.tags.Tag;

public abstract class AbstractOpenAPI
extends BaseExtensibleModel<OpenAPI>
implements OpenAPI {
    public static final PropertyMetadata PROPERTIES = new Properties();

    public PropertyMetadata getPropertyMetadata() {
        return PROPERTIES;
    }

    protected OpenAPI filter(OASFilter filter) {
        filter.filterOpenAPI((OpenAPI)this);
        return this;
    }

    public String getOpenapi() {
        return (String)this.getProperty("openapi", String.class);
    }

    public void setOpenapi(String newValue) {
        this.setProperty("openapi", newValue);
    }

    public Info getInfo() {
        return (Info)this.getProperty("info", Info.class);
    }

    public void setInfo(Info newValue) {
        this.setProperty("info", newValue);
    }

    public List<Server> getServers() {
        return this.getListProperty("servers");
    }

    public void setServers(List<Server> newValue) {
        this.setListProperty("servers", newValue);
    }

    public AbstractOpenAPI addServer(Server newValue) {
        this.addListPropertyEntry("servers", newValue);
        return this;
    }

    public void removeServer(Server value) {
        this.removeListPropertyEntry("servers", value);
    }

    public List<SecurityRequirement> getSecurity() {
        return this.getListProperty("security");
    }

    public void setSecurity(List<SecurityRequirement> newValue) {
        this.setListProperty("security", newValue);
    }

    public AbstractOpenAPI addSecurityRequirement(SecurityRequirement newValue) {
        this.addListPropertyEntry("security", newValue);
        return this;
    }

    public void removeSecurityRequirement(SecurityRequirement value) {
        this.removeListPropertyEntry("security", value);
    }

    public List<Tag> getTags() {
        return this.getListProperty("tags");
    }

    public void setTags(List<Tag> newValue) {
        this.setListProperty("tags", newValue);
    }

    public AbstractOpenAPI addTag(Tag newValue) {
        this.addListPropertyEntry("tags", newValue);
        return this;
    }

    public void removeTag(Tag value) {
        this.removeListPropertyEntry("tags", value);
    }

    public Paths getPaths() {
        return (Paths)this.getProperty("paths", Paths.class);
    }

    public void setPaths(Paths newValue) {
        this.setProperty("paths", newValue);
    }

    public Map<String, PathItem> getWebhooks() {
        return this.getMapProperty("webhooks");
    }

    public void setWebhooks(Map<String, PathItem> newValue) {
        this.setMapProperty("webhooks", newValue);
    }

    public AbstractOpenAPI addWebhook(String newKey, PathItem newValue) {
        Objects.requireNonNull(newKey, "Key must not be null");
        Objects.requireNonNull(newValue, "Value must not be null");
        this.putMapPropertyEntry("webhooks", newKey, newValue);
        return this;
    }

    public void removeWebhook(String key) {
        this.removeMapPropertyEntry("webhooks", key);
    }

    public Components getComponents() {
        return (Components)this.getProperty("components", Components.class);
    }

    public void setComponents(Components newValue) {
        this.setProperty("components", newValue);
    }

    public String getJsonSchemaDialect() {
        return (String)this.getProperty("jsonSchemaDialect", String.class);
    }

    public void setJsonSchemaDialect(String newValue) {
        this.setProperty("jsonSchemaDialect", newValue);
    }

    public static class Properties
    implements PropertyMetadata {
        private final Map<String, DataType> types = new HashMap<String, DataType>(10);
        private final Map<String, OpenApiVersion> minVersions = new HashMap<String, OpenApiVersion>(10);

        public Properties() {
            this.types.put("openapi", DataType.type(String.class));
            this.minVersions.put("openapi", OpenApiVersion.V3_0);
            this.types.put("info", DataType.type(Info.class));
            this.minVersions.put("info", OpenApiVersion.V3_0);
            this.types.put("externalDocs", DataType.type(ExternalDocumentation.class));
            this.minVersions.put("externalDocs", OpenApiVersion.V3_0);
            this.types.put("servers", DataType.listOf((DataType)DataType.type(Server.class)));
            this.minVersions.put("servers", OpenApiVersion.V3_0);
            this.types.put("security", DataType.listOf((DataType)DataType.type(SecurityRequirement.class)));
            this.minVersions.put("security", OpenApiVersion.V3_0);
            this.types.put("tags", DataType.listOf((DataType)DataType.type(Tag.class)));
            this.minVersions.put("tags", OpenApiVersion.V3_0);
            this.types.put("paths", DataType.type(Paths.class));
            this.minVersions.put("paths", OpenApiVersion.V3_0);
            this.types.put("webhooks", DataType.mapOf((DataType)DataType.type(PathItem.class)));
            this.minVersions.put("webhooks", OpenApiVersion.V3_1);
            this.types.put("components", DataType.type(Components.class));
            this.minVersions.put("components", OpenApiVersion.V3_0);
            this.types.put("jsonSchemaDialect", DataType.type(String.class));
            this.minVersions.put("jsonSchemaDialect", OpenApiVersion.V3_1);
        }

        public DataType getPropertyType(String name) {
            if (this.types.containsKey(name)) {
                return this.types.get(name);
            }
            return DataType.type(Object.class);
        }

        public OpenApiVersion getMinVersion(String name) {
            return this.minVersions.getOrDefault(name, OpenApiVersion.V3_0);
        }
    }
}

