/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.netty;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.jfapchannel.framework.IOReadCompletedCallback;
import com.ibm.ws.sib.jfapchannel.framework.IOReadRequestContext;
import com.ibm.ws.sib.jfapchannel.framework.NetworkConnection;
import com.ibm.ws.sib.jfapchannel.netty.NettyIOBaseContext;
import com.ibm.ws.sib.jfapchannel.netty.NettyNetworkConnection;
import com.ibm.ws.sib.utils.ras.SibTr;
import io.netty.channel.Channel;
import java.io.EOFException;

public class NettyIOReadRequestContext
extends NettyIOBaseContext
implements IOReadRequestContext {
    private static final TraceComponent tc = SibTr.register(NettyIOReadRequestContext.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");

    public NettyIOReadRequestContext(NettyNetworkConnection conn) {
        super(conn);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{conn});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    @Override
    public NetworkConnection read(int amountToRead, IOReadCompletedCallback completionCallback, boolean forceQueue, int timeout) {
        Channel chan;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"read", (Object)new Object[]{amountToRead, completionCallback, forceQueue, timeout});
        }
        if ((chan = this.conn.getVirtualConnection()).isActive()) {
            this.conn.getVirtualConnection().read();
        } else {
            completionCallback.error(this.getNetworkConnectionInstance(chan), this, new EOFException("Read was attempted on a channel that is not active!! " + chan));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"read", null);
        }
        return null;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#) SIB/ws/code/sib.jfapchannel.client.rich.impl/src/com/ibm/ws/sib/netty/jfapchannel/NettyIOReadRequestContext.java, SIB.comms, WASX.SIB, uu1215.01 1.4");
        }
    }
}

