/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.genericbnf;

public class PasswordNullifier {
    private static final String PASSWORD_PATTERN = "password=";
    private static final String CLIENT_SECRET_PATTERN = "client_secret=";

    public static String nullifyParams(String value) {
        return PasswordNullifier.nullify(value, (byte)38);
    }

    public static String nullify(String value, byte delimiter) {
        if (null == value) {
            return null;
        }
        String source = value.toLowerCase();
        StringBuilder b = new StringBuilder(value);
        boolean modified = PasswordNullifier.optionallyMaskChars(b, source, delimiter, PASSWORD_PATTERN);
        boolean bl = modified = PasswordNullifier.optionallyMaskChars(b, source, delimiter, CLIENT_SECRET_PATTERN) || modified;
        if (modified) {
            return b.toString();
        }
        return value;
    }

    private static boolean optionallyMaskChars(StringBuilder b, String source, byte delimiter, String pattern) {
        boolean modified = false;
        int i = source.indexOf(pattern);
        while (-1 != i) {
            modified = true;
            i += pattern.length();
            while (i < source.length() && delimiter != source.charAt(i)) {
                b.setCharAt(i, '*');
                ++i;
            }
            if (i == source.length()) {
                i = -1;
                continue;
            }
            i = source.indexOf(pattern, i);
        }
        return modified;
    }
}

