/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.netty.inbound;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.dispatcher.internal.HttpDispatcher;
import com.ibm.ws.http.netty.NettyHttpConstants;
import com.ibm.ws.http.netty.inbound.NettyTCPConnectionContext;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.bytebuffer.WsByteBufferUtils;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.tcpchannel.TCPConnectionContext;
import com.ibm.wsspi.tcpchannel.TCPWriteCompletedCallback;
import com.ibm.wsspi.tcpchannel.TCPWriteRequestContext;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http2.StreamSpecificHttpContent;
import io.netty.handler.timeout.WriteTimeoutHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class NettyTCPWriteRequestContext
implements TCPWriteRequestContext {
    private static final TraceComponent tc = Tr.register(NettyTCPWriteRequestContext.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    private final NettyTCPConnectionContext connectionContext;
    private final Channel nettyChannel;
    private WsByteBuffer[] buffers;
    private Queue<Object> prefixQueue = new LinkedList<Object>();
    private final WsByteBuffer[] defaultBuffers = new WsByteBuffer[1];
    private ByteBuffer[] byteBufferArray = null;
    private ByteBuffer[] byteBufferArrayDirect = null;
    private ByteBuffer[] byteBufferArrayOf1 = null;
    private final ByteBuffer[] byteBufferArrayOf2 = null;
    private final ByteBuffer[] byteBufferArrayOf3 = null;
    private final ByteBuffer[] byteBufferArrayOf4 = null;
    private VirtualConnection vc;
    private String streamID = "-1";
    static final long serialVersionUID = -3967387381114429347L;

    public NettyTCPWriteRequestContext(NettyTCPConnectionContext connectionContext, Channel nettyChannel) {
        this.connectionContext = connectionContext;
        this.nettyChannel = nettyChannel;
    }

    public TCPConnectionContext getInterface() {
        return this.connectionContext;
    }

    public void clearBuffers() {
        if (Objects.nonNull(this.buffers)) {
            for (int i = 0; i < this.buffers.length; ++i) {
                this.buffers[i].clear();
            }
        }
    }

    public void setVC(VirtualConnection vc) {
        this.vc = vc;
    }

    public void setStreamId(String streamId) {
        this.streamID = streamId;
    }

    public Socket getSocket() {
        throw new UnsupportedOperationException("Can not get the socket from a Netty connection!");
    }

    public WsByteBuffer[] getBuffers() {
        return this.buffers;
    }

    public WsByteBuffer getBuffer() {
        if (this.buffers == null) {
            return null;
        }
        return this.buffers[0];
    }

    public void setBuffers(WsByteBuffer[] bufs) {
        if (Objects.isNull(bufs)) {
            this.clearBuffers();
            return;
        }
        this.buffers = bufs;
        if (bufs != null) {
            int numBufs = 0;
            for (WsByteBuffer buf : bufs) {
                if (buf == null) break;
                ++numBufs;
            }
            if (numBufs != bufs.length) {
                this.buffers = new WsByteBuffer[numBufs];
                System.arraycopy(bufs, 0, this.buffers, 0, numBufs);
            }
        }
        if (this.byteBufferArray != null) {
            Arrays.fill(this.byteBufferArray, null);
            this.byteBufferArray = null;
        }
        if (this.byteBufferArrayDirect != null) {
            Arrays.fill(this.byteBufferArrayDirect, null);
            this.byteBufferArrayDirect = null;
        }
        if (this.buffers != null && this.buffers.length > 0) {
            this.byteBufferArray = new ByteBuffer[this.buffers.length];
            for (int i = 0; i < this.buffers.length; ++i) {
                this.byteBufferArray[i] = this.buffers[i].getWrappedByteBufferNonSafe();
            }
        } else {
            this.byteBufferArray = null;
        }
    }

    public void setBuffer(WsByteBuffer buf) {
        int i;
        if (this.byteBufferArray != null) {
            for (i = 0; i < this.byteBufferArray.length; ++i) {
                this.byteBufferArray[i] = null;
            }
        }
        if (this.byteBufferArrayDirect != null) {
            for (i = 0; i < this.byteBufferArrayDirect.length; ++i) {
                this.byteBufferArrayDirect[i] = null;
            }
            this.byteBufferArrayDirect = null;
        }
        this.defaultBuffers[0] = null;
        if (buf != null) {
            this.buffers = this.defaultBuffers;
            this.buffers[0] = buf;
            if (this.byteBufferArrayOf1 == null) {
                this.byteBufferArrayOf1 = new ByteBuffer[1];
            }
            this.byteBufferArray = this.byteBufferArrayOf1;
            this.byteBufferArray[0] = buf.getWrappedByteBufferNonSafe();
        } else {
            this.buffers = null;
            this.byteBufferArray = null;
        }
    }

    public void queuePrefixObject(Object object) {
        this.prefixQueue.add(object);
    }

    private void awaitChannelFuture(ChannelPromise future, String failureMsg) throws IOException, InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        future.addListener(f -> latch.countDown());
        latch.await();
        if (!future.isSuccess()) {
            throw new IOException(failureMsg, future.cause());
        }
    }

    private void verifyTimeout(int timeout) {
        long timeoutNanos = TimeUnit.MILLISECONDS.toNanos(timeout);
        WriteTimeoutHandler timeoutHandler = (WriteTimeoutHandler)this.nettyChannel.pipeline().get(WriteTimeoutHandler.class);
        if (Objects.isNull(timeoutHandler)) {
            this.nettyChannel.pipeline().addLast("writeTimeoutHandler", (ChannelHandler)new WriteTimeoutHandler((long)timeout, TimeUnit.MILLISECONDS));
        } else if (timeoutHandler.getTimeout() != timeoutNanos) {
            timeoutHandler.setTimeout((long)timeout, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - void declaration
     */
    public long write(long numBytes, int timeout) throws IOException {
        boolean hasContentLength;
        if (this.nettyChannel.eventLoop().inEventLoop()) {
            throw new IllegalStateException("Cannot invoke a blocking write on the Netty event loop thread.");
        }
        this.verifyTimeout(timeout);
        long writtenBytes = 0L;
        String protocol = (String)this.nettyChannel.attr(NettyHttpConstants.PROTOCOL).get();
        final LinkedList<Object> writeQueue = new LinkedList<Object>();
        final ChannelPromise writePromise = this.nettyChannel.newPromise();
        boolean isHttp10 = "HTTP10".equals(protocol);
        boolean isWsoc = "WebSocket".equals(protocol);
        boolean isH2 = "HTTP2".equals(protocol);
        boolean bl = hasContentLength = this.nettyChannel.hasAttr(NettyHttpConstants.CONTENT_LENGTH) && this.nettyChannel.attr(NettyHttpConstants.CONTENT_LENGTH).get() != null;
        while (!this.prefixQueue.isEmpty()) {
            writeQueue.add(this.prefixQueue.poll());
        }
        try {
            for (WsByteBuffer buffer : this.buffers) {
                DefaultHttpContent httpContent;
                ByteBuf nettyBuf;
                if (buffer == null || buffer.remaining() <= 0) continue;
                if (isH2) {
                    writtenBytes += (long)buffer.remaining();
                    nettyBuf = Unpooled.wrappedBuffer((byte[])WsByteBufferUtils.asByteArray((WsByteBuffer)buffer));
                    httpContent = new StreamSpecificHttpContent(Integer.valueOf(this.streamID).intValue(), Unpooled.wrappedBuffer((byte[])WsByteBufferUtils.asByteArray((WsByteBuffer)buffer)));
                    writeQueue.add(httpContent);
                    continue;
                }
                if (hasContentLength || isWsoc || isHttp10) {
                    nettyBuf = Unpooled.wrappedBuffer((byte[])WsByteBufferUtils.asByteArray((WsByteBuffer)buffer));
                    int bytes = nettyBuf.readableBytes();
                    writeQueue.add(nettyBuf);
                    writtenBytes += (long)bytes;
                    continue;
                }
                nettyBuf = Unpooled.wrappedBuffer((byte[])WsByteBufferUtils.asByteArray((WsByteBuffer)buffer));
                httpContent = new DefaultHttpContent(nettyBuf);
                writtenBytes += (long)nettyBuf.readableBytes();
                writeQueue.add(httpContent);
            }
            this.nettyChannel.eventLoop().execute(new Runnable(){
                static final long serialVersionUID = -7512901379939287258L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public void run() {
                    for (Object writeBuffer : writeQueue) {
                        NettyTCPWriteRequestContext.this.nettyChannel.write(writeBuffer);
                    }
                    NettyTCPWriteRequestContext.this.nettyChannel.writeAndFlush((Object)Unpooled.EMPTY_BUFFER, writePromise);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.http.netty.inbound.NettyTCPWriteRequestContext$1", 1.class, null, null);
                }
            });
            this.awaitChannelFuture(writePromise, "Flush operation timed out!");
        }
        catch (InterruptedException interruptedException) {
            void e;
            FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.http.netty.inbound.NettyTCPWriteRequestContext", (String)"307", (Object)this, (Object[])new Object[]{numBytes, timeout});
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted while waiting for write to complete.", (Throwable)e);
        }
        return writtenBytes;
    }

    /*
     * WARNING - void declaration
     */
    public VirtualConnection write(long numBytes, TCPWriteCompletedCallback callback, boolean forceQueue, int timeout) {
        this.verifyTimeout(timeout);
        boolean wasWritable = this.nettyChannel.isWritable();
        long totalWrittenBytes = 0L;
        boolean hasContentLength = this.nettyChannel.hasAttr(NettyHttpConstants.CONTENT_LENGTH) && Objects.nonNull(this.nettyChannel.attr(NettyHttpConstants.CONTENT_LENGTH).get());
        final LinkedList<Object> writeQueue = new LinkedList<Object>();
        final ChannelPromise writePromise = this.nettyChannel.newPromise();
        String protocol = (String)this.nettyChannel.attr(NettyHttpConstants.PROTOCOL).get();
        boolean isHttp10 = "HTTP10".equals(protocol);
        boolean isWsoc = "WebSocket".equals(protocol);
        boolean isH2 = "HTTP2".equals(protocol);
        if (Objects.isNull(this.buffers)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Ignoring write, null buffers passed for channel: " + this.nettyChannel), (Object[])new Object[0]);
            }
            return this.vc;
        }
        while (!this.prefixQueue.isEmpty()) {
            writeQueue.add(this.prefixQueue.poll());
        }
        try {
            for (WsByteBuffer buffer : this.buffers) {
                DefaultHttpContent httpContent;
                ByteBuf nettyBuf;
                byte[] byteArray;
                if (buffer == null || !buffer.hasRemaining() || (byteArray = WsByteBufferUtils.asByteArray((WsByteBuffer)buffer)) == null) continue;
                if (isH2) {
                    totalWrittenBytes += (long)buffer.remaining();
                    nettyBuf = Unpooled.wrappedBuffer((byte[])WsByteBufferUtils.asByteArray((WsByteBuffer)buffer));
                    httpContent = new StreamSpecificHttpContent(Integer.valueOf(this.streamID).intValue(), Unpooled.wrappedBuffer((byte[])WsByteBufferUtils.asByteArray((WsByteBuffer)buffer)));
                    writeQueue.add(httpContent);
                    continue;
                }
                if (hasContentLength || isWsoc || isHttp10) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("Writing sync on channel: " + this.nettyChannel + " which is wsoc? " + isWsoc), (Object[])new Object[0]);
                    }
                    nettyBuf = Unpooled.wrappedBuffer((byte[])WsByteBufferUtils.asByteArray((WsByteBuffer)buffer));
                    totalWrittenBytes += (long)nettyBuf.readableBytes();
                    writeQueue.add(nettyBuf);
                    continue;
                }
                nettyBuf = Unpooled.wrappedBuffer((byte[])WsByteBufferUtils.asByteArray((WsByteBuffer)buffer));
                httpContent = new DefaultHttpContent(nettyBuf);
                totalWrittenBytes += (long)nettyBuf.readableBytes();
                writeQueue.add(httpContent);
            }
            this.nettyChannel.eventLoop().execute(new Runnable(){
                static final long serialVersionUID = 5467629429257156574L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public void run() {
                    for (Object writeBuffer : writeQueue) {
                        NettyTCPWriteRequestContext.this.nettyChannel.write(writeBuffer);
                    }
                    NettyTCPWriteRequestContext.this.nettyChannel.writeAndFlush((Object)Unpooled.EMPTY_BUFFER, writePromise);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.http.netty.inbound.NettyTCPWriteRequestContext$2", 2.class, null, null);
                }
            });
            boolean stillWritable = this.nettyChannel.isWritable();
            if (Objects.isNull(callback)) {
                return null;
            }
            if (writePromise == null && wasWritable && stillWritable && totalWrittenBytes >= numBytes) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Found writePromise to be null or unable to keep writing on channel: " + this.nettyChannel), (Object[])new Object[0]);
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("writePromise: " + writePromise + " wasWritable: " + wasWritable + " stillWritable: " + stillWritable + " totalWrittenBytes: " + totalWrittenBytes + " numBytes: " + numBytes), (Object[])new Object[0]);
                }
                if (forceQueue) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("Forcing callback on channel: " + this.nettyChannel), (Object[])new Object[0]);
                    }
                    HttpDispatcher.getExecutorService().submit(() -> {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)("Calling callback in asynchronous thread for channel: " + this.nettyChannel), (Object[])new Object[0]);
                        }
                        callback.complete(this.vc, (TCPWriteRequestContext)this);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)("Finished callback in asynchronous thread for channel: " + this.nettyChannel), (Object[])new Object[0]);
                        }
                    });
                    return null;
                }
                return this.vc;
            }
            if (writePromise != null) {
                if (writePromise.isDone()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("Found writePromise to be finished on channel: " + this.nettyChannel), (Object[])new Object[0]);
                    }
                    if (forceQueue) {
                        HttpDispatcher.getExecutorService().submit(() -> {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((Object)this, (TraceComponent)tc, (String)("Calling callback in asynchronous thread for channel: " + this.nettyChannel), (Object[])new Object[0]);
                            }
                            callback.complete(this.vc, (TCPWriteRequestContext)this);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((Object)this, (TraceComponent)tc, (String)("Finished callback in asynchronous thread for channel: " + this.nettyChannel), (Object[])new Object[0]);
                            }
                        });
                        return null;
                    }
                    return this.vc;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Went async, found writePromise to be running on channel: " + this.nettyChannel), (Object[])new Object[0]);
                }
                writePromise.addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                    boolean succeeded = future.isSuccess();
                    HttpDispatcher.getExecutorService().submit(() -> {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)("Listener called with success? " + succeeded + " for channel: " + this.nettyChannel), (Object[])new Object[0]);
                        }
                        if (succeeded) {
                            callback.complete(this.vc, (TCPWriteRequestContext)this);
                        } else {
                            callback.error(this.vc, (TCPWriteRequestContext)this, future.cause() instanceof IOException ? (IOException)future.cause() : new IOException(future.cause()));
                        }
                    });
                }));
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("In else block with writePromise being null for channel: " + this.nettyChannel), (Object[])new Object[0]);
            }
        }
        catch (Exception stillWritable) {
            void e;
            FFDCFilter.processException((Throwable)stillWritable, (String)"com.ibm.ws.http.netty.inbound.NettyTCPWriteRequestContext", (String)"470", (Object)this, (Object[])new Object[]{numBytes, callback, forceQueue, timeout});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Caught exception on channel: " + this.nettyChannel + " , " + e), (Object[])new Object[0]);
            }
            callback.error(this.vc, null, new IOException((Throwable)e));
        }
        return null;
    }
}

