/*
 * Decompiled with CFR 0.152.
 */
package jakarta.ws.rs;

import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.net.URI;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.net.ssl.SSLContext;

public interface SeBootstrap {
    public static CompletionStage<Instance> start(Application application, Configuration configuration) {
        return RuntimeDelegate.getInstance().bootstrap(application, configuration);
    }

    public static CompletionStage<Instance> start(Application application) {
        Configuration configuration = Configuration.builder().build();
        return SeBootstrap.start(application, configuration);
    }

    public static CompletionStage<Instance> start(Class<? extends Application> clazz, Configuration configuration) {
        return RuntimeDelegate.getInstance().bootstrap(clazz, configuration);
    }

    public static CompletionStage<Instance> start(Class<? extends Application> clazz) {
        Configuration configuration = Configuration.builder().build();
        return SeBootstrap.start(clazz, configuration);
    }

    public static interface Configuration {
        public static final String PROTOCOL = "jakarta.ws.rs.SeBootstrap.Protocol";
        public static final String HOST = "jakarta.ws.rs.SeBootstrap.Host";
        public static final String PORT = "jakarta.ws.rs.SeBootstrap.Port";
        public static final String ROOT_PATH = "jakarta.ws.rs.SeBootstrap.RootPath";
        public static final String SSL_CONTEXT = "jakarta.ws.rs.SeBootstrap.SSLContext";
        public static final String SSL_CLIENT_AUTHENTICATION = "jakarta.ws.rs.SeBootstrap.SSLClientAuthentication";
        public static final int FREE_PORT = 0;
        public static final int DEFAULT_PORT = -1;

        public Object property(String var1);

        default public boolean hasProperty(String name) {
            return this.property(name) != null;
        }

        default public String protocol() {
            return (String)this.property(PROTOCOL);
        }

        default public String host() {
            return (String)this.property(HOST);
        }

        default public int port() {
            return (Integer)this.property(PORT);
        }

        default public String rootPath() {
            return (String)this.property(ROOT_PATH);
        }

        default public SSLContext sslContext() {
            return (SSLContext)this.property(SSL_CONTEXT);
        }

        default public SSLClientAuthentication sslClientAuthentication() {
            return (SSLClientAuthentication)((Object)this.property(SSL_CLIENT_AUTHENTICATION));
        }

        default public UriBuilder baseUriBuilder() {
            return UriBuilder.newInstance().scheme(this.protocol().toLowerCase()).host(this.host()).port(this.port()).path(this.rootPath());
        }

        default public URI baseUri() {
            return this.baseUriBuilder().build(new Object[0]);
        }

        public static Builder builder() {
            return RuntimeDelegate.getInstance().createConfigurationBuilder();
        }

        public static enum SSLClientAuthentication {
            NONE,
            OPTIONAL,
            MANDATORY;

        }

        public static interface Builder {
            public Configuration build();

            public Builder property(String var1, Object var2);

            default public Builder protocol(String protocol) {
                return this.property(Configuration.PROTOCOL, protocol);
            }

            default public Builder host(String host) {
                return this.property(Configuration.HOST, host);
            }

            default public Builder port(Integer port) {
                return this.property(Configuration.PORT, port);
            }

            default public Builder rootPath(String rootPath) {
                return this.property(Configuration.ROOT_PATH, rootPath);
            }

            default public Builder sslContext(SSLContext sslContext) {
                return this.property(Configuration.SSL_CONTEXT, sslContext);
            }

            default public Builder sslClientAuthentication(SSLClientAuthentication sslClientAuthentication) {
                return this.property(Configuration.SSL_CLIENT_AUTHENTICATION, (Object)sslClientAuthentication);
            }

            public <T> Builder from(BiFunction<String, Class<T>, Optional<T>> var1);

            default public Builder from(Object externalConfig) {
                return this;
            }
        }
    }

    public static interface Instance {
        public Configuration configuration();

        public CompletionStage<StopResult> stop();

        public <T> T unwrap(Class<T> var1);

        default public void stopOnShutdown(Consumer<StopResult> consumer) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> this.stop().thenAccept(consumer)));
        }

        public static interface StopResult {
            public <T> T unwrap(Class<T> var1);
        }
    }
}

