/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.client.header;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.eclipse.microprofile.rest.client.RestClientDefinitionException;
import org.eclipse.microprofile.rest.client.annotation.RegisterClientHeaders;
import org.eclipse.microprofile.rest.client.ext.ClientHeadersFactory;
import org.eclipse.microprofile.rest.client.ext.DefaultClientHeadersFactoryImpl;
import org.jboss.resteasy.microprofile.client.CdiConstructorInjector;
import org.jboss.resteasy.microprofile.client.header.ClientHeaderProvider;
import org.jboss.resteasy.microprofile.client.header.HeaderFillerFactory;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class ClientHeaderProviders {
    private static final ClientHeadersFactory defaultHeadersFactory;
    private final Map<Method, ClientHeaderProvider> providersForMethod = new ConcurrentHashMap<Method, ClientHeaderProvider>();
    private final Map<Class<?>, ClientHeadersFactory> headerFactoriesForClass = new ConcurrentHashMap();
    private static final HeaderFillerFactory fillerFactory;
    static final long serialVersionUID = -8757133111429647797L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public Optional<ClientHeaderProvider> getProvider(Method method) {
        return Optional.ofNullable(this.providersForMethod.get(method));
    }

    public Optional<ClientHeadersFactory> getFactory(Class<?> aClass) {
        return Optional.ofNullable(this.headerFactoriesForClass.get(aClass));
    }

    @Deprecated
    public void registerForClass(Class<?> clientClass, Object clientProxy) {
        this.registerForClass(clientClass, clientProxy, null);
    }

    public void registerForClass(Class<?> clientClass, Object clientProxy, BeanManager beanManager) {
        Stream.of(clientClass.getMethods()).forEach(m -> this.registerForMethod((Method)m, clientProxy));
        this.registerHeaderFactory(clientClass, beanManager);
    }

    private void registerHeaderFactory(Class<?> aClass, BeanManager beanManager) {
        RegisterClientHeaders annotation = aClass.getAnnotation(RegisterClientHeaders.class);
        if (annotation != null) {
            Optional<ClientHeadersFactory> clientHeadersFactory = this.getCustomHeadersFactory(annotation, aClass, beanManager);
            this.headerFactoriesForClass.put(aClass, clientHeadersFactory.orElse(defaultHeadersFactory));
        }
    }

    private Optional<ClientHeadersFactory> getCustomHeadersFactory(RegisterClientHeaders annotation, Class<?> source, BeanManager beanManager) {
        Class factoryClass = annotation.value();
        try {
            return Optional.of(this.construct(factoryClass, beanManager));
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RestClientDefinitionException("Failed to instantiate " + factoryClass.getCanonicalName() + ", the client header factory for " + source.getCanonicalName(), (Throwable)e);
        }
    }

    private void registerForMethod(Method method, Object clientProxy) {
        ClientHeaderProvider.forMethod(method, clientProxy, fillerFactory).ifPresent(provider -> this.providersForMethod.put(method, (ClientHeaderProvider)provider));
    }

    private ClientHeadersFactory construct(Class<? extends ClientHeadersFactory> factory, BeanManager manager) throws IllegalAccessException, InstantiationException {
        Set beans;
        if (manager != null && !(beans = manager.getBeans(factory, new Annotation[0])).isEmpty()) {
            CdiConstructorInjector injector = new CdiConstructorInjector(factory, manager);
            return factory.cast(injector.construct(false));
        }
        return factory.newInstance();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        HeaderFillerFactory result;
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.microprofile.client.header.ClientHeaderProviders", ClientHeaderProviders.class, null, null);
        defaultHeadersFactory = new DefaultClientHeadersFactoryImpl();
        PrivilegedAction<HeaderFillerFactory> action = () -> {
            ServiceLoader<HeaderFillerFactory> fillerFactories = ServiceLoader.load(HeaderFillerFactory.class);
            int highestPrio = Integer.MIN_VALUE;
            HeaderFillerFactory result = null;
            for (HeaderFillerFactory factory : fillerFactories) {
                if (factory.getPriority() <= highestPrio) continue;
                highestPrio = factory.getPriority();
                result = factory;
            }
            return result;
        };
        HeaderFillerFactory headerFillerFactory = result = System.getSecurityManager() == null ? action.run() : AccessController.doPrivileged(action);
        if (result == null) {
            throw new IllegalStateException("Unable to find a HeaderFillerFactory implementation");
        }
        fillerFactory = result;
    }
}

