/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.navigator;

import com.ibm.jbatch.container.navigator.AbstractNavigatorImpl;
import com.ibm.jbatch.container.navigator.IllegalTransitionException;
import com.ibm.jbatch.container.navigator.ModelNavigator;
import com.ibm.jbatch.container.status.ExecutionStatus;
import com.ibm.jbatch.jsl.model.JSLJob;
import com.ibm.jbatch.jsl.model.helper.ExecutionElement;
import com.ibm.jbatch.jsl.model.helper.Transition;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class JobNavigatorImpl
extends AbstractNavigatorImpl<JSLJob>
implements ModelNavigator<JSLJob> {
    private static final Logger logger = Logger.getLogger(JobNavigatorImpl.class.getName());
    private JSLJob job;
    static final long serialVersionUID = 2533622155070907537L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobNavigatorImpl(JSLJob job) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.navigator.JobNavigatorImpl", "<init>", new Object[]{job});
        }
        this.job = null;
        this.job = job;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.navigator.JobNavigatorImpl", "<init>", this);
        }
    }

    public String toString() {
        return "JobNavigatorImpl for job id = " + (this.job != null ? this.job.getId() : "null");
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ExecutionElement getFirstExecutionElement(String restartOn) throws IllegalTransitionException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.navigator.JobNavigatorImpl", "getFirstExecutionElement", new Object[]{restartOn});
        }
        logger.fine("Getting first execution element in job, restartOn = " + restartOn);
        ExecutionElement firstElem = this.getFirstExecutionElement(this.job.getExecutionElements(), restartOn);
        logger.fine("Got first execution element in job = " + firstElem.getId());
        ExecutionElement executionElement = firstElem;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            executionElement = executionElement;
            logger.exiting("com.ibm.jbatch.container.navigator.JobNavigatorImpl", "getFirstExecutionElement", executionElement);
        }
        return executionElement;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ExecutionElement getFirstExecutionElement() throws IllegalTransitionException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.navigator.JobNavigatorImpl", "getFirstExecutionElement", new Object[0]);
        }
        ExecutionElement executionElement = this.getFirstExecutionElement(null);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            executionElement = executionElement;
            logger.exiting("com.ibm.jbatch.container.navigator.JobNavigatorImpl", "getFirstExecutionElement", executionElement);
        }
        return executionElement;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Transition getNextTransition(ExecutionElement currentExecutionElem, ExecutionStatus currentStatus) throws IllegalTransitionException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.navigator.JobNavigatorImpl", "getNextTransition", new Object[]{currentExecutionElem, currentStatus});
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Getting next transition in job, currentExecutionElem = " + currentExecutionElem);
        }
        Transition nextTransition = this.getNextTransition(currentExecutionElem, this.job.getExecutionElements(), currentStatus);
        logger.fine("Got next transition in job = " + nextTransition);
        Transition transition = nextTransition;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            transition = transition;
            logger.exiting("com.ibm.jbatch.container.navigator.JobNavigatorImpl", "getNextTransition", transition);
        }
        return transition;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JSLJob getRootModelElement() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.navigator.JobNavigatorImpl", "getRootModelElement", new Object[0]);
        }
        JSLJob jSLJob = this.job;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jSLJob = jSLJob;
            logger.exiting("com.ibm.jbatch.container.navigator.JobNavigatorImpl", "getRootModelElement", jSLJob);
        }
        return jSLJob;
    }
}

