/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.ui;

import jakarta.faces.component.UIComponent;
import jakarta.faces.view.facelets.ComponentConfig;
import jakarta.faces.view.facelets.ComponentHandler;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.MetaRuleset;
import jakarta.faces.view.facelets.Metadata;
import jakarta.faces.view.facelets.TagAttribute;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.HashSet;
import java.util.Map;

public class RepeatHandler
extends ComponentHandler {
    public RepeatHandler(ComponentConfig config) {
        super(config);
    }

    protected MetaRuleset createMetaRuleset(Class type) {
        MetaRuleset meta = super.createMetaRuleset(type);
        if (!("jakarta.faces.facelets".equals(this.tag.getNamespace()) || "http://xmlns.jcp.org/jsf/facelets".equals(this.tag.getNamespace()) || "http://java.sun.com/jsf/facelets".equals(this.tag.getNamespace()))) {
            meta.add((Metadata)new TagMetaData(type));
        }
        meta.alias("class", "styleClass");
        return meta;
    }

    private class TagMetaData
    extends Metadata {
        private final String[] _attrs;

        public TagMetaData(Class<?> type) {
            HashSet<String> names = new HashSet<String>();
            for (TagAttribute tagAttribute : RepeatHandler.this.tag.getAttributes().getAll()) {
                if ("class".equals(tagAttribute.getLocalName())) {
                    names.add("styleClass");
                    continue;
                }
                names.add(tagAttribute.getLocalName());
            }
            try {
                for (PropertyDescriptor propertyDescriptor : Introspector.getBeanInfo(type).getPropertyDescriptors()) {
                    if (propertyDescriptor.getWriteMethod() == null) continue;
                    names.remove(propertyDescriptor.getName());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._attrs = names.toArray(new String[names.size()]);
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            UIComponent component = (UIComponent)instance;
            Map attrs = component.getAttributes();
            attrs.put("alias.element", RepeatHandler.this.tag.getQName());
            if (this._attrs.length > 0) {
                attrs.put("alias.attributes", this._attrs);
            }
        }
    }
}

