/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.bcpg.AEADEncDataPacket;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.bcpg.SymmetricKeyEncSessionPacket;
import org.bouncycastle.bcpg.SymmetricKeyUtils;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.generators.HKDFBytesGenerator;
import org.bouncycastle.crypto.params.HKDFParameters;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSessionKey;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.PBEDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JceAEADCipherUtil;
import org.bouncycastle.openpgp.operator.jcajce.JceAEADUtil;
import org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;

public class JcePBEDataDecryptorFactoryBuilder {
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private JceAEADUtil aeadHelper = new JceAEADUtil(this.helper);
    private PGPDigestCalculatorProvider calculatorProvider;

    public JcePBEDataDecryptorFactoryBuilder() {
        this.calculatorProvider = null;
    }

    public JcePBEDataDecryptorFactoryBuilder(PGPDigestCalculatorProvider pGPDigestCalculatorProvider) {
        this.calculatorProvider = pGPDigestCalculatorProvider;
    }

    public JcePBEDataDecryptorFactoryBuilder setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        this.aeadHelper = new JceAEADUtil(this.helper);
        return this;
    }

    public JcePBEDataDecryptorFactoryBuilder setProvider(String string) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(string));
        this.aeadHelper = new JceAEADUtil(this.helper);
        return this;
    }

    public PBEDataDecryptorFactory build(char[] cArray) {
        if (this.calculatorProvider == null) {
            try {
                this.calculatorProvider = new JcaPGPDigestCalculatorProviderBuilder(this.helper).build();
            }
            catch (PGPException pGPException) {
                throw new IllegalStateException("digest calculator provider cannot be built with current helper: " + pGPException.getMessage());
            }
        }
        return new PBEDataDecryptorFactory(cArray, this.calculatorProvider){

            @Override
            public byte[] recoverSessionData(int n, byte[] byArray, byte[] byArray2) throws PGPException {
                try {
                    if (byArray2 != null && byArray2.length > 0) {
                        String string = PGPUtil.getSymmetricCipherName(n);
                        Cipher cipher = JcePBEDataDecryptorFactoryBuilder.this.helper.createCipher(string + "/CFB/NoPadding");
                        cipher.init(2, (Key)new SecretKeySpec(byArray, string), new IvParameterSpec(new byte[cipher.getBlockSize()]));
                        return cipher.doFinal(byArray2);
                    }
                    byte[] byArray3 = new byte[byArray.length + 1];
                    byArray3[0] = (byte)n;
                    System.arraycopy(byArray, 0, byArray3, 1, byArray.length);
                    return byArray3;
                }
                catch (Exception exception) {
                    throw new PGPException("Exception recovering session info", exception);
                }
            }

            @Override
            public byte[] recoverAEADEncryptedSessionData(SymmetricKeyEncSessionPacket symmetricKeyEncSessionPacket, byte[] byArray) throws PGPException {
                byte[] byArray2;
                if (symmetricKeyEncSessionPacket.getVersion() < 5) {
                    throw new PGPException("SKESK packet MUST be version 5 or later.");
                }
                byte[] byArray3 = symmetricKeyEncSessionPacket.getAAData();
                int n = SymmetricKeyUtils.getKeyLengthInOctets(symmetricKeyEncSessionPacket.getEncAlgorithm());
                byte[] byArray4 = new byte[n];
                HKDFBytesGenerator hKDFBytesGenerator = new HKDFBytesGenerator((Digest)new SHA256Digest());
                hKDFBytesGenerator.init((DerivationParameters)new HKDFParameters(byArray, null, byArray3));
                hKDFBytesGenerator.generateBytes(byArray4, 0, byArray4.length);
                SecretKeySpec secretKeySpec = new SecretKeySpec(byArray4, PGPUtil.getSymmetricCipherName(symmetricKeyEncSessionPacket.getEncAlgorithm()));
                Cipher cipher = JcePBEDataDecryptorFactoryBuilder.this.aeadHelper.createAEADCipher(symmetricKeyEncSessionPacket.getEncAlgorithm(), symmetricKeyEncSessionPacket.getAeadAlgorithm());
                int n2 = 128;
                byte[] byArray5 = symmetricKeyEncSessionPacket.getAuthTag();
                byte[] byArray6 = symmetricKeyEncSessionPacket.getIv();
                byte[] byArray7 = symmetricKeyEncSessionPacket.getSecKeyData();
                byte[] byArray8 = new byte[byArray7.length + byArray5.length];
                System.arraycopy(byArray7, 0, byArray8, 0, byArray7.length);
                System.arraycopy(byArray5, 0, byArray8, byArray7.length, byArray5.length);
                try {
                    JceAEADCipherUtil.setUpAeadCipher(cipher, secretKeySpec, 2, byArray6, n2, byArray3);
                    byArray2 = cipher.doFinal(byArray8, 0, byArray8.length);
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new PGPException("unable to open stream: " + generalSecurityException.getMessage());
                }
                return byArray2;
            }

            @Override
            public PGPDataDecryptor createDataDecryptor(boolean bl, int n, byte[] byArray) throws PGPException {
                return JcePBEDataDecryptorFactoryBuilder.this.helper.createDataDecryptor(bl, n, byArray);
            }

            @Override
            public PGPDataDecryptor createDataDecryptor(AEADEncDataPacket aEADEncDataPacket, PGPSessionKey pGPSessionKey) throws PGPException {
                return JcePBEDataDecryptorFactoryBuilder.this.aeadHelper.createOpenPgpV5DataDecryptor(aEADEncDataPacket, pGPSessionKey);
            }

            @Override
            public PGPDataDecryptor createDataDecryptor(SymmetricEncIntegrityPacket symmetricEncIntegrityPacket, PGPSessionKey pGPSessionKey) throws PGPException {
                return JcePBEDataDecryptorFactoryBuilder.this.aeadHelper.createOpenPgpV6DataDecryptor(symmetricEncIntegrityPacket, pGPSessionKey);
            }
        };
    }
}

