/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.webcontainer60.srt;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.servlet.request.IRequest;
import com.ibm.ws.webcontainer40.osgi.srt.SRTConnectionContext40;
import com.ibm.ws.webcontainer40.srt.SRTServletRequest40;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import io.openliberty.webcontainer60.osgi.srt.SRTConnectionContext60;
import io.openliberty.webcontainer60.srt.SRTServletConnection;
import io.openliberty.websphere.servlet60.IRequest60;
import jakarta.servlet.ServletConnection;
import jakarta.servlet.http.HttpServletRequest;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SRTServletRequest60
extends SRTServletRequest40
implements HttpServletRequest {
    protected static final Logger logger = LoggerFactory.getInstance().getLogger("io.openliberty.webcontainer60.srt");
    private static final String CLASS_NAME = SRTServletRequest60.class.getName();
    private static long startID = 1L;
    private static AtomicLong counter = new AtomicLong(startID);

    public SRTServletRequest60(SRTConnectionContext60 context) {
        super((SRTConnectionContext40)context);
    }

    public void initForNextRequest(IRequest req) {
        String methodName = "initForNextRequest";
        super.initForNextRequest(req);
        if (req != null) {
            super.setSrtRequestId(String.valueOf(counter.getAndIncrement()));
            this.initForServletConnection();
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, methodName, "this [" + String.valueOf((Object)this) + "] , request id [" + this.getRequestId() + "] , connection id [" + ((SRTServletConnection)super.getSrtServletConnection()).getConnectionId() + "] , req [" + String.valueOf(req) + "]");
            }
        }
    }

    private void initForServletConnection() {
        SRTServletConnection servletConn = new SRTServletConnection();
        servletConn.setConnectionID(String.valueOf(((IRequest60)this._request).getConnectionId()));
        servletConn.setConnectionSecure(this._request.isSSL());
        servletConn.setProtocol(this._request.getProtocol());
        super.setSrtServletConnection((Object)servletConn);
    }

    public String getRequestId() {
        String id = super.getSrtRequestId();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getRequestId", "this [" + String.valueOf((Object)this) + "] , request id [" + id + "]");
        }
        return id;
    }

    public String getProtocolRequestId() {
        String streamId = "";
        int id = ((IRequest60)this._request).getStreamId();
        if (id >= 0) {
            streamId = String.valueOf(id);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getProtocolRequestId", "this [" + String.valueOf((Object)this) + "] , returns stream id [" + streamId + "]");
        }
        return streamId;
    }

    public ServletConnection getServletConnection() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getServletConnection", "this [" + String.valueOf((Object)this) + "]");
        }
        return (ServletConnection)super.getSrtServletConnection();
    }
}

