/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.beanvalidation.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.beanvalidation.config.ValidationConfigurationInterface;
import com.ibm.ws.beanvalidation.service.BeanValidationContext;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javaee.dd.bval.Property;
import com.ibm.ws.javaee.dd.bval.ValidationConfig;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Configuration;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import javax.validation.bootstrap.ProviderSpecificBootstrap;
import javax.validation.spi.ValidationProvider;

public class ValidationConfigurator
implements ValidationConfigurationInterface {
    private static final TraceComponent tc = Tr.register(ValidationConfigurator.class, (String)"BeanValidation", (String)"com.ibm.ws.beanvalidation.resources.nls.BVNLSMessages");
    private static final String CLASS_NAME = ValidationConfigurator.class.getName();
    public static final String NEW_LINE = ValidationConfigurator.getLineSeparatorProperty();
    private final BeanValidationContext ivBVContext;
    protected int versionID;
    protected String defaultProvider;
    protected String messageInterpolator;
    protected String traversableResolver;
    protected String constraintValidatorFactory;
    protected List<String> constraintMapping = new ArrayList<String>();
    protected List<Property> properties = new ArrayList<Property>();
    private final List<InputStream> mapFileInputStreams = new ArrayList<InputStream>();
    private ClassLoader appClassloader = null;

    public ValidationConfigurator(BeanValidationContext bvContext, ValidationConfig config) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[]{bvContext, config});
        }
        this.ivBVContext = bvContext;
        this.setupData(config, bvContext.getClassLoader());
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    public ValidationConfigurator() {
        this.ivBVContext = null;
    }

    public ValidationConfigurator(BeanValidationContext bvContext) {
        this(bvContext, null);
    }

    private void setupData(ValidationConfig config, ClassLoader classLoader) {
        if (config != null) {
            this.versionID = config.getVersionID();
            this.defaultProvider = config.getDefaultProvider();
            this.defaultProvider = this.defaultProvider != null ? this.defaultProvider.trim() : this.defaultProvider;
            this.messageInterpolator = config.getMessageInterpolator();
            this.messageInterpolator = this.messageInterpolator != null ? this.messageInterpolator.trim() : this.messageInterpolator;
            this.traversableResolver = config.getTraversableResolver();
            this.traversableResolver = this.traversableResolver != null ? this.traversableResolver.trim() : this.traversableResolver;
            this.constraintMapping = config.getConstraintMappings();
            this.constraintValidatorFactory = config.getConstraintValidatorFactory();
            this.constraintValidatorFactory = this.constraintValidatorFactory != null ? this.constraintValidatorFactory.trim() : this.constraintValidatorFactory;
            this.properties = config.getProperties();
        }
        this.appClassloader = classLoader;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(NEW_LINE + "[").append(this.getClass().getName()).append(NEW_LINE);
        this.dump(sb);
        return sb.append(']').append(NEW_LINE).toString();
    }

    protected void dump(StringBuffer sb) {
        sb.append(" version: ").append(this.versionID).append(NEW_LINE);
        sb.append(" defaultProvider: ").append(this.defaultProvider).append(NEW_LINE);
        sb.append(" messageInterpolator: ").append(this.messageInterpolator).append(NEW_LINE);
        sb.append(" traversableResolver: ").append(this.traversableResolver).append(NEW_LINE);
        sb.append(" constraintValitatorFactory: ").append(this.constraintValidatorFactory).append(NEW_LINE);
        sb.append(" constraintMappings: ").append(this.constraintMapping).append(NEW_LINE);
        sb.append(" properties: ").append(this.properties).append(NEW_LINE);
        sb.append(" classLoader: ").append(this.appClassloader).append(NEW_LINE);
        sb.append(" jarFilePath: ").append(this.ivBVContext.getPath()).append(NEW_LINE);
    }

    @Override
    public Class<ValidationProvider<?>> getDefaultProviderClass() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getDefaultProviderClass");
        }
        Class<?> clazz = null;
        if (this.defaultProvider != null) {
            String provider = this.defaultProvider;
            try {
                clazz = this.loadClass(provider);
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)(CLASS_NAME + ".getDefaultProvider"), (String)"217");
                ValidationException e = new ValidationException(t);
                throw e;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getDefaultProviderClass", clazz);
        }
        return clazz;
    }

    @Override
    public Configuration<?> configure() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"configure");
        }
        Configuration configuration = null;
        Class<ValidationProvider<?>> clazz = this.getDefaultProviderClass();
        if (clazz == null) {
            configuration = Validation.byDefaultProvider().configure();
        } else {
            ProviderSpecificBootstrap providerBootstrap = Validation.byProvider(clazz);
            configuration = providerBootstrap.configure();
        }
        this.setMessageInterpolator(configuration);
        this.setTraversableResolver(configuration);
        this.setConstraintValidatorFactory(configuration);
        this.setConstraintMappings(configuration);
        this.setProperties(configuration);
        configuration.ignoreXmlConfiguration();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"configure", (Object)configuration);
        }
        return configuration;
    }

    @Override
    public void release(ValidatorFactory vf) {
        this.clearClassLoader();
    }

    @Override
    public void setMessageInterpolator(Configuration<?> apiConfig) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setMessageInterpolator", apiConfig);
        }
        Class<MessageInterpolator> clazz = null;
        MessageInterpolator mi = null;
        if (this.messageInterpolator != null) {
            try {
                clazz = this.loadClass(this.messageInterpolator).asSubclass(MessageInterpolator.class);
                mi = this.instantiateClass(clazz);
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)(CLASS_NAME + ".setMessageInterpolator"), (String)"249");
                ValidationException e = new ValidationException(t);
                throw e;
            }
        }
        if (mi != null) {
            apiConfig.messageInterpolator(mi);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setMessageInterpolator", mi);
        }
    }

    @Override
    public void setTraversableResolver(Configuration<?> apiConfig) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setTraversableResolver", apiConfig);
        }
        Class<TraversableResolver> clazz = null;
        TraversableResolver tr = null;
        if (this.traversableResolver != null) {
            try {
                clazz = this.loadClass(this.traversableResolver).asSubclass(TraversableResolver.class);
                tr = this.instantiateClass(clazz);
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)(CLASS_NAME + ".setTraversableResolver"), (String)"280");
                ValidationException e = new ValidationException(t);
                throw e;
            }
        }
        if (tr != null) {
            apiConfig.traversableResolver(tr);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setTraversableResolver", tr);
        }
    }

    @Override
    public void setConstraintValidatorFactory(Configuration<?> apiConfig) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setConstraintValidatorFactory", apiConfig);
        }
        Class<ConstraintValidatorFactory> clazz = null;
        ConstraintValidatorFactory cvf = null;
        if (this.constraintValidatorFactory != null) {
            try {
                clazz = this.loadClass(this.constraintValidatorFactory).asSubclass(ConstraintValidatorFactory.class);
                cvf = this.instantiateClass(clazz);
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)(CLASS_NAME + ".setConstraintValidatorFactory"), (String)"313");
                ValidationException e = new ValidationException(t);
                throw e;
            }
        }
        if (cvf != null) {
            apiConfig.constraintValidatorFactory(cvf);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setConstraintValidatorFactory", cvf);
        }
    }

    @Override
    public List<String> getConstraintMapping() {
        ArrayList<String> result = new ArrayList<String>();
        for (String constraintMappingString : this.constraintMapping) {
            if (constraintMappingString != null) {
                constraintMappingString = constraintMappingString.trim();
            }
            result.add(constraintMappingString);
        }
        return result;
    }

    @Override
    public List<Property> getProperty() {
        return this.properties;
    }

    @Override
    public void setProperties(Configuration<?> config) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setProperties", config);
        }
        if (this.properties != null) {
            for (Property ptype : this.properties) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Name is " + ptype.getName() + "Value is " + ptype.getValue()));
                }
                config.addProperty(ptype.getName(), ptype.getValue());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setProperties");
        }
    }

    @Override
    public void setConstraintMappings(Configuration<?> config) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setConstraintMappings", config);
        }
        InputStream inputStream = null;
        ClassLoader ccl = ValidationConfigurator.getContextClassLoader();
        for (String fileName : this.getConstraintMapping()) {
            inputStream = ccl.getResource(fileName).openStream();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && (inputStream = this.dumpInputStream(inputStream)) == null) {
                inputStream = ccl.getResource(fileName).openStream();
            }
            config.addMapping(inputStream);
            this.mapFileInputStreams.add(inputStream);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setConstraintMappings");
        }
    }

    protected Class<?> loadClass(String className) throws ClassNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"loadClass", (Object)className);
        }
        Class<?> theClass = null;
        try {
            if (this.appClassloader != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Class loader to be used " + this.appClassloader));
                }
                theClass = Class.forName(className, true, this.appClassloader);
            } else {
                ClassLoader cl = ValidationConfigurator.getContextClassLoader();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("appClassloader is null, so try using context class loader " + cl));
                }
                theClass = Class.forName(className, true, cl);
            }
        }
        catch (ClassNotFoundException cnfe) {
            Tr.error((TraceComponent)tc, (String)"BVKEY_CLASS_NOT_FOUND", (Object)new Object[]{this.ivBVContext.getPath(), className, cnfe});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Unable to create a ValidationFactory", (Object)cnfe);
            }
            throw cnfe;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"loadClass", theClass);
        }
        return theClass;
    }

    protected <T> T instantiateClass(Class<T> clazz) throws Throwable {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"instantiateClass", clazz);
        }
        T object = null;
        try {
            object = clazz.newInstance();
        }
        catch (Throwable e) {
            Tr.error((TraceComponent)tc, (String)"BVKEY_CLASS_NOT_FOUND", (Object)new Object[]{this.ivBVContext.getPath(), clazz, e});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Unable to create a ValidationFactory because of ", (Object)e);
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"instantiateClass", object);
        }
        return object;
    }

    @Override
    public void closeMappingFiles() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"closeMappingFiles", this.mapFileInputStreams);
        }
        for (InputStream inputStream : this.mapFileInputStreams) {
            try {
                inputStream.close();
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)(CLASS_NAME + ".closeMappingFiles"), (String)"573");
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Closing InputStream failed " + inputStream));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"closeMappingFiles", this.mapFileInputStreams);
        }
    }

    @Override
    public void clearClassLoader() {
        this.appClassloader = null;
    }

    @Override
    public ClassLoader getAppClassLoader() {
        return this.appClassloader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream dumpInputStream(InputStream is) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ByteArrayInputStream copiedStream = null;
        try {
            int len;
            byte[] buf = new byte[2048];
            while ((len = is.read(buf)) > 0) {
                baos.write(buf, 0, len);
            }
            byte[] streamBytes = baos.toByteArray();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)" InputStream dump ", (Object)baos.toString());
            }
            copiedStream = new ByteArrayInputStream(streamBytes);
            is.close();
        }
        catch (IOException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)" InputStream dump failed ", (Object)e);
            }
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".dumpInputStream"), (String)"630");
        }
        finally {
            try {
                baos.close();
            }
            catch (IOException iOException) {}
        }
        return copiedStream;
    }

    private static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    private static String getLineSeparatorProperty() {
        if (System.getSecurityManager() == null) {
            return System.getProperty("line.separator");
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("line.separator");
            }
        });
    }
}

