/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.transport.config.options.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.transport.config.options.EndpointOption;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class TransportConfigUtils {
    private static final TraceComponent tc = Tr.register(TransportConfigUtils.class, null, null);
    static final long serialVersionUID = -9171110622868083211L;

    private TransportConfigUtils() {
    }

    public static <T> T getOptionValue(Map<String, Object> config, EndpointOption option, Function<Object, Optional<T>> parser) {
        Object value = config.get(option.getKey());
        if (Objects.isNull(value)) {
            return (T)option.getDefaultValue();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Config: " + option.getKey() + " is " + value), (Object[])new Object[0]);
        }
        return (T)parser.apply(value).orElse(option.getDefaultValue());
    }

    public static <T> T getOptionValue(Map<String, Object> config, EndpointOption option) {
        Object value = config.get(option.getKey());
        if (Objects.isNull(value)) {
            return (T)option.getDefaultValue();
        }
        try {
            if (option.getValueType() == Integer.class && value instanceof Number) {
                return (T)Integer.valueOf(((Number)value).intValue());
            }
            if (option.getValueType() == Boolean.class && value instanceof Boolean) {
                return (T)value;
            }
            if (option.getValueType().isInstance(value)) {
                return (T)value;
            }
            return (T)option.getDefaultValue();
        }
        catch (ClassCastException classCastException) {
            FFDCFilter.processException((Throwable)classCastException, (String)"io.openliberty.transport.config.options.utils.TransportConfigUtils", (String)"89", null, (Object[])new Object[]{config, option});
            return (T)option.getDefaultValue();
        }
    }

    private static <T> Optional<T> getValue(Map<String, Object> config, String key, Function<Object, Optional<T>> parser) {
        Object value = config.get(key);
        if (Objects.isNull(value)) {
            return Optional.empty();
        }
        return parser.apply(value);
    }

    private static <T> Optional<T> parseValue(Object value, Class<T> valueType) {
        if (valueType == String.class) {
            return TransportConfigUtils.parseString(value);
        }
        if (valueType == String[].class) {
            return TransportConfigUtils.parseStringArray(value);
        }
        if (valueType == Boolean.class) {
            return TransportConfigUtils.parseBoolean(value);
        }
        if (valueType == Integer.class) {
            return TransportConfigUtils.parseInteger(value);
        }
        if (valueType == Long.class) {
            return TransportConfigUtils.parseLong(value);
        }
        Tr.warning((TraceComponent)tc, (String)"Unsupported value type for config: {0}", (Object[])new Object[]{valueType});
        return Optional.empty();
    }

    private static Optional<String> parseString(Object value) {
        if (value instanceof String) {
            return Optional.of((String)value);
        }
        Tr.warning((TraceComponent)tc, (String)"Invalid string value for config: {0}", (Object[])new Object[]{value});
        return Optional.empty();
    }

    private static Optional<String[]> parseStringArray(Object value) {
        if (value instanceof String[]) {
            return Optional.of((String[])value);
        }
        if (value instanceof String) {
            return Optional.of(((String)value).split("\\s*,\\s*"));
        }
        Tr.warning((TraceComponent)tc, (String)"Invalid string array value for config: {0}", (Object[])new Object[]{value});
        return Optional.empty();
    }

    public static Optional<Boolean> parseBoolean(Object value) {
        String stringValue;
        if (value instanceof Boolean) {
            return Optional.of((Boolean)value);
        }
        if (value instanceof String && ((stringValue = ((String)value).trim().toLowerCase()).equals("true") || stringValue.equals("false"))) {
            return Optional.of(Boolean.parseBoolean(stringValue));
        }
        Tr.warning((TraceComponent)tc, (String)"Invalid boolean value for config: {0}", (Object[])new Object[]{value});
        return Optional.empty();
    }

    /*
     * WARNING - void declaration
     */
    public static Optional<Integer> parseInteger(Object value) {
        if (value instanceof Number) {
            return Optional.of(((Number)value).intValue());
        }
        if (value instanceof String) {
            try {
                return Optional.of(Integer.parseInt(((String)value).trim()));
            }
            catch (NumberFormatException numberFormatException) {
                void e;
                FFDCFilter.processException((Throwable)numberFormatException, (String)"io.openliberty.transport.config.options.utils.TransportConfigUtils", (String)"206", null, (Object[])new Object[]{value});
                Tr.warning((TraceComponent)tc, (String)"Invalid integer value for config: {0}", (Object[])new Object[]{value});
                FFDCFilter.processException((Throwable)e, (String)TransportConfigUtils.class.getName(), (String)".parseInteger", (Object)"1");
            }
        }
        return Optional.empty();
    }

    /*
     * WARNING - void declaration
     */
    public static Optional<Long> parseLong(Object value) {
        if (value instanceof Number) {
            return Optional.of(((Number)value).longValue());
        }
        if (value instanceof String) {
            try {
                return Optional.of(Long.parseLong(((String)value).trim()));
            }
            catch (NumberFormatException numberFormatException) {
                void e;
                FFDCFilter.processException((Throwable)numberFormatException, (String)"io.openliberty.transport.config.options.utils.TransportConfigUtils", (String)"228", null, (Object[])new Object[]{value});
                Tr.warning((TraceComponent)tc, (String)"Invalid long value for config: {0}", (Object[])new Object[]{value});
                FFDCFilter.processException((Throwable)e, (String)TransportConfigUtils.class.getName(), (String)".parseLong", (Object)"1");
            }
        }
        return Optional.empty();
    }
}

