/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.http.netty.timeout;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.http.netty.NettyHttpChannelConfig;
import com.ibm.ws.http.netty.NettyHttpConstants;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.util.AsciiString;
import io.netty.util.concurrent.ScheduledFuture;
import io.openliberty.http.netty.timeout.exception.H2IdleTimeoutException;
import io.openliberty.http.netty.timeout.exception.PersistTimeoutException;
import io.openliberty.http.netty.timeout.exception.ReadTimeoutException;
import io.openliberty.http.options.TcpOption;
import java.util.concurrent.TimeUnit;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class TimeoutHandler
extends ChannelDuplexHandler {
    private static final TraceComponent tc = Tr.register(TimeoutHandler.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    public static String NAME = "timeoutHandler";
    private Phase phase = Phase.OFF;
    private static final TimeUnit LEGACY_UNIT = TimeUnit.MILLISECONDS;
    private ChannelHandlerContext parentContext;
    private int readTimeout;
    private int persistTimeout;
    private int inactivityTimeout;
    private int h2InactivityTimeout;
    private final boolean streamOnly;
    private final boolean useKeepAlive;
    private boolean clientRequestedKeepAlive = false;
    private boolean serverKeepAlive = false;
    private boolean firstRequest = true;
    private boolean readRetried = false;
    private ScheduledFuture<?> currentTimeout;
    static final long serialVersionUID = 8097265590287199177L;

    public TimeoutHandler(NettyHttpChannelConfig config) {
        this(config, false);
    }

    public TimeoutHandler(NettyHttpChannelConfig config, boolean streamOnly) {
        this.readTimeout = config.getReadTimeout();
        this.persistTimeout = config.getPersistTimeout();
        this.h2InactivityTimeout = config.getH2ConnectionIdleTimeout();
        this.inactivityTimeout = (Integer)config.get(TcpOption.INACTIVITY_TIMEOUT);
        this.useKeepAlive = config.isKeepAliveEnabled();
        this.streamOnly = streamOnly;
    }

    public static TimeoutHandler forH2Stream(NettyHttpChannelConfig config) {
        return new TimeoutHandler(config, true);
    }

    private int timeoutForPhase(Phase p) {
        switch (p) {
            case TCP_IDLE: {
                return this.inactivityTimeout;
            }
            case READ: {
                return this.readTimeout > 0 ? this.readTimeout : this.inactivityTimeout;
            }
            case PERSIST: {
                return this.persistTimeout > 0 ? this.persistTimeout : this.inactivityTimeout;
            }
            case H2_IDLE: {
                return this.h2InactivityTimeout;
            }
        }
        return 0;
    }

    public void handlerAdded(ChannelHandlerContext context) {
        this.parentContext = context;
        if (this.streamOnly) {
            return;
        }
        if (TimeoutHandler.getProtocol(context) == NettyHttpConstants.ProtocolName.HTTP2) {
            this.arm(context, Phase.H2_IDLE);
        } else {
            this.arm(context, Phase.TCP_IDLE);
        }
    }

    public void handlerRemoved(ChannelHandlerContext context) throws Exception {
        this.cancel();
        super.handlerRemoved(context);
    }

    public void channelRead(ChannelHandlerContext context, Object message) throws Exception {
        if (TimeoutHandler.getProtocol(context) == NettyHttpConstants.ProtocolName.HTTP2 && !this.streamOnly) {
            if (this.phase == Phase.H2_IDLE && this.h2InactivityTimeout > 0) {
                this.arm(context, Phase.H2_IDLE);
            }
            super.channelRead(context, message);
            return;
        }
        if (TimeoutHandler.isRequestStart(message)) {
            this.cancel();
            this.clientRequestedKeepAlive = this.shouldKeepAliveRequest(context, message);
        }
        switch (this.phase) {
            case TCP_IDLE: {
                this.arm(context, Phase.READ);
                break;
            }
            case READ: {
                this.resetRead(context);
                break;
            }
        }
        super.channelRead(context, message);
        if (TimeoutHandler.isRequestEnd(message)) {
            this.cancel();
            this.firstRequest = false;
        }
    }

    public void write(ChannelHandlerContext context, Object message, ChannelPromise promise) throws Exception {
        if (message instanceof HttpResponse && ((HttpResponse)message).status().code() == 101) {
            String upgrade = ((HttpResponse)message).headers().get((CharSequence)HttpHeaderNames.UPGRADE);
            if (upgrade != null) {
                AsciiString up = AsciiString.of((CharSequence)upgrade).toLowerCase();
                if (AsciiString.contains((CharSequence)up, (CharSequence)"websocket")) {
                    this.markProtocol(context.pipeline(), NettyHttpConstants.ProtocolName.WEBSOCKET);
                    context.channel().pipeline().remove((ChannelHandler)this);
                    super.write(context, message, promise);
                    promise.addListener(future -> {
                        if (future.isSuccess()) {
                            context.executor().execute(() -> {
                                if (context.pipeline().context((ChannelHandler)this) != null) {
                                    context.pipeline().remove((ChannelHandler)this);
                                }
                            });
                        }
                    });
                    return;
                }
                if (AsciiString.contains((CharSequence)up, (CharSequence)"h2c")) {
                    this.markProtocol(context.pipeline(), NettyHttpConstants.ProtocolName.HTTP2);
                    this.cancel();
                }
            }
        } else if (message instanceof HttpResponse) {
            this.serverKeepAlive = this.shouldKeepAliveResponse(context, message);
        }
        super.write(context, message, promise);
        promise.addListener(future -> {
            if (future.isSuccess() && TimeoutHandler.isResponseEnd(message) && !this.streamOnly) {
                if (!this.serverKeepAlive) {
                    context.close();
                } else {
                    this.armPersistIfNeeded(context);
                }
            }
        });
    }

    private void arm(ChannelHandlerContext context, Phase newPhase) {
        int timeout = this.timeoutForPhase(newPhase);
        if (timeout <= 0) {
            this.phase = Phase.OFF;
            return;
        }
        this.cancel();
        this.phase = newPhase;
        this.currentTimeout = context.executor().schedule(() -> this.onTimeout(context), (long)timeout, TimeUnit.MILLISECONDS);
    }

    private void resetRead(ChannelHandlerContext context) {
        if (this.phase == Phase.READ) {
            this.arm(context, Phase.READ);
        }
    }

    private void armPersistIfNeeded(ChannelHandlerContext context) {
        if (TimeoutHandler.getProtocol(context) != NettyHttpConstants.ProtocolName.WEBSOCKET) {
            this.arm(context, Phase.PERSIST);
        }
    }

    private void cancel() {
        if (this.currentTimeout != null) {
            this.currentTimeout.cancel(false);
            this.currentTimeout = null;
        }
        this.phase = Phase.OFF;
    }

    private void onTimeout(ChannelHandlerContext context) {
        switch (this.phase) {
            case TCP_IDLE: 
            case READ: {
                if (this.firstRequest && !this.readRetried) {
                    this.readRetried = true;
                    this.arm(context, Phase.READ);
                    return;
                }
                if (this.firstRequest) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"The connection closed due to idle timeout", (Object[])new Object[0]);
                    }
                    context.close();
                    break;
                }
                context.fireExceptionCaught((Throwable)new ReadTimeoutException(this.readTimeout, LEGACY_UNIT));
                break;
            }
            case PERSIST: {
                context.fireExceptionCaught((Throwable)new PersistTimeoutException(this.persistTimeout, LEGACY_UNIT));
                break;
            }
            case H2_IDLE: {
                context.fireExceptionCaught((Throwable)new H2IdleTimeoutException(this.h2InactivityTimeout, LEGACY_UNIT));
                break;
            }
        }
    }

    private static boolean isRequestStart(Object message) {
        return message instanceof HttpRequest || message instanceof Http2HeadersFrame;
    }

    private static boolean isRequestEnd(Object message) {
        if (message instanceof HttpRequest) {
            HttpRequest req = (HttpRequest)message;
            boolean hasBody = HttpUtil.isTransferEncodingChunked((HttpMessage)req) || HttpUtil.isContentLengthSet((HttpMessage)req);
            return !hasBody;
        }
        if (message instanceof LastHttpContent) {
            return true;
        }
        if (message instanceof Http2DataFrame) {
            return ((Http2DataFrame)message).isEndStream();
        }
        if (message instanceof Http2HeadersFrame) {
            return ((Http2HeadersFrame)message).isEndStream();
        }
        return false;
    }

    private static boolean isResponseEnd(Object message) {
        return message instanceof LastHttpContent || message instanceof Http2DataFrame && ((Http2DataFrame)message).isEndStream() || message instanceof Http2HeadersFrame && ((Http2HeadersFrame)message).isEndStream();
    }

    private boolean shouldKeepAliveRequest(ChannelHandlerContext context, Object request) {
        NettyHttpConstants.ProtocolName proto = NettyHttpConstants.ProtocolName.from((String)context.channel().attr(NettyHttpConstants.PROTOCOL).get());
        if (proto == NettyHttpConstants.ProtocolName.HTTP2) {
            return false;
        }
        if (request instanceof HttpRequest) {
            return HttpUtil.isKeepAlive((HttpMessage)((HttpRequest)request));
        }
        return false;
    }

    private boolean shouldKeepAliveResponse(ChannelHandlerContext context, Object response) {
        NettyHttpConstants.ProtocolName proto = TimeoutHandler.getProtocol(context);
        if (proto == NettyHttpConstants.ProtocolName.WEBSOCKET) {
            return true;
        }
        if (proto == NettyHttpConstants.ProtocolName.HTTP2) {
            return true;
        }
        if (!this.clientRequestedKeepAlive) {
            return false;
        }
        if (response instanceof HttpResponse) {
            HttpResponse r = (HttpResponse)response;
            if (HttpHeaderValues.CLOSE.contentEqualsIgnoreCase((CharSequence)r.headers().get((CharSequence)HttpHeaderNames.CONNECTION))) {
                return false;
            }
            return this.useKeepAlive;
        }
        return false;
    }

    private void switchToH2Idle() {
        if (this.streamOnly || this.parentContext == null) {
            return;
        }
        if (this.h2InactivityTimeout == 0) {
            this.cancel();
            return;
        }
        this.cancel();
        this.arm(this.parentContext, Phase.H2_IDLE);
    }

    public void markProtocol(ChannelPipeline p, NettyHttpConstants.ProtocolName proto) {
        p.channel().attr(NettyHttpConstants.PROTOCOL).set((Object)proto.name());
        if (proto == NettyHttpConstants.ProtocolName.HTTP2) {
            this.switchToH2Idle();
        } else if (proto == NettyHttpConstants.ProtocolName.WEBSOCKET) {
            this.cancel();
        }
    }

    private static NettyHttpConstants.ProtocolName getProtocol(ChannelHandlerContext context) {
        String protocol = (String)context.channel().attr(NettyHttpConstants.PROTOCOL).get();
        return NettyHttpConstants.ProtocolName.from(protocol);
    }

    private static enum Phase {
        OFF,
        TCP_IDLE,
        READ,
        PERSIST,
        H2_IDLE;

    }
}

