/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.bind;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.geronimo.osgi.locator.ProviderLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ContextFinder {
    private static final String PLATFORM_DEFAULT_FACTORY_CLASS = "com.sun.xml.bind.v2.ContextFactory";
    private static final String JAXB_CONTEXT_PROPERTY = JAXBContext.class.getName();
    private static final String JAXB_CONTEXT_FACTORY = "javax.xml.bind.context.factory";

    ContextFinder() {
    }

    public static JAXBContext find(String contextPath, ClassLoader classLoader, Map properties) throws JAXBException {
        String pkg;
        String url;
        String[] packages;
        if ((contextPath = contextPath.trim()).length() == 0 || contextPath.equals(":")) {
            throw new JAXBException("Invalid contextPath");
        }
        String className = null;
        String[] arr$ = packages = contextPath.split("[:]");
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (className = ContextFinder.loadClassNameFromProperties(url = (pkg = arr$[i$]).replace('.', '/') + "/jaxb.properties", classLoader)) == null; ++i$) {
        }
        if (className == null) {
            className = System.getProperty(JAXB_CONTEXT_PROPERTY);
        }
        Class spi = null;
        if (className == null) {
            spi = ContextFinder.loadSPIClass(JAXBContext.class, classLoader);
            if (spi == null) {
                spi = ContextFinder.loadSpi(PLATFORM_DEFAULT_FACTORY_CLASS, classLoader);
            }
        } else {
            spi = ContextFinder.loadSpi(className, classLoader);
        }
        try {
            Method m = spi.getMethod("createContext", String.class, ClassLoader.class, Map.class);
            return (JAXBContext)m.invoke(null, contextPath, classLoader, properties);
        }
        catch (NoSuchMethodException e) {
        }
        catch (Throwable t) {
            throw new JAXBException("Unable to create context", t);
        }
        try {
            Method m = spi.getMethod("createContext", String.class, ClassLoader.class);
            return (JAXBContext)m.invoke(null, contextPath, classLoader);
        }
        catch (Throwable t) {
            throw new JAXBException("Unable to create context", t);
        }
    }

    public static JAXBContext find(Class[] classes, Map properties) throws JAXBException {
        String url;
        Class cl;
        Package pkg;
        String className = null;
        Class[] arr$ = classes;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && ((pkg = (cl = arr$[i$]).getPackage()) == null || (className = ContextFinder.loadClassNameFromProperties(url = pkg.getName().replace('.', '/') + "/jaxb.properties", cl.getClassLoader())) == null); ++i$) {
        }
        if (className == null) {
            className = System.getProperty(JAXB_CONTEXT_PROPERTY);
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class spi = null;
        if (className == null) {
            spi = ContextFinder.loadSPIClass(JAXBContext.class, classLoader);
            if (spi == null) {
                spi = ContextFinder.loadSpi(PLATFORM_DEFAULT_FACTORY_CLASS, classLoader);
            }
        } else {
            spi = ContextFinder.loadSpi(className, classLoader);
        }
        try {
            Method m = spi.getMethod("createContext", Class[].class, Map.class);
            return (JAXBContext)m.invoke(null, classes, properties);
        }
        catch (Throwable t) {
            throw new JAXBException("Unable to create context", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String loadClassNameFromProperties(String url, ClassLoader classLoader) throws JAXBException {
        String string;
        InputStream is = classLoader != null ? classLoader.getResourceAsStream(url) : ClassLoader.getSystemResourceAsStream(url);
        if (is == null) return null;
        try {
            Properties props = new Properties();
            props.load(is);
            String className = props.getProperty(JAXB_CONTEXT_FACTORY);
            if (className == null) {
                throw new JAXBException("jaxb.properties file " + url + " should contain a " + JAXB_CONTEXT_FACTORY + " property");
            }
            string = className.trim();
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new JAXBException(e);
            }
        }
        is.close();
        return string;
    }

    private static Class<?> loadSPIClass(Class<?> iface, ClassLoader classLoader) throws JAXBException {
        try {
            return ProviderLocator.getServiceClass(iface.getName(), ContextFinder.class, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new JAXBException("Provider " + iface.getName() + " not found", e);
        }
    }

    private static Class loadSpi(String className, ClassLoader classLoader) throws JAXBException {
        try {
            return ProviderLocator.loadClass(className, ContextFinder.class, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new JAXBException("Provider " + className + " not found", e);
        }
    }
}

