/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.web;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.annocache.AnnotationsBetaHelper;
import com.ibm.ws.container.service.annotations.WebAnnotations;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedModuleInfo;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxws.metadata.EndpointType;
import com.ibm.ws.jaxws.metadata.JaxWsModuleInfo;
import com.ibm.ws.jaxws.metadata.JaxWsModuleMetaData;
import com.ibm.ws.jaxws.metadata.JaxWsModuleType;
import com.ibm.ws.jaxws.metadata.builder.AbstractJaxWsModuleInfoBuilder;
import com.ibm.ws.jaxws.metadata.builder.EndpointInfoBuilder;
import com.ibm.ws.jaxws.metadata.builder.EndpointInfoBuilderContext;
import com.ibm.ws.jaxws.metadata.builder.JaxWsModuleInfoBuilderContext;
import com.ibm.ws.jaxws.metadata.builder.JaxWsModuleInfoBuilderExtension;
import com.ibm.ws.jaxws.support.JaxWsMetaDataManager;
import com.ibm.ws.jaxws.utils.JaxWsUtils;
import com.ibm.ws.jaxws.web.VirtualHostOSGIService;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.webcontainer.osgi.DynamicVirtualHostManager;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.anno.info.ClassInfo;
import com.ibm.wsspi.anno.info.InfoStore;
import com.ibm.wsspi.anno.targets.AnnotationTargets_Targets;
import com.ibm.wsspi.http.VirtualHost;
import com.ibm.wsspi.webcontainer.servlet.IServletConfig;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import jakarta.jws.WebService;
import jakarta.xml.ws.WebServiceProvider;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WebJaxWsModuleInfoBuilder
extends AbstractJaxWsModuleInfoBuilder {
    private static final TraceComponent tc = Tr.register(WebJaxWsModuleInfoBuilder.class, (String)"JaxWsWeb", (String)"com.ibm.ws.jaxws.web.internal.resources.JaxWsWebMessages");
    static final long serialVersionUID = 6260216729049427265L;

    public WebJaxWsModuleInfoBuilder() {
        super(JaxWsModuleType.WEB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtendedModuleInfo build(ModuleMetaData moduleMetaData, Container containerToAdapt, JaxWsModuleInfo jaxWsModuleInfo) throws UnableToAdaptException {
        if (JaxWsUtils.isEJBModule((Container)JaxWsMetaDataManager.getJaxWsModuleMetaData((ModuleMetaData)moduleMetaData).getModuleContainer())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"EJB module; ignore web services", (Object[])new Object[0]);
            }
            return null;
        }
        EndpointInfoBuilder endpointInfoBuilder = (EndpointInfoBuilder)this.endpointInfoBuilderSRRef.getService();
        if (endpointInfoBuilder == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No EndpointInfoBuilder; ignore web services", (Object[])new Object[0]);
            }
            return null;
        }
        WebAnnotations webAnnotations = AnnotationsBetaHelper.getWebAnnotations((Container)containerToAdapt);
        InfoStore infoStore = webAnnotations.getInfoStore();
        EndpointInfoBuilderContext endpointInfoBuilderContext = new EndpointInfoBuilderContext(infoStore, containerToAdapt);
        JaxWsModuleInfoBuilderContext jaxWsModuleInfoBuilderContext = new JaxWsModuleInfoBuilderContext(moduleMetaData, containerToAdapt, endpointInfoBuilderContext);
        Map<String, String> servletNameClassPairsInWebXML = this.getServletNameClassPairsInWebXML(containerToAdapt);
        jaxWsModuleInfoBuilderContext.addContextEnv("servletNameClassPairsForEJBsInWAR", servletNameClassPairsInWebXML);
        for (JaxWsModuleInfoBuilderExtension extension : this.extensions) {
            extension.preBuild(jaxWsModuleInfoBuilderContext, jaxWsModuleInfo);
        }
        boolean didOpen = false;
        try {
            WebAppConfig webAppConfig = (WebAppConfig)containerToAdapt.adapt(WebAppConfig.class);
            Set presentedServices = jaxWsModuleInfo.getEndpointImplBeanClassNames();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Presented service classes: " + presentedServices), (Object[])new Object[0]);
            }
            this.setupContextRoot(moduleMetaData, webAppConfig);
            this.setupVirtualHostConfig(moduleMetaData, webAppConfig);
            if (!webAppConfig.isMetadataComplete()) {
                Collection<String> implClassNamesInWebXML = servletNameClassPairsInWebXML.values();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Descriptor servlet class names: " + implClassNamesInWebXML), (Object[])new Object[0]);
                }
                AnnotationTargets_Targets annotationTargets = webAnnotations.getAnnotationTargets();
                Set serviceImplClassNames = annotationTargets.getAnnotatedClasses(WebService.class.getName());
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("WebService classes: " + serviceImplClassNames), (Object[])new Object[0]);
                }
                Set providerImplClassNames = annotationTargets.getAnnotatedClasses(WebServiceProvider.class.getName());
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("WebServiceProvider classes: " + providerImplClassNames), (Object[])new Object[0]);
                }
                HashSet implClassNames = new HashSet(serviceImplClassNames.size() + providerImplClassNames.size());
                implClassNames.addAll(serviceImplClassNames);
                implClassNames.addAll(providerImplClassNames);
                for (String implClassName : implClassNames) {
                    String skipReason;
                    if (implClassNamesInWebXML.contains(implClassName)) {
                        skipReason = "Listed in web.xml";
                    } else if (presentedServices.contains(implClassName)) {
                        skipReason = "Presentation service";
                    } else {
                        if (!didOpen) {
                            webAnnotations.openInfoStore();
                            didOpen = true;
                        }
                        skipReason = this.validModifiers(infoStore.getDelayableClassInfo(implClassName));
                    }
                    if (skipReason != null) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("Skip [ " + implClassName + " ]: " + skipReason), (Object[])new Object[0]);
                        continue;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Process [ " + implClassName + " ]"), (Object[])new Object[0]);
                    }
                    jaxWsModuleInfo.addEndpointInfo(implClassName, endpointInfoBuilder.build(endpointInfoBuilderContext, implClassName, EndpointType.SERVLET));
                }
            }
            Iterator cfgIter = webAppConfig.getServletInfos();
            while (cfgIter.hasNext()) {
                String skipReason;
                IServletConfig servletCfg = (IServletConfig)cfgIter.next();
                String servletName = servletCfg.getServletName();
                String servletClassName = servletCfg.getClassName();
                if (servletClassName == null) {
                    skipReason = "Null servlet class name";
                } else if (presentedServices.contains(servletClassName)) {
                    skipReason = "Presented Service";
                } else {
                    ClassInfo classInfo;
                    if (!didOpen) {
                        webAnnotations.openInfoStore();
                        didOpen = true;
                    }
                    if ((skipReason = this.validAnnotations(classInfo = infoStore.getDelayableClassInfo(servletClassName))) == null) {
                        skipReason = this.validModifiers(classInfo);
                    }
                }
                if (skipReason != null) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Skip servlet [ " + servletName + " : " + servletClassName + " ]: " + skipReason), (Object[])new Object[0]);
                    continue;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Process servlet [ " + servletName + " : " + servletClassName + " ]"), (Object[])new Object[0]);
                }
                endpointInfoBuilderContext.addContextEnv("endpointServletNameInEnv", (Object)servletName);
                jaxWsModuleInfo.addEndpointInfo(servletName, endpointInfoBuilder.build(endpointInfoBuilderContext, servletClassName, EndpointType.SERVLET));
            }
        }
        finally {
            if (didOpen) {
                webAnnotations.closeInfoStore();
            }
        }
        for (JaxWsModuleInfoBuilderExtension extension : this.extensions) {
            extension.postBuild(jaxWsModuleInfoBuilderContext, jaxWsModuleInfo);
        }
        return null;
    }

    private String validAnnotations(ClassInfo classInfo) {
        if (classInfo == null) {
            return "Class not found";
        }
        if (!classInfo.isAnnotationPresent(WebService.class.getName()) && !classInfo.isAnnotationPresent(WebServiceProvider.class.getName())) {
            return "No WebService or WebServiceProvider annotation";
        }
        return null;
    }

    private String validModifiers(ClassInfo classInfo) {
        if (classInfo == null) {
            return "Class not found";
        }
        int modifiers = classInfo.getModifiers();
        String skipReason = !Modifier.isPublic(modifiers) ? "Non-public modifier" : (Modifier.isFinal(modifiers) ? "Modifier is final" : (Modifier.isAbstract(modifiers) ? "Modifier is abstract" : null));
        if (skipReason != null && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            skipReason = skipReason + " [ 0x" + Integer.toHexString(modifiers) + " ]";
        }
        return skipReason;
    }

    private void setupContextRoot(ModuleMetaData moduleMetaData, WebAppConfig webAppConfig) {
        JaxWsModuleMetaData jaxWsModuleMetaData = JaxWsMetaDataManager.getJaxWsModuleMetaData((ModuleMetaData)moduleMetaData);
        String contextRoot = webAppConfig.getContextRoot();
        jaxWsModuleMetaData.setContextRoot(contextRoot);
    }

    /*
     * WARNING - void declaration
     */
    private void setupVirtualHostConfig(ModuleMetaData moduleMetaData, WebAppConfig webAppConfig) {
        String webAppName = webAppConfig.getApplicationName();
        String contextRoot = webAppConfig.getContextRoot();
        String configedVirtualHostName = webAppConfig.getVirtualHostName();
        JaxWsModuleMetaData jaxWsModuleMetaData = JaxWsMetaDataManager.getJaxWsModuleMetaData((ModuleMetaData)moduleMetaData);
        if (configedVirtualHostName == null) {
            return;
        }
        DynamicVirtualHostManager dvhm = VirtualHostOSGIService.getInstance().getDynamicVirtualHostManagerService();
        try {
            ConcurrentHashMap vhostMap;
            VirtualHost vHost;
            final Field transportMap = dvhm.getClass().getDeclaredField("transportMap");
            AccessController.doPrivileged(new PrivilegedAction<Void>(){
                static final long serialVersionUID = 6282830815282096042L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Void run() {
                    transportMap.setAccessible(true);
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.jaxws.web.WebJaxWsModuleInfoBuilder$1", 1.class, (String)"JaxWsWeb", (String)"com.ibm.ws.jaxws.web.internal.resources.JaxWsWebMessages");
                }
            });
            Object transportObj = transportMap.get(dvhm);
            if (transportObj != null && (vHost = (VirtualHost)(vhostMap = (ConcurrentHashMap)transportObj).get(configedVirtualHostName)) != null) {
                jaxWsModuleMetaData.getAppNameURLMap().put(webAppName, new VirtualHostURL(vHost, contextRoot));
            }
        }
        catch (Exception transportMap) {
            void e;
            FFDCFilter.processException((Throwable)transportMap, (String)"com.ibm.ws.jaxws.web.WebJaxWsModuleInfoBuilder", (String)"358", (Object)((Object)this), (Object[])new Object[]{moduleMetaData, webAppConfig});
            throw new SecurityException((Throwable)e);
        }
    }

    private Map<String, String> getServletNameClassPairsInWebXML(Container containerToAdapt) throws UnableToAdaptException {
        HashMap<String, String> nameClassPairs = new HashMap<String, String>();
        WebAppConfig webAppConfig = (WebAppConfig)containerToAdapt.adapt(WebAppConfig.class);
        Iterator cfgIter = webAppConfig.getServletInfos();
        while (cfgIter.hasNext()) {
            IServletConfig servletCfg = (IServletConfig)cfgIter.next();
            if (servletCfg.getClassName() == null) continue;
            nameClassPairs.put(servletCfg.getServletName(), servletCfg.getClassName());
        }
        return nameClassPairs;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class VirtualHostURL
    implements Supplier<String>,
    UnaryOperator<String> {
        private final AtomicReference<String> cached = new AtomicReference();
        private final VirtualHost vHost;
        private final String contextRoot;
        static final long serialVersionUID = -9013365550277166898L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        VirtualHostURL(VirtualHost vHost, String contextRoot) {
            this.vHost = vHost;
            this.contextRoot = contextRoot;
        }

        @Override
        public String get() {
            return this.cached.updateAndGet(this);
        }

        @Override
        public String apply(String cachedValue) {
            if (cachedValue == null || "".equals(cachedValue)) {
                return this.vHost.getUrlString(this.contextRoot, true);
            }
            return cachedValue;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jaxws.web.WebJaxWsModuleInfoBuilder$VirtualHostURL", VirtualHostURL.class, (String)"JaxWsWeb", (String)"com.ibm.ws.jaxws.web.internal.resources.JaxWsWebMessages");
        }
    }
}

