/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.ws.impl;

import com.ibm.jbatch.container.persistence.jpa.JobInstanceEntity;
import com.ibm.jbatch.container.services.IBatchKernelService;
import com.ibm.jbatch.container.services.IJobXMLSource;
import com.ibm.jbatch.container.services.IPersistenceManagerService;
import com.ibm.jbatch.container.services.impl.JobXMLSource;
import com.ibm.jbatch.container.util.BatchPartitionWorkUnit;
import com.ibm.jbatch.container.ws.PartitionPlanConfig;
import com.ibm.jbatch.container.ws.PartitionReplyQueue;
import com.ibm.jbatch.container.ws.WSBatchAuthService;
import com.ibm.jbatch.container.ws.WSJobInstance;
import com.ibm.jbatch.container.ws.WSJobOperator;
import com.ibm.jbatch.container.ws.events.BatchEventsPublisher;
import com.ibm.jbatch.container.ws.impl.StringUtils;
import com.ibm.jbatch.jsl.model.Step;
import com.ibm.jbatch.spi.BatchSecurityHelper;
import com.ibm.jbatch.spi.services.IJobXMLLoaderService;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.batch.operations.JobExecutionAlreadyCompleteException;
import jakarta.batch.operations.JobExecutionNotMostRecentException;
import jakarta.batch.operations.JobExecutionNotRunningException;
import jakarta.batch.operations.JobRestartException;
import jakarta.batch.operations.JobSecurityException;
import jakarta.batch.operations.NoSuchJobExecutionException;
import jakarta.batch.operations.NoSuchJobInstanceException;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
@Component(configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class WSJobOperatorImpl
implements WSJobOperator {
    private static final String sourceClass = WSJobOperatorImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private IPersistenceManagerService persistenceManagerService;
    private IBatchKernelService batchKernelService;
    private WSBatchAuthService authService;
    private BatchEventsPublisher eventsPublisher;
    private BatchSecurityHelper batchSecurityHelper;
    private IJobXMLLoaderService jslLoaderService;
    static final long serialVersionUID = 8602016727711370621L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSJobOperatorImpl() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobOperatorImpl", "<init>", new Object[0]);
        }
        this.batchSecurityHelper = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobOperatorImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setWSBatchAuthService(WSBatchAuthService bas) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobOperatorImpl", "setWSBatchAuthService", new Object[]{bas});
        }
        this.authService = bas;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobOperatorImpl", "setWSBatchAuthService");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    protected void setIPersistenceManagerService(IPersistenceManagerService ref) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobOperatorImpl", "setIPersistenceManagerService", new Object[]{ref});
        }
        this.persistenceManagerService = ref;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobOperatorImpl", "setIPersistenceManagerService");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference
    protected void setIJobXMLLoaderService(IJobXMLLoaderService ref) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobOperatorImpl", "setIJobXMLLoaderService", new Object[]{ref});
        }
        this.jslLoaderService = ref;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobOperatorImpl", "setIJobXMLLoaderService");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference
    protected void setIBatchKernelService(IBatchKernelService bks) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobOperatorImpl", "setIBatchKernelService", new Object[]{bks});
        }
        this.batchKernelService = bks;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobOperatorImpl", "setIBatchKernelService");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference
    protected void setBatchSecurityHelper(BatchSecurityHelper batchSecurityHelper) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobOperatorImpl", "setBatchSecurityHelper", new Object[]{batchSecurityHelper});
        }
        this.batchSecurityHelper = batchSecurityHelper;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobOperatorImpl", "setBatchSecurityHelper");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void unsetBatchSecurityHelper(BatchSecurityHelper batchSecurityHelper) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobOperatorImpl", "unsetBatchSecurityHelper", new Object[]{batchSecurityHelper});
        }
        if (this.batchSecurityHelper == batchSecurityHelper) {
            this.batchSecurityHelper = null;
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobOperatorImpl", "unsetBatchSecurityHelper");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void unsetWSBatchAuthService(WSBatchAuthService bas) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobOperatorImpl", "unsetWSBatchAuthService", new Object[]{bas});
        }
        if (this.authService == bas) {
            this.authService = null;
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobOperatorImpl", "unsetWSBatchAuthService");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void unsetIPersistenceManagerService(IPersistenceManagerService ref) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobOperatorImpl", "unsetIPersistenceManagerService", new Object[]{ref});
        }
        if (this.persistenceManagerService == ref) {
            this.persistenceManagerService = null;
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobOperatorImpl", "unsetIPersistenceManagerService");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void unsetIJobXMLLoaderService(IJobXMLLoaderService ref) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobOperatorImpl", "unsetIJobXMLLoaderService", new Object[]{ref});
        }
        if (this.jslLoaderService == ref) {
            this.jslLoaderService = null;
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobOperatorImpl", "unsetIJobXMLLoaderService");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void unsetIBatchKernelService(IBatchKernelService bks) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobOperatorImpl", "unsetIBatchKernelService", new Object[]{bks});
        }
        if (this.batchKernelService == bks) {
            this.batchKernelService = null;
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobOperatorImpl", "unsetIBatchKernelService");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setEventsPublisher(BatchEventsPublisher publisher) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobOperatorImpl", "setEventsPublisher", new Object[]{publisher});
        }
        this.eventsPublisher = publisher;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobOperatorImpl", "setEventsPublisher");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void unsetEventsPublisher(BatchEventsPublisher publisher) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobOperatorImpl", "unsetEventsPublisher", new Object[]{publisher});
        }
        if (this.eventsPublisher == publisher) {
            this.eventsPublisher = null;
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobOperatorImpl", "unsetEventsPublisher");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSJobInstance createJobInstance(String appName, String jobXMLName, String jsl, String correlationId) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobOperatorImpl", "createJobInstance", new Object[]{appName, jobXMLName, jsl, correlationId});
        }
        if (this.authService != null) {
            this.authService.authorizedJobSubmission();
        }
        WSJobInstance wSJobInstance = this.batchKernelService.createJobInstance(appName, jobXMLName, this.batchSecurityHelper.getRunAsUser(), jsl, correlationId);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            wSJobInstance = wSJobInstance;
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobOperatorImpl", "createJobInstance", wSJobInstance);
        }
        return wSJobInstance;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map.Entry<Long, Future<?>> start(WSJobInstance jobInstance, Properties jobParameters, long execId) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobOperatorImpl", "start", new Object[]{jobInstance, jobParameters, execId});
        }
        if (this.authService != null) {
            this.authService.authorizedJobSubmission();
        }
        this.traceJobStart(jobInstance.getJobXMLName(), jobParameters);
        IJobXMLSource jobXML = !StringUtils.isEmpty(jobInstance.getJobXml()) ? new JobXMLSource(jobInstance.getJobXml()) : this.jslLoaderService.loadJSL(jobInstance.getJobXMLName());
        Map.Entry<Long, Future<?>> execIdFutureEntry = this.batchKernelService.startJob(jobInstance, jobXML, jobParameters, execId);
        long executionId = execIdFutureEntry.getKey();
        if (logger.isLoggable(Level.FINE) && executionId > 0L) {
            logger.fine("Started job with instanceId: " + jobInstance.getInstanceId() + ", executionId: " + executionId);
        }
        Map.Entry<Long, Future<?>> entry = execIdFutureEntry;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            entry = entry;
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobOperatorImpl", "start", entry);
        }
        return entry;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void traceJobStart(String jobXMLName, Properties jobParameters) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobOperatorImpl", "traceJobStart", new Object[]{jobXMLName, jobParameters});
        }
        if (logger.isLoggable(Level.FINE)) {
            StringWriter jobParameterWriter = new StringWriter();
            if (jobParameters != null) {
                try {
                    jobParameters.store(jobParameterWriter, "Job parameters on start: ");
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.jbatch.container.ws.impl.WSJobOperatorImpl", (String)"210", (Object)this, (Object[])new Object[]{jobXMLName, jobParameters});
                    jobParameterWriter.write("Job parameters on start: not printable");
                }
            } else {
                jobParameterWriter.write("Job parameters on start = null");
            }
            logger.fine("Starting job: jobXMLName = " + jobXMLName + "\n" + jobParameterWriter.toString());
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobOperatorImpl", "traceJobStart");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void traceJobXML(String jobXML) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobOperatorImpl", "traceJobXML", new Object[]{jobXML});
        }
        if (logger.isLoggable(Level.FINE)) {
            int concatLen = jobXML.length() > 200 ? 200 : jobXML.length();
            logger.fine("Starting job: " + jobXML.substring(0, concatLen) + "... truncated ...");
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobOperatorImpl", "traceJobXML");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean purgeJobInstance(long jobInstanceId) throws JobSecurityException, NoSuchJobInstanceException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobOperatorImpl", "purgeJobInstance", new Object[]{jobInstanceId});
        }
        if (this.authService != null) {
            this.authService.authorizedJobPurgeByInstance(jobInstanceId);
        }
        JobInstanceEntity jobInstance = this.persistenceManagerService.getJobInstance(jobInstanceId);
        boolean purgeSuccess = this.persistenceManagerService.purgeJobInstanceAndRelatedData(jobInstanceId);
        if (purgeSuccess) {
            this.publishPurgeEvent(jobInstance);
        }
        boolean bl = purgeSuccess;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobOperatorImpl", "purgeJobInstance", bl);
        }
        return bl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map.Entry<Long, Future<?>> restartInstance(long instanceId, Properties restartParameters, long executionId) throws JobExecutionAlreadyCompleteException, NoSuchJobExecutionException, JobExecutionNotMostRecentException, JobRestartException, JobSecurityException {
        Map.Entry<Long, Future<?>> execIdFutureEntry;
        JobInstanceEntity jobInstance;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobOperatorImpl", "restartInstance", new Object[]{instanceId, restartParameters, executionId});
        }
        if (this.authService != null) {
            this.authService.authorizedJobRestartByInstance(instanceId);
        }
        IJobXMLSource jobXML = !StringUtils.isEmpty((jobInstance = this.persistenceManagerService.getJobInstance(instanceId)).getJobXml()) ? new JobXMLSource(jobInstance.getJobXml()) : this.jslLoaderService.loadJSL(jobInstance.getJobXMLName());
        Map.Entry<Long, Future<?>> entry = execIdFutureEntry = this.batchKernelService.restartJobInstance(instanceId, jobXML, restartParameters, executionId);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            entry = entry;
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobOperatorImpl", "restartInstance", entry);
        }
        return entry;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void stop(long executionId) throws NoSuchJobExecutionException, JobExecutionNotRunningException, JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobOperatorImpl", "stop", new Object[]{executionId});
        }
        if (this.authService != null) {
            this.authService.authorizedJobStopByExecution(executionId);
        }
        this.batchKernelService.stopJob(executionId);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobOperatorImpl", "stop");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void publishPurgeEvent(WSJobInstance jobInstance) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobOperatorImpl", "publishPurgeEvent", new Object[]{jobInstance});
        }
        if (this.eventsPublisher != null) {
            this.eventsPublisher.publishJobInstanceEvent(jobInstance, "batch/jobs/instance/purged", null);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobOperatorImpl", "publishPurgeEvent");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Future<?> startPartition(PartitionPlanConfig partitionPlanConfig, Step step, PartitionReplyQueue partitionReplyQueue) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSJobOperatorImpl", "startPartition", new Object[]{partitionPlanConfig, step, partitionReplyQueue});
        }
        Map.Entry<BatchPartitionWorkUnit, Future<?>> workUnitFutureEntry = this.batchKernelService.startPartition(partitionPlanConfig, step, partitionReplyQueue, true);
        Future<?> future = workUnitFutureEntry.getValue();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            future = future;
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSJobOperatorImpl", "startPartition", future);
        }
        return future;
    }
}

