/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.service.factory;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.dom.DOMSource;
import org.apache.cxf.Bus;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ModCountCopyOnWriteArrayList;
import org.apache.cxf.databinding.AbstractDataBinding;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.interceptor.OutgoingChainInterceptor;
import org.apache.cxf.interceptor.ServiceInvokerInterceptor;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.resource.URIResolver;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.factory.FactoryBeanListener;
import org.apache.cxf.service.factory.FactoryBeanListenerManager;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Document;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public abstract class AbstractServiceFactoryBean {
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractServiceFactoryBean.class);
    protected boolean dataBindingSet;
    protected List<String> schemaLocations;
    private Bus bus;
    private DataBinding dataBinding;
    private Service service;
    private final List<FactoryBeanListener> listeners;
    private final Map<String, Object> sessionState;
    static final long serialVersionUID = 5209506916578988249L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public AbstractServiceFactoryBean() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.AbstractServiceFactoryBean", "<init>", new Object[0]);
        }
        this.listeners = new ModCountCopyOnWriteArrayList<FactoryBeanListener>();
        this.sessionState = new HashMap<String, Object>();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.AbstractServiceFactoryBean", "<init>", this);
        }
    }

    public abstract Service create();

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map<String, Object> getSessionState() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.AbstractServiceFactoryBean", "getSessionState", new Object[0]);
        }
        Map<String, Object> map = this.sessionState;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            map = map;
            LOG.exiting("org.apache.cxf.service.factory.AbstractServiceFactoryBean", "getSessionState", map);
        }
        return map;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void sendEvent(FactoryBeanListener.Event ev, Object ... args) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.AbstractServiceFactoryBean", "sendEvent", new Object[]{ev, args});
        }
        for (FactoryBeanListener l : this.listeners) {
            l.handleEvent(ev, this, args);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.AbstractServiceFactoryBean", "sendEvent");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void initializeDefaultInterceptors() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.AbstractServiceFactoryBean", "initializeDefaultInterceptors", new Object[0]);
        }
        this.service.getInInterceptors().add(new ServiceInvokerInterceptor());
        this.service.getInInterceptors().add(new OutgoingChainInterceptor());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.AbstractServiceFactoryBean", "initializeDefaultInterceptors");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void initializeDataBindings() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.AbstractServiceFactoryBean", "initializeDataBindings", new Object[0]);
        }
        if (this.getDataBinding() instanceof AbstractDataBinding && this.schemaLocations != null) {
            this.fillDataBindingSchemas();
        }
        this.getDataBinding().initialize(this.getService());
        this.service.setDataBinding(this.getDataBinding());
        this.sendEvent(FactoryBeanListener.Event.DATABINDING_INITIALIZED, this.dataBinding);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.AbstractServiceFactoryBean", "initializeDataBindings");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Bus getBus() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.AbstractServiceFactoryBean", "getBus", new Object[0]);
        }
        Bus bus = this.bus;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bus = bus;
            LOG.exiting("org.apache.cxf.service.factory.AbstractServiceFactoryBean", "getBus", bus);
        }
        return bus;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setBus(Bus bus) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.AbstractServiceFactoryBean", "setBus", new Object[]{bus});
        }
        this.bus = bus;
        FactoryBeanListenerManager m = bus.getExtension(FactoryBeanListenerManager.class);
        if (m != null) {
            this.listeners.addAll(m.getListeners());
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.AbstractServiceFactoryBean", "setBus");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public DataBinding getDataBinding() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.AbstractServiceFactoryBean", "getDataBinding", new Object[0]);
        }
        DataBinding dataBinding = this.getDataBinding(true);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            dataBinding = dataBinding;
            LOG.exiting("org.apache.cxf.service.factory.AbstractServiceFactoryBean", "getDataBinding", dataBinding);
        }
        return dataBinding;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public DataBinding getDataBinding(boolean create) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.AbstractServiceFactoryBean", "getDataBinding", new Object[]{create});
        }
        if (this.dataBinding == null && create) {
            this.dataBinding = this.createDefaultDataBinding();
        }
        DataBinding dataBinding = this.dataBinding;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            dataBinding = dataBinding;
            LOG.exiting("org.apache.cxf.service.factory.AbstractServiceFactoryBean", "getDataBinding", dataBinding);
        }
        return dataBinding;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected DataBinding createDefaultDataBinding() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.AbstractServiceFactoryBean", "createDefaultDataBinding", new Object[0]);
        }
        DataBinding dataBinding = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            dataBinding = dataBinding;
            LOG.exiting("org.apache.cxf.service.factory.AbstractServiceFactoryBean", "createDefaultDataBinding", dataBinding);
        }
        return dataBinding;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setDataBinding(DataBinding dataBinding) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.AbstractServiceFactoryBean", "setDataBinding", new Object[]{dataBinding});
        }
        this.dataBinding = dataBinding;
        boolean bl = this.dataBindingSet = dataBinding != null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.AbstractServiceFactoryBean", "setDataBinding");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Service getService() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.AbstractServiceFactoryBean", "getService", new Object[0]);
        }
        Service service = this.service;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            service = service;
            LOG.exiting("org.apache.cxf.service.factory.AbstractServiceFactoryBean", "getService", service);
        }
        return service;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void setService(Service service) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.AbstractServiceFactoryBean", "setService", new Object[]{service});
        }
        this.service = service;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.AbstractServiceFactoryBean", "setService");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void fillDataBindingSchemas() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.service.factory.AbstractServiceFactoryBean", "fillDataBindingSchemas", new Object[0]);
        }
        ResourceManager rr = this.getBus().getExtension(ResourceManager.class);
        ArrayList<DOMSource> schemas = new ArrayList<DOMSource>();
        for (String l : this.schemaLocations) {
            Document d;
            URL url = rr.resolveResource(l, URL.class);
            if (url == null) {
                URIResolver res;
                try {
                    res = new URIResolver(l);
                }
                catch (IOException e) {
                    throw new ServiceConstructionException(new Message("INVALID_SCHEMA_URL", LOG, l), (Throwable)e);
                }
                if (!res.isResolved()) {
                    throw new ServiceConstructionException(new Message("INVALID_SCHEMA_URL", LOG, l));
                }
                url = res.getURL();
            }
            try {
                d = StaxUtils.read(url.openStream());
            }
            catch (Exception e) {
                throw new ServiceConstructionException(new Message("ERROR_READING_SCHEMA", LOG, l), (Throwable)e);
            }
            schemas.add(new DOMSource(d, url.toString()));
        }
        ((AbstractDataBinding)this.getDataBinding()).setSchemas(schemas);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.service.factory.AbstractServiceFactoryBean", "fillDataBindingSchemas");
        }
    }
}

