/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.util.HashMap;
import org.eclipse.persistence.core.descriptors.CoreDescriptor;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.ModifyAllQuery;
import org.eclipse.persistence.queries.QueryRedirector;

public class UpdateAllQuery
extends ModifyAllQuery {
    protected HashMap m_updateClauses;

    public UpdateAllQuery() {
    }

    public UpdateAllQuery(Class<?> referenceClass) {
        super(referenceClass);
    }

    public UpdateAllQuery(Class<?> referenceClass, Expression selectionCriteria) {
        super(referenceClass, selectionCriteria);
    }

    public UpdateAllQuery(Class<?> referenceClass, ExpressionBuilder expressionBuilder) {
        super(referenceClass);
        this.defaultBuilder = expressionBuilder;
    }

    public void addUpdate(Expression field, Object value) {
        this.addUpdateInternal(field, value);
    }

    public void addUpdate(String attributeName, Object value) {
        this.addUpdateInternal(attributeName, value);
    }

    public void addUpdate(Expression field, Expression value) {
        this.addUpdateInternal(field, value);
    }

    public void addUpdate(String attributeName, Expression value) {
        this.addUpdateInternal(attributeName, value);
    }

    protected void addUpdateInternal(Object fieldObject, Object valueObject) {
        if (fieldObject == null) {
            throw QueryException.updateAllQueryAddUpdateFieldIsNull(this);
        }
        if (this.m_updateClauses == null) {
            this.m_updateClauses = new HashMap();
        }
        this.m_updateClauses.put(fieldObject, valueObject);
    }

    @Override
    public Object executeDatabaseQuery() throws DatabaseException {
        this.result = this.getQueryMechanism().updateAll();
        this.mergeChangesIntoSharedCache();
        return this.result;
    }

    @Override
    protected QueryRedirector getDefaultRedirector() {
        return this.descriptor.getDefaultUpdateObjectQueryRedirector();
    }

    public HashMap getUpdateClauses() {
        return this.m_updateClauses;
    }

    @Override
    public boolean isUpdateAllQuery() {
        return true;
    }

    @Override
    protected void prepare() throws QueryException {
        ClassDescriptor descriptor;
        super.prepare();
        Class<?> referenceClass = this.getReferenceClass();
        if (referenceClass == null) {
            throw QueryException.referenceClassMissing(this);
        }
        if (this.getDescriptor() == null) {
            CoreDescriptor desc = this.getSession().getDescriptor((Class)referenceClass);
            if (desc == null) {
                throw QueryException.descriptorIsMissing(referenceClass, this);
            }
            this.setDescriptor((ClassDescriptor)desc);
        }
        if ((descriptor = this.getDescriptor()).isAggregateDescriptor()) {
            throw QueryException.aggregateObjectCannotBeDeletedOrWritten(descriptor, this);
        }
        if ((this.getUpdateClauses() == null || this.getUpdateClauses().isEmpty()) && this.isExpressionQuery()) {
            throw QueryException.updateStatementsNotSpecified();
        }
        this.getQueryMechanism().prepareUpdateAll();
    }

    @Override
    protected void initializeQuerySpecificDefaultBuilder() {
        super.initializeQuerySpecificDefaultBuilder();
        if (this.defaultBuilder == null && this.m_updateClauses != null) {
            for (Object value : this.m_updateClauses.values()) {
                if (value == null || !(value instanceof Expression)) continue;
                Expression valueExpression = (Expression)value;
                this.defaultBuilder = valueExpression.getBuilder();
                if (this.defaultBuilder == null) continue;
                return;
            }
            for (Object field : this.m_updateClauses.keySet()) {
                if (!(field instanceof Expression)) continue;
                Expression fieldExpression = (Expression)field;
                this.defaultBuilder = fieldExpression.getBuilder();
                if (this.defaultBuilder == null) continue;
                return;
            }
        }
    }
}

