/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.netty.pipeline.http2;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.InboundHttp2ToHttpAdapter;
import java.util.Objects;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LibertyInboundHttp2ToHttpAdapter
extends InboundHttp2ToHttpAdapter {
    private final Channel channel;
    static final long serialVersionUID = -8323736873189375413L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected LibertyInboundHttp2ToHttpAdapter(Http2Connection connection, int maxContentLength, boolean validateHttpHeaders, boolean propagateSettings, Channel channel) {
        super(connection, maxContentLength, validateHttpHeaders, propagateSettings);
        this.channel = channel;
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={NullPointerException.class})
    protected FullHttpMessage processHeadersBegin(ChannelHandlerContext ctx, Http2Stream stream, Http2Headers headers, boolean endOfStream, boolean allowAppend, boolean appendToTrailer) throws Http2Exception {
        try {
            boolean containsScheme;
            boolean containsPath = Objects.nonNull(headers.path()) && !headers.path().toString().isEmpty();
            boolean bl = containsScheme = Objects.nonNull(headers.scheme()) && !headers.scheme().toString().isEmpty();
            if (headers.method().toString().equalsIgnoreCase(HttpMethod.CONNECT.asciiName().toString())) {
                if (containsPath || containsScheme || Objects.isNull(headers.authority())) {
                    throw new NullPointerException("Connect method request must omit path and scheme values!");
                }
            } else {
                if (!containsPath) {
                    throw new NullPointerException("Request path must have a value!");
                }
                if (!containsScheme) {
                    throw new NullPointerException("Request scheme must have a value!");
                }
            }
            return super.processHeadersBegin(ctx, stream, headers, endOfStream, allowAppend, appendToTrailer);
        }
        catch (NullPointerException e) {
            throw Http2Exception.streamError((int)stream.id(), (Http2Error)Http2Error.PROTOCOL_ERROR, (String)e.getMessage(), (Object[])new Object[0]);
        }
        catch (Exception e) {
            void e2;
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.http.netty.pipeline.http2.LibertyInboundHttp2ToHttpAdapter", (String)"63", (Object)((Object)this), (Object[])new Object[]{ctx, stream, headers, endOfStream, allowAppend, appendToTrailer});
            throw e2;
        }
    }

    public void onGoAwayReceived(int lastStreamId, long errorCode, ByteBuf debugData) {
        super.onGoAwayReceived(lastStreamId, errorCode, debugData);
        this.channel.close();
    }

    public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) throws Http2Exception {
        Http2Error code;
        Http2Stream stream = this.connection.stream(streamId);
        FullHttpMessage msg = this.getMessage(stream);
        if (msg != null) {
            this.onRstStreamRead(stream, msg);
        }
        if (Objects.isNull(code = Http2Error.valueOf((long)errorCode))) {
            code = Http2Error.INTERNAL_ERROR;
        }
        ctx.fireExceptionCaught((Throwable)Http2Exception.streamError((int)streamId, (Http2Error)code, (String)"HTTP/2 to HTTP layer caught stream reset", (Object[])new Object[0]));
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.http.netty.pipeline.http2.LibertyInboundHttp2ToHttpAdapter", LibertyInboundHttp2ToHttpAdapter.class, null, null);
    }
}

