/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.requestContext;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Event {
    private volatile String type;
    private volatile Object contextInfo;
    private volatile long startTime;
    private volatile long endTime;
    private volatile List<Event> childEvents = new ArrayList<Event>();
    private volatile Event parentEvent;

    public Event() {
    }

    public Event(String type, Object contextInfo) {
        this.type = type;
        this.contextInfo = contextInfo;
    }

    public Event(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Object getContextInfo() {
        return this.contextInfo;
    }

    public void setContextInfo(Object contextInfo) {
        this.contextInfo = contextInfo;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public List<Event> getChildEvents() {
        return Collections.unmodifiableList(this.childEvents);
    }

    public void setChildEvents(List<Event> childEvents) {
        this.childEvents = childEvents;
    }

    public Event getParentEvent() {
        return this.parentEvent;
    }

    public void setParentEvent(Event parentEvent) {
        this.parentEvent = parentEvent;
    }

    public void addChild(Event currentEvent) {
        if (this.childEvents == null) {
            ArrayList<Event> events = new ArrayList<Event>();
            events.add(currentEvent);
            this.setChildEvents(events);
        } else {
            this.childEvents.add(currentEvent);
        }
    }

    public String toString() {
        return "Event [eventType=" + (this.type != null ? this.type : null) + ", contextInfo=" + (this.contextInfo != null ? this.contextInfo : null) + ", startTime=" + this.startTime + ", endTime=" + this.endTime + "]";
    }
}

