/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.client.header;

import jakarta.ws.rs.core.MultivaluedMap;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.microprofile.rest.client.RestClientDefinitionException;
import org.eclipse.microprofile.rest.client.annotation.ClientHeaderParam;
import org.jboss.resteasy.microprofile.client.header.HeaderFiller;
import org.jboss.resteasy.microprofile.client.header.HeaderFillerFactory;

class ClientHeaderGenerator {
    private final boolean required;
    private final String headerName;
    private final HeaderFiller filler;
    private final List<String> staticValues;

    ClientHeaderGenerator(ClientHeaderParam anno, Class<?> interfaceClass, Object clientProxy, HeaderFillerFactory fillerFactory) {
        this.headerName = anno.name();
        this.required = anno.required();
        String[] values = anno.value();
        if (values.length == 0) {
            throw new RestClientDefinitionException("No value provided for " + ClientHeaderParam.class.getSimpleName() + " on " + interfaceClass + " for '" + this.headerName + "'");
        }
        if (values.length == 1 && this.isMethodCall(values[0])) {
            this.filler = fillerFactory.createFiller(values[0], this.headerName, this.required, interfaceClass, clientProxy);
            this.staticValues = null;
        } else {
            this.checkForMethodCallsInHeaderValues(values, interfaceClass, this.headerName);
            this.staticValues = Arrays.asList(values);
            this.filler = null;
        }
    }

    private void checkForMethodCallsInHeaderValues(String[] values, Class<?> location, String headerName) {
        if (Stream.of(values).anyMatch(this::isMethodCall)) {
            throw new RestClientDefinitionException("A method call defined as one multiple values for header on " + location.getSimpleName() + " for header '" + headerName + "'");
        }
    }

    private boolean isMethodCall(String headerValue) {
        return headerValue != null && headerValue.startsWith("{") && headerValue.endsWith("}");
    }

    public void fillHeaders(MultivaluedMap<String, String> headers) {
        List<String> headerValues;
        List<String> list = headerValues = this.filler != null ? this.filler.generateValues() : this.staticValues;
        if (!headerValues.isEmpty() && headers.get((Object)this.headerName) == null) {
            headers.put((Object)this.headerName, headerValues);
        }
    }
}

