/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.ssl.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.channel.ssl.internal.SSLConnectionLink;
import com.ibm.ws.channel.ssl.internal.SSLHandshakeCompletedCallback;
import com.ibm.ws.channel.ssl.internal.SSLUtils;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.tcpchannel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcpchannel.TCPReadRequestContext;
import com.ibm.wsspi.tcpchannel.TCPWriteCompletedCallback;
import com.ibm.wsspi.tcpchannel.TCPWriteRequestContext;
import java.io.IOException;
import javax.net.ssl.SSLEngineResult;

public class SSLHandshakeIOCallback
implements TCPReadCompletedCallback,
TCPWriteCompletedCallback {
    private static final TraceComponent tc = Tr.register(SSLHandshakeIOCallback.class, (String)"SSLChannel", (String)"com.ibm.ws.channel.ssl.internal.resources.SSLChannelMessages");
    private SSLConnectionLink connLink;
    private WsByteBuffer netBuffer;
    private WsByteBuffer decryptedNetBuffer;
    private WsByteBuffer encryptedAppBuffer;
    private SSLEngineResult result;
    private SSLHandshakeCompletedCallback callback;

    public SSLHandshakeIOCallback(SSLConnectionLink _connLink, WsByteBuffer _netBuffer, WsByteBuffer _decryptedNetBuffer, WsByteBuffer _encryptedAppBuffer, SSLEngineResult _result, SSLHandshakeCompletedCallback _callback) {
        this.connLink = _connLink;
        this.netBuffer = _netBuffer;
        this.decryptedNetBuffer = _decryptedNetBuffer;
        this.encryptedAppBuffer = _encryptedAppBuffer;
        this.result = _result;
        this.callback = _callback;
    }

    public void complete(VirtualConnection vc, TCPReadRequestContext rsc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"complete(read)", (Object[])new Object[0]);
        }
        try {
            SSLUtils.handleHandshake(this.connLink, this.netBuffer, this.decryptedNetBuffer, this.encryptedAppBuffer, this.result, this.callback, true);
        }
        catch (IOException ioe) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Caught IOException while performing callback read, " + ioe), (Object[])new Object[0]);
            }
            this.connLink.getChannel().getHandshakeErrorTracker().noteHandshakeError(ioe, this.connLink.getRemoteAddress(), this.connLink.getRemotePort(), this.connLink.getLocalAddress(), this.connLink.getLocalPort());
            this.error(vc, rsc, ioe);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"complete(read)");
        }
    }

    public void error(VirtualConnection vc, TCPReadRequestContext rsc, IOException ioe) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Error occured during a read, exception:" + ioe), (Object[])new Object[0]);
        }
        this.callback.error(ioe);
    }

    public void complete(VirtualConnection vc, TCPWriteRequestContext wsc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"complete(write)", (Object[])new Object[0]);
        }
        this.encryptedAppBuffer.clear();
        try {
            SSLUtils.handleHandshake(this.connLink, this.netBuffer, this.decryptedNetBuffer, this.encryptedAppBuffer, this.result, this.callback, true);
        }
        catch (IOException ioe) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Caught IOException while performing callback write, " + ioe), (Object[])new Object[0]);
            }
            this.connLink.getChannel().getHandshakeErrorTracker().noteHandshakeError(ioe, this.connLink.getRemoteAddress(), this.connLink.getRemotePort(), this.connLink.getLocalAddress(), this.connLink.getLocalPort());
            this.error(vc, wsc, ioe);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"complete(write)");
        }
    }

    public void error(VirtualConnection vc, TCPWriteRequestContext wsc, IOException ioe) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Error occured during a write, exception:" + ioe), (Object[])new Object[0]);
        }
        this.callback.error(ioe);
    }
}

