/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.session.impl;

import com.ibm.ws.session.MemoryStoreHelper;
import com.ibm.ws.session.utils.LoggingUtil;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import com.ibm.wsspi.webcontainer.util.FFDCWrapper;
import jakarta.servlet.ServletContext;
import java.util.logging.Level;

public class MemoryStoreHelperImpl
implements MemoryStoreHelper {
    protected final ServletContext sc;

    public MemoryStoreHelperImpl(ServletContext sc) {
        this.sc = sc;
    }

    public void setThreadContextDuringRunInvalidation() {
        this.setThreadContext(false);
    }

    public void setThreadContext() {
        this.setThreadContext(true);
    }

    private void setThreadContext(boolean reportException) {
        if (this.sc != null) {
            try {
                ((IServletContext)this.sc).startEnvSetup(true);
            }
            catch (Exception e) {
                String method = "setThreadContext";
                if (reportException) {
                    FFDCWrapper.processException(e, MemoryStoreHelperImpl.class.getName() + "." + method, "362", this);
                    LoggingUtil.SESSION_LOGGER_CORE.logp(Level.SEVERE, MemoryStoreHelperImpl.class.getSimpleName(), method, "CommonMessage.exception", e);
                }
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, MemoryStoreHelperImpl.class.getSimpleName(), method, "CommonMessage.exception", e);
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }
    }

    public void unsetThreadContext() {
        if (this.sc != null) {
            try {
                ((IServletContext)this.sc).finishEnvSetup(true);
            }
            catch (Exception e) {
                String method = "unsetThreadContext";
                FFDCWrapper.processException(e, MemoryStoreHelperImpl.class.getName() + "." + method, "377", this);
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.SEVERE, MemoryStoreHelperImpl.class.getSimpleName(), method, "CommonMessage.exception", e);
            }
        }
    }
}

