/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.request.timing.manager;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.request.probe.RequestProbeService;
import com.ibm.ws.request.timing.RequestTimingService;
import com.ibm.ws.request.timing.internal.config.RequestTimingConfig;
import com.ibm.ws.request.timing.queue.DelayedRequestQueue;
import com.ibm.ws.request.timing.queue.QueueableRequest;
import com.ibm.wsspi.requestContext.ContextInfoArray;
import com.ibm.wsspi.requestContext.Event;
import com.ibm.wsspi.requestContext.RequestContext;
import java.lang.reflect.Constructor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class ProbationaryRequestManager<C extends RequestTimingConfig, R extends QueueableRequest> {
    private static final TraceComponent tc = Tr.register(ProbationaryRequestManager.class, (String)"requestTiming", (String)"com.ibm.ws.request.timing.internal.resources.LoggingMessages");
    private volatile C config;
    private final DelayedRequestQueue<R> requestQueue;
    private volatile long lastRequestTime;
    private final Object syncTimerObject = new Object(){};
    private volatile ScheduledFuture<?> timeKeeper = null;
    private final Class<R> clazz;
    private volatile Constructor<R> rConstructor;
    private final Runnable probationaryReqDectector = new Runnable(){

        @Override
        @Trivial
        public void run() {
            try {
                for (RequestContext activeReqContext : RequestProbeService.getActiveRequests()) {
                    long activeTime;
                    long requestThreshold = 0L;
                    long requestThresholdMean = 0L;
                    boolean interruptRequest = false;
                    boolean enableThreadDumps = true;
                    Event rootEvent = activeReqContext.getRootEvent();
                    String requestType = rootEvent.getType();
                    Object contextInfoObj = rootEvent.getContextInfo();
                    String[] contextInfo = contextInfoObj != null && contextInfoObj instanceof ContextInfoArray ? ((ContextInfoArray)contextInfoObj).getContextInfoArray() : null;
                    requestThreshold = ProbationaryRequestManager.this.config.getRequestThreshold(requestType, contextInfo);
                    interruptRequest = ProbationaryRequestManager.this.config.getInterruptRequest(requestType, contextInfo);
                    enableThreadDumps = ProbationaryRequestManager.this.config.getEnableThreadDumps(requestType, contextInfo);
                    requestThresholdMean = requestThreshold / 2L;
                    if (requestThresholdMean <= 0L || (activeTime = TimeUnit.MILLISECONDS.convert(System.nanoTime() - activeReqContext.getRootEvent().getStartTime(), TimeUnit.NANOSECONDS)) < requestThresholdMean) continue;
                    boolean includeContextInfo = ProbationaryRequestManager.this.config.getContextInfoRequirement() == 0;
                    QueueableRequest request = (QueueableRequest)ProbationaryRequestManager.this.rConstructor.newInstance(activeReqContext, requestThreshold - activeTime, requestThreshold, includeContextInfo, interruptRequest, enableThreadDumps);
                    if (!ProbationaryRequestManager.this.requestQueue.addRequest(request) || !TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("(" + ProbationaryRequestManager.this.clazz.getSimpleName() + ") Active time (ms) : " + activeTime + " and request threshold mean (ms) : " + requestThresholdMean + String.format("%n", new Object[0]) + "Adding new request to queue ..."), (Object[])new Object[]{request.toString()});
                }
                long timeElapsedSinceLastReq = TimeUnit.MILLISECONDS.convert(System.nanoTime() - ProbationaryRequestManager.this.lastRequestTime, TimeUnit.NANOSECONDS);
                long stopDuration = ProbationaryRequestManager.this.config.getRequestThresholdMax() / 2L;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("(" + ProbationaryRequestManager.this.clazz.getSimpleName() + ") Time elapsed since last request (ms) : " + timeElapsedSinceLastReq + " and largest threshold window (ms) : " + stopDuration), (Object[])new Object[0]);
                }
                if (timeElapsedSinceLastReq > stopDuration) {
                    ProbationaryRequestManager.this.stopTimer();
                }
            }
            catch (Exception e) {
                ProbationaryRequestManager.this.stopTimer();
                FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"188", (Object)this);
            }
        }
    };

    public ProbationaryRequestManager(C config, DelayedRequestQueue<R> queue, Class<R> clazz) {
        this.requestQueue = queue;
        this.config = config;
        this.clazz = clazz;
        try {
            this.rConstructor = this.clazz.getConstructor(RequestContext.class, Long.TYPE, Long.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
        }
        catch (Exception e) {
            throw new RuntimeException("Probationary request manager instantiation failed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTimer() {
        long reqThresholdMin;
        if (this.timeKeeper == null && (reqThresholdMin = ((RequestTimingConfig)this.config).getRequestThresholdMin()) > 0L) {
            boolean startedTimer = false;
            long delay = reqThresholdMin / 2L;
            Object object = this.syncTimerObject;
            synchronized (object) {
                if (this.timeKeeper == null) {
                    this.timeKeeper = RequestTimingService.getScheduledExecutorService().scheduleAtFixedRate(this.probationaryReqDectector, delay, delay, TimeUnit.MILLISECONDS);
                    startedTimer = true;
                }
            }
            if (startedTimer && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Starting probationary request (" + this.clazz.getSimpleName() + ") detector with initial delay (ms) : " + delay + " and period (ms) : " + delay), (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTimer() {
        boolean stoppedTimer = false;
        Object object = this.syncTimerObject;
        synchronized (object) {
            if (this.timeKeeper != null) {
                this.timeKeeper.cancel(false);
                this.timeKeeper = null;
                stoppedTimer = true;
            }
        }
        if (stoppedTimer && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Stopping probationary request (" + this.clazz.getSimpleName() + ") detector."), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetTimer(C config) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Re-setting probationary request (" + this.clazz.getSimpleName() + ") detector."), (Object[])new Object[0]);
        }
        Object object = this.syncTimerObject;
        synchronized (object) {
            this.stopTimer();
            this.config = config;
            this.startTimer();
        }
    }

    public void setConfig(C config) {
        this.config = config;
    }

    public void setLastRequestTime(long lastRequestTime) {
        this.lastRequestTime = lastRequestTime;
    }
}

