/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.binding.soap.Soap11;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.interceptor.AbstractBasicInterceptorProvider;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.BindingInfo;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SoapBinding
extends AbstractBasicInterceptorProvider
implements Binding {
    private SoapVersion version;
    private BindingInfo bindingInfo;
    static final long serialVersionUID = -3448865291436054084L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public SoapBinding(BindingInfo info) {
        this(info, Soap11.getInstance());
    }

    public SoapBinding(BindingInfo info, SoapVersion v) {
        this.version = v;
        this.bindingInfo = info;
    }

    public BindingInfo getBindingInfo() {
        return this.bindingInfo;
    }

    public void setSoapVersion(SoapVersion v) {
        this.version = v;
    }

    public SoapVersion getSoapVersion() {
        return this.version;
    }

    @Sensitive
    public Message createMessage() {
        SoapMessage soapMessage = new SoapMessage(this.version);
        soapMessage.put("Content-Type", soapMessage.getVersion().getContentType());
        return soapMessage;
    }

    public Message createMessage(@Sensitive Message m) {
        SoapMessage soapMessage = new SoapMessage(m);
        if (m.getExchange() != null) {
            if (m.getExchange().getInMessage() instanceof SoapMessage) {
                soapMessage.setVersion(((SoapMessage)m.getExchange().getInMessage()).getVersion());
            } else {
                soapMessage.setVersion(this.version);
            }
        } else {
            soapMessage.setVersion(this.version);
        }
        if (!m.containsKey((Object)"Content-Type")) {
            m.put((Object)"Content-Type", (Object)soapMessage.getVersion().getContentType());
            SoapMessage newMessage = new SoapMessage(m);
            newMessage.setVersion(soapMessage.getVersion());
        }
        if (!soapMessage.containsKey("Content-Type")) {
            soapMessage.put("Content-Type", soapMessage.getVersion().getContentType());
        }
        return soapMessage;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.apache.cxf.binding.soap.SoapBinding", SoapBinding.class, null, null);
    }
}

