/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.security.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jaxws.security.internal.JaxWsProxySSLSocketFactory;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.ssl.SSLSupport;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLSocketFactory;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JaxWsSSLManager {
    private static final TraceComponent tc = Tr.register(JaxWsSSLManager.class, (String)"JaxWsSecurity", (String)"com.ibm.ws.jaxws.security.internal.resources.JaxWsSecurityMessages");
    private static final AtomicReference<AtomicServiceReference<SSLSupport>> sslSupportServiceRef = new AtomicReference();
    static final long serialVersionUID = -5791328940643740957L;

    protected static void init(AtomicServiceReference<SSLSupport> sslSupportSR) {
        sslSupportServiceRef.set(sslSupportSR);
    }

    public static SSLSocketFactory getProxySSLSocketFactoryBySSLRef(String sslRef, Map<String, Object> props) {
        return new JaxWsProxySSLSocketFactory(sslRef, props);
    }

    public static SSLSocketFactory getProxyDefaultSSLSocketFactory(Map<String, Object> props) {
        return new JaxWsProxySSLSocketFactory("defaultSSLConfig", props);
    }

    /*
     * WARNING - void declaration
     */
    public static SSLSocketFactory getSSLSocketFactoryBySSLRef(String sslRef, Map<String, Object> props, boolean fallbackOnDefault) {
        SSLSupport sslSupportService = JaxWsSSLManager.tryGetSSLSupport();
        if (null == sslSupportService) {
            return null;
        }
        JSSEHelper jsseHelper = sslSupportService.getJSSEHelper();
        Properties sslConfig = null;
        try {
            if (sslRef != null) {
                sslConfig = JaxWsSSLManager.getSSLConfig(sslRef, jsseHelper);
            }
            if (null != props && !props.isEmpty() && sslConfig != null) {
                for (Map.Entry<String, Object> entry : props.entrySet()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(entry.getKey() + "=" + entry.getValue() + " is overriden in SSLConfig=" + sslRef), (Object[])new Object[0]);
                    }
                    sslConfig.put(entry.getKey(), entry.getValue());
                }
            }
            if (sslConfig != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Get the SSLSocketFactory by properties =" + sslConfig), (Object[])new Object[0]);
                }
                return sslSupportService.getSSLSocketFactory(sslConfig);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Get the default SSLSocketFactory", (Object[])new Object[0]);
            }
            return sslSupportService.getSSLSocketFactory();
        }
        catch (SSLException iter) {
            void e;
            FFDCFilter.processException((Throwable)iter, (String)"com.ibm.ws.jaxws.security.internal.JaxWsSSLManager", (String)"99", null, (Object[])new Object[]{sslRef, props, fallbackOnDefault});
            Tr.error((TraceComponent)tc, (String)"err.when.get.ssl.config", (Object[])new Object[]{sslRef});
            throw new IllegalArgumentException((Throwable)e);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jaxws.security.internal.JaxWsSSLManager", (String)"102", null, (Object[])new Object[]{sslRef, props, fallbackOnDefault});
            Tr.error((TraceComponent)tc, (String)"err.when.get.ssl.socket.factory", (Object[])new Object[]{sslRef, e.getMessage()});
            throw new IllegalStateException(e);
        }
    }

    @FFDCIgnore(value={PrivilegedActionException.class})
    private static Properties getSSLConfig(String sslRef, JSSEHelper jsseHelper) throws SSLException {
        final String f_sslRef = sslRef;
        final JSSEHelper f_jsseHelper = jsseHelper;
        Properties sslConfig = null;
        try {
            sslConfig = AccessController.doPrivileged(new PrivilegedExceptionAction<Properties>(){
                static final long serialVersionUID = -7066221728285053449L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Properties run() throws SSLException {
                    return f_jsseHelper.getProperties(f_sslRef);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.jaxws.security.internal.JaxWsSSLManager$1", 1.class, (String)"JaxWsSecurity", (String)"com.ibm.ws.jaxws.security.internal.resources.JaxWsSecurityMessages");
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            throw (SSLException)cause;
        }
        if (sslConfig != null) {
            return (Properties)sslConfig.clone();
        }
        return null;
    }

    private static SSLSupport tryGetSSLSupport() {
        AtomicServiceReference<SSLSupport> serviceRef = sslSupportServiceRef.get();
        if (null == serviceRef) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The sslSupportService is not set yet", (Object[])new Object[0]);
            }
            return null;
        }
        return (SSLSupport)serviceRef.getService();
    }
}

