/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.oidcclientcore.authentication;

import com.ibm.websphere.ras.ProtectedString;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.webcontainer.security.AuthResult;
import com.ibm.ws.webcontainer.security.ProviderAuthenticationResult;
import io.openliberty.security.oidcclientcore.authentication.AuthorizationRequest;
import io.openliberty.security.oidcclientcore.authentication.AuthorizationRequestParameters;
import io.openliberty.security.oidcclientcore.authentication.AuthorizationRequestUtils;
import io.openliberty.security.oidcclientcore.client.OidcClientConfig;
import io.openliberty.security.oidcclientcore.config.MetadataUtils;
import io.openliberty.security.oidcclientcore.exceptions.OidcClientConfigurationException;
import io.openliberty.security.oidcclientcore.exceptions.OidcDiscoveryException;
import io.openliberty.security.oidcclientcore.http.OriginalResourceRequest;
import io.openliberty.security.oidcclientcore.storage.CookieStorageProperties;
import io.openliberty.security.oidcclientcore.storage.OidcStorageUtils;
import io.openliberty.security.oidcclientcore.storage.StorageFactory;
import io.openliberty.security.oidcclientcore.storage.StorageProperties;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JakartaOidcAuthorizationRequest
extends AuthorizationRequest {
    public static final TraceComponent tc = Tr.register(JakartaOidcAuthorizationRequest.class, (String)"OpenIdConnect", (String)"io.openliberty.security.oidcclientcore.internal.resources.OidcClientCoreMessages");
    public static final String IS_CONTAINER_INITIATED_FLOW = "IS_CONTAINER_INITIATED_FLOW";
    private OidcClientConfig config = null;
    private StorageType storageType;
    protected AuthorizationRequestUtils requestUtils = new AuthorizationRequestUtils();
    static final long serialVersionUID = 6680354248883492388L;

    public JakartaOidcAuthorizationRequest(HttpServletRequest request, HttpServletResponse response, OidcClientConfig config) {
        super(request, response, config.getClientId());
        this.config = config;
        this.instantiateStorage(config);
    }

    private void instantiateStorage(OidcClientConfig config) {
        boolean useSession = config.isUseSession();
        this.storage = StorageFactory.instantiateStorage(this.request, this.response, useSession);
        this.storageType = useSession ? StorageType.SESSION : StorageType.COOKIE;
    }

    @Override
    @FFDCIgnore(value={Exception.class})
    public ProviderAuthenticationResult sendRequest() {
        try {
            return super.sendRequest();
        }
        catch (Exception e) {
            Tr.error((TraceComponent)tc, (String)"ERROR_SENDING_AUTHORIZATION_REQUEST", (Object[])new Object[]{this.clientId, e.getMessage()});
            return new ProviderAuthenticationResult(AuthResult.SEND_401, 401);
        }
    }

    @Override
    protected String getAuthorizationEndpoint() throws OidcClientConfigurationException, OidcDiscoveryException {
        return MetadataUtils.getAuthorizationEndpoint(this.config);
    }

    @Override
    protected String getRedirectUrl() {
        return this.config.getRedirectURI();
    }

    @Override
    protected boolean shouldCreateSession() {
        return this.storageType == StorageType.SESSION;
    }

    @Override
    protected String createStateValueForStorage(String state) {
        String clientSecret = null;
        ProtectedString clientSecretProtectedString = this.config.getClientSecret();
        if (clientSecretProtectedString != null) {
            clientSecret = new String(clientSecretProtectedString.getChars());
        }
        return OidcStorageUtils.createStateStorageValue(state, clientSecret);
    }

    @Override
    protected String createNonceValueForStorage(String nonce, String state) {
        String clientSecret = null;
        ProtectedString clientSecretProtectedString = this.config.getClientSecret();
        if (clientSecretProtectedString != null) {
            clientSecret = new String(clientSecretProtectedString.getChars());
        }
        return OidcStorageUtils.createNonceStorageValue(nonce, state, clientSecret);
    }

    @Override
    protected StorageProperties getStateStorageProperties() {
        StorageProperties superProps = super.getStateStorageProperties();
        if (this.storageType == StorageType.COOKIE) {
            CookieStorageProperties props = new CookieStorageProperties();
            props.setStorageLifetimeSeconds(superProps.getStorageLifetimeSeconds());
            props.setHttpOnly(true);
            props.setSecure(true);
            return props;
        }
        return superProps;
    }

    @Override
    protected StorageProperties getNonceStorageProperties() {
        StorageProperties superProps = super.getNonceStorageProperties();
        if (this.storageType == StorageType.COOKIE) {
            CookieStorageProperties props = new CookieStorageProperties();
            props.setStorageLifetimeSeconds(superProps.getStorageLifetimeSeconds());
            props.setHttpOnly(true);
            props.setSecure(true);
            return props;
        }
        return superProps;
    }

    @Override
    protected StorageProperties getOriginalRequestUrlStorageProperties() {
        StorageProperties superProps = super.getOriginalRequestUrlStorageProperties();
        if (this.storageType == StorageType.COOKIE) {
            CookieStorageProperties props = new CookieStorageProperties();
            props.setStorageLifetimeSeconds(superProps.getStorageLifetimeSeconds());
            return props;
        }
        return superProps;
    }

    @Override
    @FFDCIgnore(value={Exception.class})
    protected ProviderAuthenticationResult redirectToAuthorizationEndpoint(String state, String redirectUrl) {
        String authzEndPointUrlWithQuery = null;
        try {
            authzEndPointUrlWithQuery = this.buildAuthorizationUrlWithQuery(state, redirectUrl);
        }
        catch (Exception e) {
            Tr.error((TraceComponent)tc, (String)"ERROR_BUILDING_AUTHORIZATION_ENDPOINT_URL", (Object[])new Object[]{this.clientId, e});
            return new ProviderAuthenticationResult(AuthResult.SEND_401, 401);
        }
        this.storeOriginalRequestUrl(state);
        if (this.shouldFullRequestBeStored()) {
            this.storeFullRequest(state);
        }
        return new ProviderAuthenticationResult(AuthResult.REDIRECT_TO_PROVIDER, 200, null, null, null, authzEndPointUrlWithQuery);
    }

    String buildAuthorizationUrlWithQuery(String state, String redirectUrl) throws OidcClientConfigurationException, OidcDiscoveryException {
        String authorizationEndpoint = MetadataUtils.getAuthorizationEndpoint(this.config);
        String scopes = this.getScopeString();
        String responseType = this.config.getResponseType();
        AuthorizationRequestParameters authzParameters = new AuthorizationRequestParameters(authorizationEndpoint, scopes, responseType, this.clientId, redirectUrl, state);
        this.addOptionalParameters(authzParameters, state);
        return authzParameters.buildRequestUrl();
    }

    String getScopeString() {
        String scopes = "";
        Set<String> scopesSet = this.config.getScope();
        for (String scope : scopesSet) {
            scopes = scopes + scope + " ";
        }
        scopes = scopes.trim();
        return scopes;
    }

    void addOptionalParameters(AuthorizationRequestParameters authzParameters, String state) {
        String display;
        String responseMode;
        String prompt;
        if (this.config.isUseNonce()) {
            String nonceValue = this.requestUtils.generateNonceValue();
            this.storeNonceValue(nonceValue, state);
            authzParameters.addParameter("nonce", nonceValue);
        }
        if ((prompt = this.config.getPromptParameter()) != null && !prompt.isEmpty()) {
            authzParameters.addParameter("prompt", prompt);
        }
        if ((responseMode = this.config.getResponseMode()) != null && !responseMode.isEmpty()) {
            authzParameters.addParameter("response_mode", responseMode);
        }
        if ((display = this.config.getDisplayParameter()) != null && !display.isEmpty()) {
            authzParameters.addParameter("display", display);
        }
        this.addExtraParameters(authzParameters);
    }

    void addExtraParameters(AuthorizationRequestParameters authzParameters) {
        String[] extraParametersArray = this.config.getExtraParameters();
        if (extraParametersArray == null) {
            return;
        }
        for (String extraParamAndValue : extraParametersArray) {
            String[] keyAndValue = extraParamAndValue.split("=", 2);
            if (keyAndValue.length < 2) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"addExtraParameters", (Object[])new Object[]{"skipping extra param '" + extraParamAndValue + "' because it is not in the format key=value"});
                continue;
            }
            String key = keyAndValue[0];
            String value = keyAndValue[1];
            authzParameters.addParameter(key, value);
        }
    }

    boolean shouldFullRequestBeStored() {
        return this.config.isRedirectToOriginalResource() && this.isContainerInitiatedFlow();
    }

    boolean isContainerInitiatedFlow() {
        Object isContainerInitiatedFlow = this.request.getAttribute(IS_CONTAINER_INITIATED_FLOW);
        if (isContainerInitiatedFlow instanceof Boolean) {
            this.request.removeAttribute(IS_CONTAINER_INITIATED_FLOW);
            return (Boolean)isContainerInitiatedFlow;
        }
        return false;
    }

    void storeFullRequest(String state) {
        OriginalResourceRequest.storeFullRequest(this.request, this.storage, state);
    }

    private static enum StorageType {
        COOKIE,
        SESSION;

    }
}

