/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.io;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.mfp.AbstractMessage;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;

public class MECommsTrc {
    public static final String OP_SEND = "--SEND->";
    public static final String OP_RECV = "<-RECV--";
    public static final String OP_SUBMSG_CONSUME = "<-SUBC--";
    private static final TraceComponent tc = SibTr.register(MECommsTrc.class, (String)"SIBMessageTraceMEComms", (String)"com.ibm.ws.sib.processor.CWSIPMessages");

    public static void traceMessage(TraceComponent _tc, MessageProcessor localME, SIBUuid8 remoteME, String operation, Object connection, AbstractMessage msg) {
        if (tc.isDebugEnabled() || _tc.isDebugEnabled()) {
            StringBuilder buff = new StringBuilder();
            buff.append("MECOMMS");
            try {
                buff.append("[");
                buff.append(localME != null ? localME.getMessagingEngineName() : "???");
                buff.append(operation);
                buff.append(remoteME);
                buff.append("] ");
                try {
                    msg.getTraceSummaryLine(buff);
                }
                catch (Exception e) {
                    String safeMsgSummary = msg != null ? msg.getClass().getName() : "null";
                    buff.append(" SUMMARY TRACE FAILED. Message class=" + safeMsgSummary);
                }
                buff.append(" [C=");
                buff.append(connection != null ? Integer.toHexString(connection.hashCode()) : null);
                buff.append(",D=");
                buff.append(msg.getGuaranteedTargetDestinationDefinitionUUID());
                buff.append(",S=");
                buff.append(msg.getGuaranteedStreamUUID());
                buff.append("]");
            }
            catch (Exception e) {
                String safeMsgSummary = msg != null ? msg.getClass().getName() : "null";
                buff.append(" SUMMARY TRACE FAILED. Message class=" + safeMsgSummary);
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)buff.toString());
            } else {
                SibTr.debug((TraceComponent)_tc, (String)buff.toString());
            }
        }
    }
}

