/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.api.jms.JmsMsgProducer;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.api.jms.JmsJMSContext;
import com.ibm.ws.sib.api.jms.impl.JmsConnectionImpl;
import com.ibm.ws.sib.api.jms.impl.JmsErrorUtils;
import com.ibm.ws.sib.api.jms.impl.JmsJMSConsumerImpl;
import com.ibm.ws.sib.api.jms.impl.JmsJMSProducerImpl;
import com.ibm.ws.sib.api.jms.impl.JmsSessionImpl;
import com.ibm.ws.sib.utils.ras.SibTr;
import jakarta.jms.BytesMessage;
import jakarta.jms.ConnectionMetaData;
import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.IllegalStateException;
import jakarta.jms.IllegalStateRuntimeException;
import jakarta.jms.InvalidClientIDException;
import jakarta.jms.InvalidClientIDRuntimeException;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.InvalidDestinationRuntimeException;
import jakarta.jms.InvalidSelectorException;
import jakarta.jms.InvalidSelectorRuntimeException;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSException;
import jakarta.jms.JMSProducer;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.StreamMessage;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TransactionRolledBackException;
import jakarta.jms.TransactionRolledBackRuntimeException;
import java.io.Serializable;

public class JmsJMSContextImpl
implements JmsJMSContext {
    private final JmsConnectionImpl jmsConnection;
    private JmsSessionImpl jmsSession;
    private boolean autoStart;
    private static TraceComponent tc = SibTr.register(JmsJMSContextImpl.class, (String)"SIBJms_External", (String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");

    JmsJMSContextImpl(JmsConnectionImpl jmsConnection, int sessionMode, boolean fixClientID) throws JMSRuntimeException {
        block7: {
            this.autoStart = true;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"JmsJMSContextImpl", (Object)new Object[]{jmsConnection, sessionMode});
            }
            this.jmsConnection = jmsConnection;
            try {
                this.jmsSession = sessionMode == 0 ? (JmsSessionImpl)jmsConnection.createSession(true, sessionMode) : (JmsSessionImpl)jmsConnection.createSession(false, sessionMode);
                if (!fixClientID || jmsConnection.getClientID() != null && !jmsConnection.isDefaultClientId(jmsConnection.getClientID())) break block7;
                jmsConnection.unfixClientID();
            }
            catch (JMSException e) {
                try {
                    throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(e, JMSRuntimeException.class);
                }
                catch (Throwable throwable) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((Object)this, (TraceComponent)tc, (String)"JmsJMSContextImpl", (Object)new Object[]{this.jmsConnection, this.jmsSession});
                    }
                    throw throwable;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"JmsJMSContextImpl", (Object)new Object[]{this.jmsConnection, this.jmsSession});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledge() throws IllegalStateRuntimeException, JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"acknowledge");
        }
        try {
            if (this.jmsSession == null) {
                IllegalStateException ise = (IllegalStateException)JmsErrorUtils.newThrowable(IllegalStateException.class, "INVALID_FOR_UNCONSUMED_MSG_CWSIA0110", new Object[]{"acknowledge"}, tc);
                throw (IllegalStateRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)ise), IllegalStateRuntimeException.class);
            }
            Object ise = this.jmsSession.getSessionSyncLock();
            synchronized (ise) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"got lock");
                }
                this.jmsSession.checkNotClosed();
                this.jmsSession.checkSynchronousUsage("acknowledge");
                int sessAck = this.jmsSession.getAcknowledgeMode();
                if (sessAck == 2) {
                    this.jmsSession.commitTransaction();
                }
            }
        }
        catch (IllegalStateException ise) {
            throw (IllegalStateRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)ise), IllegalStateRuntimeException.class);
        }
        catch (JMSException jmse) {
            throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"acknowledge");
            }
        }
    }

    public void close() throws IllegalStateRuntimeException, JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"close");
        }
        try {
            this.jmsSession.close();
            if (this.jmsConnection.getSessionCount() == 0) {
                this.jmsConnection.close();
            }
        }
        catch (IllegalStateException ise) {
            throw (IllegalStateRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)ise), IllegalStateRuntimeException.class);
        }
        catch (JMSException jmse) {
            throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"close");
            }
        }
    }

    public void commit() throws IllegalStateRuntimeException, TransactionRolledBackRuntimeException, JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"commit");
        }
        try {
            this.jmsSession.commit();
        }
        catch (IllegalStateException ise) {
            throw (IllegalStateRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)ise), IllegalStateRuntimeException.class);
        }
        catch (TransactionRolledBackException trbe) {
            throw (TransactionRolledBackRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)trbe), TransactionRolledBackRuntimeException.class);
        }
        catch (JMSException jmse) {
            throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"commit");
            }
        }
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSRuntimeException, InvalidDestinationRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createBrowser", (Object)queue);
        }
        QueueBrowser queueBrowser = null;
        try {
            queueBrowser = this.jmsSession.createBrowser(queue);
        }
        catch (InvalidDestinationException ide) {
            throw (InvalidDestinationRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)ide), InvalidDestinationRuntimeException.class);
        }
        catch (JMSException jmse) {
            throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"createBrowser");
            }
        }
        return queueBrowser;
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSRuntimeException, InvalidDestinationRuntimeException, InvalidSelectorRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createBrowser", (Object)new Object[]{queue, messageSelector});
        }
        QueueBrowser queueBrowser = null;
        try {
            queueBrowser = this.jmsSession.createBrowser(queue, messageSelector);
        }
        catch (InvalidDestinationException ide) {
            throw (InvalidDestinationRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)ide), InvalidDestinationRuntimeException.class);
        }
        catch (InvalidSelectorException ise) {
            throw (InvalidSelectorRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)ise), InvalidSelectorRuntimeException.class);
        }
        catch (JMSException jmse) {
            throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"createBrowser");
            }
        }
        return queueBrowser;
    }

    public BytesMessage createBytesMessage() throws JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createBytesMessage");
        }
        BytesMessage bytesMessage = null;
        try {
            bytesMessage = this.jmsSession.createBytesMessage();
        }
        catch (JMSException e) {
            throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(e, JMSRuntimeException.class);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"createBytesMessage");
            }
        }
        return bytesMessage;
    }

    private void autoStartConsumer() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"autoStartConsumer", (Object)new Object[]{this.autoStart, this.jmsConnection.getState()});
        }
        try {
            if (this.autoStart && this.jmsConnection.getState() == 1) {
                this.jmsConnection.start();
            }
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"autoStartConsumer");
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JMSConsumer createConsumer(Destination destination) throws JMSRuntimeException, InvalidDestinationRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createConsumer", (Object)new Object[]{destination});
        }
        JmsJMSConsumerImpl jmsConsumer = null;
        try {
            MessageConsumer messageConsumer = this.jmsSession.createConsumer(destination);
            jmsConsumer = new JmsJMSConsumerImpl(messageConsumer);
            this.autoStartConsumer();
        }
        catch (InvalidDestinationException ide) {
            try {
                throw (InvalidDestinationRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)ide), InvalidDestinationRuntimeException.class);
                catch (JMSException jmse) {
                    throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
                }
            }
            catch (Throwable throwable) {
                if (!TraceComponent.isAnyTracingEnabled()) throw throwable;
                if (!tc.isEntryEnabled()) throw throwable;
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"createConsumer", (Object)new Object[]{jmsConsumer});
                throw throwable;
            }
        }
        if (!TraceComponent.isAnyTracingEnabled()) return jmsConsumer;
        if (!tc.isEntryEnabled()) return jmsConsumer;
        SibTr.exit((Object)this, (TraceComponent)tc, (String)"createConsumer", (Object)new Object[]{jmsConsumer});
        return jmsConsumer;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JMSConsumer createConsumer(Destination destination, String messageSelector) throws JMSRuntimeException, InvalidDestinationRuntimeException, InvalidSelectorRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createConsumer", (Object)new Object[]{destination, messageSelector});
        }
        JmsJMSConsumerImpl jmsConsumer = null;
        try {
            MessageConsumer messageConsumer = this.jmsSession.createConsumer(destination, messageSelector);
            jmsConsumer = new JmsJMSConsumerImpl(messageConsumer);
            this.autoStartConsumer();
        }
        catch (InvalidDestinationException ide) {
            try {
                throw (InvalidDestinationRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)ide), InvalidDestinationRuntimeException.class);
                catch (InvalidSelectorException ise) {
                    throw (InvalidSelectorRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)ise), InvalidSelectorRuntimeException.class);
                }
                catch (JMSException jmse) {
                    throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
                }
            }
            catch (Throwable throwable) {
                if (!TraceComponent.isAnyTracingEnabled()) throw throwable;
                if (!tc.isEntryEnabled()) throw throwable;
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"createConsumer", (Object)new Object[]{jmsConsumer});
                throw throwable;
            }
        }
        if (!TraceComponent.isAnyTracingEnabled()) return jmsConsumer;
        if (!tc.isEntryEnabled()) return jmsConsumer;
        SibTr.exit((Object)this, (TraceComponent)tc, (String)"createConsumer", (Object)new Object[]{jmsConsumer});
        return jmsConsumer;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JMSConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSRuntimeException, InvalidDestinationRuntimeException, InvalidSelectorRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createConsumer", (Object)new Object[]{destination, messageSelector, noLocal});
        }
        JmsJMSConsumerImpl jmsConsumer = null;
        try {
            MessageConsumer messageConsumer = this.jmsSession.createConsumer(destination, messageSelector, noLocal);
            jmsConsumer = new JmsJMSConsumerImpl(messageConsumer);
            this.autoStartConsumer();
        }
        catch (InvalidDestinationException ide) {
            try {
                throw (InvalidDestinationRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)ide), InvalidDestinationRuntimeException.class);
                catch (InvalidSelectorException ise) {
                    throw (InvalidSelectorRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)ise), InvalidSelectorRuntimeException.class);
                }
                catch (JMSException jmse) {
                    throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
                }
            }
            catch (Throwable throwable) {
                if (!TraceComponent.isAnyTracingEnabled()) throw throwable;
                if (!tc.isEntryEnabled()) throw throwable;
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"createConsumer", (Object)new Object[]{jmsConsumer});
                throw throwable;
            }
        }
        if (!TraceComponent.isAnyTracingEnabled()) return jmsConsumer;
        if (!tc.isEntryEnabled()) return jmsConsumer;
        SibTr.exit((Object)this, (TraceComponent)tc, (String)"createConsumer", (Object)new Object[]{jmsConsumer});
        return jmsConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JMSContext createContext(int sessionMode) throws JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createContext", (Object)new Object[]{sessionMode});
        }
        JmsJMSContextImpl jmsContext = null;
        if (this.jmsConnection.isManaged()) {
            JMSException jmse = (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "CREATECONTEXT_IN_CONTAINER_CWSIA0513", null, tc);
            throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
        }
        try {
            switch (sessionMode) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    throw (JMSRuntimeException)JmsErrorUtils.newThrowable(JMSRuntimeException.class, "INVALID_ACKNOWLEDGE_MODE_CWSIA0514", new Object[0], tc);
                }
            }
            jmsContext = new JmsJMSContextImpl(this.jmsConnection, sessionMode, false);
        }
        catch (Throwable throwable) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"createContext", (Object)new Object[]{jmsContext});
            }
            throw throwable;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createContext", (Object)new Object[]{jmsContext});
        }
        return jmsContext;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JMSConsumer createDurableConsumer(Topic topic, String name) throws InvalidDestinationRuntimeException, IllegalStateRuntimeException, JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createDurableConsumer", (Object)new Object[]{topic, name});
        }
        JmsJMSConsumerImpl jmsConsumer = null;
        try {
            MessageConsumer messageConsumer = this.jmsSession.createDurableConsumer(topic, name);
            jmsConsumer = new JmsJMSConsumerImpl(messageConsumer);
            this.autoStartConsumer();
        }
        catch (InvalidDestinationException ide) {
            try {
                throw (InvalidDestinationRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)ide), InvalidDestinationRuntimeException.class);
                catch (IllegalStateException ise) {
                    throw (IllegalStateRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)ise), IllegalStateRuntimeException.class);
                }
                catch (JMSException jmse) {
                    throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
                }
            }
            catch (Throwable throwable) {
                if (!TraceComponent.isAnyTracingEnabled()) throw throwable;
                if (!tc.isEntryEnabled()) throw throwable;
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"createDurableConsumer", (Object)new Object[]{jmsConsumer});
                throw throwable;
            }
        }
        if (!TraceComponent.isAnyTracingEnabled()) return jmsConsumer;
        if (!tc.isEntryEnabled()) return jmsConsumer;
        SibTr.exit((Object)this, (TraceComponent)tc, (String)"createDurableConsumer", (Object)new Object[]{jmsConsumer});
        return jmsConsumer;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JMSConsumer createDurableConsumer(Topic topic, String name, String messageSelector, boolean noLocal) throws InvalidDestinationRuntimeException, InvalidSelectorRuntimeException, IllegalStateRuntimeException, JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createDurableConsumer", (Object)new Object[]{topic, name, messageSelector, noLocal});
        }
        JmsJMSConsumerImpl jmsConsumer = null;
        try {
            MessageConsumer messageConsumer = this.jmsSession.createDurableConsumer(topic, name, messageSelector, noLocal);
            jmsConsumer = new JmsJMSConsumerImpl(messageConsumer);
            this.autoStartConsumer();
        }
        catch (InvalidDestinationException ide) {
            try {
                throw (InvalidDestinationRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)ide), InvalidDestinationRuntimeException.class);
                catch (InvalidSelectorException ise) {
                    throw (InvalidSelectorRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)ise), InvalidSelectorRuntimeException.class);
                }
                catch (IllegalStateException istatee) {
                    throw (IllegalStateRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)istatee), IllegalStateRuntimeException.class);
                }
                catch (JMSException jmse) {
                    throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
                }
            }
            catch (Throwable throwable) {
                if (!TraceComponent.isAnyTracingEnabled()) throw throwable;
                if (!tc.isEntryEnabled()) throw throwable;
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"createDurableConsumer", (Object)new Object[]{jmsConsumer});
                throw throwable;
            }
        }
        if (!TraceComponent.isAnyTracingEnabled()) return jmsConsumer;
        if (!tc.isEntryEnabled()) return jmsConsumer;
        SibTr.exit((Object)this, (TraceComponent)tc, (String)"createDurableConsumer", (Object)new Object[]{jmsConsumer});
        return jmsConsumer;
    }

    public MapMessage createMapMessage() throws JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createMapMessage");
        }
        MapMessage mapMessage = null;
        try {
            mapMessage = this.jmsSession.createMapMessage();
        }
        catch (JMSException jmse) {
            try {
                throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
            }
            catch (Throwable throwable) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"createMapMessage", (Object)new Object[]{mapMessage});
                }
                throw throwable;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createMapMessage", (Object)new Object[]{mapMessage});
        }
        return mapMessage;
    }

    public Message createMessage() throws JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createMessage");
        }
        Message message = null;
        try {
            message = this.jmsSession.createMessage();
        }
        catch (JMSException jmse) {
            try {
                throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
            }
            catch (Throwable throwable) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"createMessage", (Object)new Object[]{message});
                }
                throw throwable;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createMessage", (Object)new Object[]{message});
        }
        return message;
    }

    public ObjectMessage createObjectMessage() throws JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createObjectMessage");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = this.jmsSession.createObjectMessage();
        }
        catch (JMSException jmse) {
            try {
                throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
            }
            catch (Throwable throwable) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"createObjectMessage", (Object)new Object[]{objectMessage});
                }
                throw throwable;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createObjectMessage", (Object)new Object[]{objectMessage});
        }
        return objectMessage;
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createObjectMessage", (Object)new Object[]{object});
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = this.jmsSession.createObjectMessage(object);
        }
        catch (JMSException jmse) {
            try {
                throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
            }
            catch (Throwable throwable) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"createObjectMessage", (Object)new Object[]{objectMessage});
                }
                throw throwable;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createObjectMessage", (Object)new Object[]{objectMessage});
        }
        return objectMessage;
    }

    public JMSProducer createProducer() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createProducer");
        }
        JmsJMSProducerImpl jmsProducer = null;
        try {
            JmsMsgProducer msgProducer = this.jmsSession.instantiateProducer(null);
            jmsProducer = new JmsJMSProducerImpl(msgProducer);
        }
        catch (JMSException e) {
            FFDCFilter.processException((Throwable)e, (String)(JmsJMSContextImpl.class.toString() + ".createProducer"), (String)"598", (Object)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createProducer");
        }
        return jmsProducer;
    }

    public Queue createQueue(String queueName) throws JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createQueue", (Object)new Object[]{queueName});
        }
        Queue queue = null;
        try {
            queue = this.jmsSession.createQueue(queueName);
        }
        catch (JMSException jmse) {
            try {
                throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
            }
            catch (Throwable throwable) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"createQueue", (Object)new Object[]{queue});
                }
                throw throwable;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createQueue", (Object)new Object[]{queue});
        }
        return queue;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JMSConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName) throws JMSRuntimeException, InvalidDestinationRuntimeException, InvalidSelectorRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createSharedConsumer", (Object)new Object[]{topic, sharedSubscriptionName});
        }
        JmsJMSConsumerImpl jmsConsumer = null;
        try {
            MessageConsumer messageConsumer = this.jmsSession.createSharedConsumer(topic, sharedSubscriptionName);
            jmsConsumer = new JmsJMSConsumerImpl(messageConsumer);
            this.autoStartConsumer();
        }
        catch (InvalidDestinationException ide) {
            try {
                throw (InvalidDestinationRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)ide), InvalidDestinationRuntimeException.class);
                catch (InvalidSelectorException ise) {
                    throw (InvalidSelectorRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)ise), InvalidSelectorRuntimeException.class);
                }
                catch (JMSException jmse) {
                    throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
                }
            }
            catch (Throwable throwable) {
                if (!TraceComponent.isAnyTracingEnabled()) throw throwable;
                if (!tc.isEntryEnabled()) throw throwable;
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"createSharedConsumer", (Object)new Object[]{jmsConsumer});
                throw throwable;
            }
        }
        if (!TraceComponent.isAnyTracingEnabled()) return jmsConsumer;
        if (!tc.isEntryEnabled()) return jmsConsumer;
        SibTr.exit((Object)this, (TraceComponent)tc, (String)"createSharedConsumer", (Object)new Object[]{jmsConsumer});
        return jmsConsumer;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JMSConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName, String messageSelector) throws JMSRuntimeException, InvalidDestinationRuntimeException, InvalidSelectorRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createSharedConsumer", (Object)new Object[]{topic, sharedSubscriptionName, messageSelector});
        }
        JmsJMSConsumerImpl jmsConsumer = null;
        try {
            MessageConsumer messageConsumer = this.jmsSession.createSharedConsumer(topic, sharedSubscriptionName, messageSelector);
            jmsConsumer = new JmsJMSConsumerImpl(messageConsumer);
            this.autoStartConsumer();
        }
        catch (InvalidDestinationException ide) {
            try {
                throw (InvalidDestinationRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)ide), InvalidDestinationRuntimeException.class);
                catch (InvalidSelectorException ise) {
                    throw (InvalidSelectorRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)ise), InvalidSelectorRuntimeException.class);
                }
                catch (JMSException jmse) {
                    throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
                }
            }
            catch (Throwable throwable) {
                if (!TraceComponent.isAnyTracingEnabled()) throw throwable;
                if (!tc.isEntryEnabled()) throw throwable;
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"createSharedConsumer", (Object)new Object[]{jmsConsumer});
                throw throwable;
            }
        }
        if (!TraceComponent.isAnyTracingEnabled()) return jmsConsumer;
        if (!tc.isEntryEnabled()) return jmsConsumer;
        SibTr.exit((Object)this, (TraceComponent)tc, (String)"createSharedConsumer", (Object)new Object[]{jmsConsumer});
        return jmsConsumer;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JMSConsumer createSharedDurableConsumer(Topic topic, String name) throws InvalidDestinationRuntimeException, JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createSharedDurableConsumer", (Object)new Object[]{topic, name});
        }
        JmsJMSConsumerImpl jmsConsumer = null;
        try {
            MessageConsumer messageConsumer = this.jmsSession.createSharedDurableConsumer(topic, name);
            jmsConsumer = new JmsJMSConsumerImpl(messageConsumer);
            this.autoStartConsumer();
        }
        catch (InvalidDestinationException ide) {
            try {
                throw (InvalidDestinationRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)ide), InvalidDestinationRuntimeException.class);
                catch (JMSException jmse) {
                    throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
                }
            }
            catch (Throwable throwable) {
                if (!TraceComponent.isAnyTracingEnabled()) throw throwable;
                if (!tc.isEntryEnabled()) throw throwable;
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"createSharedDurableConsumer", (Object)new Object[]{jmsConsumer});
                throw throwable;
            }
        }
        if (!TraceComponent.isAnyTracingEnabled()) return jmsConsumer;
        if (!tc.isEntryEnabled()) return jmsConsumer;
        SibTr.exit((Object)this, (TraceComponent)tc, (String)"createSharedDurableConsumer", (Object)new Object[]{jmsConsumer});
        return jmsConsumer;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JMSConsumer createSharedDurableConsumer(Topic topic, String name, String messageSelector) throws InvalidDestinationRuntimeException, InvalidSelectorRuntimeException, JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createSharedDurableConsumer", (Object)new Object[]{topic, name, messageSelector});
        }
        JmsJMSConsumerImpl jmsConsumer = null;
        try {
            MessageConsumer messageConsumer = this.jmsSession.createSharedDurableConsumer(topic, name, messageSelector);
            jmsConsumer = new JmsJMSConsumerImpl(messageConsumer);
            this.autoStartConsumer();
        }
        catch (InvalidDestinationException ide) {
            try {
                throw (InvalidDestinationRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)ide), InvalidDestinationRuntimeException.class);
                catch (InvalidSelectorException ise) {
                    throw (InvalidSelectorRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)ise), InvalidSelectorRuntimeException.class);
                }
                catch (JMSException jmse) {
                    throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
                }
            }
            catch (Throwable throwable) {
                if (!TraceComponent.isAnyTracingEnabled()) throw throwable;
                if (!tc.isEntryEnabled()) throw throwable;
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"createSharedDurableConsumer", (Object)new Object[]{jmsConsumer});
                throw throwable;
            }
        }
        if (!TraceComponent.isAnyTracingEnabled()) return jmsConsumer;
        if (!tc.isEntryEnabled()) return jmsConsumer;
        SibTr.exit((Object)this, (TraceComponent)tc, (String)"createSharedDurableConsumer", (Object)new Object[]{jmsConsumer});
        return jmsConsumer;
    }

    public StreamMessage createStreamMessage() throws JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createStreamMessage");
        }
        StreamMessage streamMessage = null;
        try {
            streamMessage = this.jmsSession.createStreamMessage();
        }
        catch (JMSException jmse) {
            try {
                throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
            }
            catch (Throwable throwable) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"createStreamMessage", (Object)new Object[]{streamMessage});
                }
                throw throwable;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createStreamMessage", (Object)new Object[]{streamMessage});
        }
        return streamMessage;
    }

    public TemporaryQueue createTemporaryQueue() throws JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createTemporaryQueue");
        }
        TemporaryQueue tempQueue = null;
        try {
            tempQueue = this.jmsSession.createTemporaryQueue();
        }
        catch (JMSException jmse) {
            try {
                throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
            }
            catch (Throwable throwable) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"createTemporaryQueue", (Object)new Object[]{tempQueue});
                }
                throw throwable;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createTemporaryQueue", (Object)new Object[]{tempQueue});
        }
        return tempQueue;
    }

    public TemporaryTopic createTemporaryTopic() throws JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createTemporaryTopic");
        }
        TemporaryTopic temptopic = null;
        try {
            temptopic = this.jmsSession.createTemporaryTopic();
        }
        catch (JMSException jmse) {
            try {
                throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
            }
            catch (Throwable throwable) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"createTemporaryTopic", (Object)new Object[]{temptopic});
                }
                throw throwable;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createTemporaryTopic", (Object)new Object[]{temptopic});
        }
        return temptopic;
    }

    public TextMessage createTextMessage() throws JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createTextMessage");
        }
        TextMessage textMessage = null;
        try {
            textMessage = this.jmsSession.createTextMessage();
        }
        catch (JMSException jmse) {
            try {
                throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
            }
            catch (Throwable throwable) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"createTextMessage", (Object)new Object[]{textMessage});
                }
                throw throwable;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createTextMessage", (Object)new Object[]{textMessage});
        }
        return textMessage;
    }

    public TextMessage createTextMessage(String text) throws JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createTextMessage", (Object)new Object[]{text});
        }
        TextMessage textMessage = null;
        try {
            textMessage = this.jmsSession.createTextMessage(text);
        }
        catch (JMSException jmse) {
            try {
                throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
            }
            catch (Throwable throwable) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"createTextMessage", (Object)new Object[]{textMessage});
                }
                throw throwable;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createTextMessage", (Object)new Object[]{textMessage});
        }
        return textMessage;
    }

    public Topic createTopic(String topicName) throws JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createTopic", (Object)new Object[]{topicName});
        }
        Topic topic = null;
        try {
            topic = this.jmsSession.createTopic(topicName);
        }
        catch (JMSException jmse) {
            try {
                throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
            }
            catch (Throwable throwable) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"createTopic", (Object)new Object[]{topic});
                }
                throw throwable;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createTopic", (Object)new Object[]{topic});
        }
        return topic;
    }

    public boolean getAutoStart() {
        return this.autoStart;
    }

    public String getClientID() throws JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getClientID");
        }
        String clientId = null;
        try {
            clientId = this.jmsConnection.getClientID();
        }
        catch (JMSException jmse) {
            try {
                throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
            }
            catch (Throwable throwable) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"getClientID", (Object)new Object[]{clientId});
                }
                throw throwable;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getClientID", (Object)new Object[]{clientId});
        }
        return clientId;
    }

    public ExceptionListener getExceptionListener() throws JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getExceptionListener");
        }
        ExceptionListener exceptionListener = null;
        try {
            exceptionListener = this.jmsConnection.getExceptionListener();
        }
        catch (JMSException jmse) {
            try {
                throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
            }
            catch (Throwable throwable) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"getExceptionListener", (Object)new Object[]{exceptionListener});
                }
                throw throwable;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getExceptionListener", (Object)new Object[]{exceptionListener});
        }
        return exceptionListener;
    }

    public ConnectionMetaData getMetaData() throws JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getMetaData");
        }
        ConnectionMetaData connectionMetaData = null;
        try {
            connectionMetaData = this.jmsConnection.getMetaData();
        }
        catch (JMSException jmse) {
            try {
                throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
            }
            catch (Throwable throwable) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"getMetaData", (Object)new Object[]{connectionMetaData});
                }
                throw throwable;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getMetaData", (Object)new Object[]{connectionMetaData});
        }
        return connectionMetaData;
    }

    public int getSessionMode() throws JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getSessionMode");
        }
        int sessionMode = -1;
        try {
            sessionMode = this.jmsSession.getAcknowledgeMode();
        }
        catch (JMSException jmse) {
            try {
                throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
            }
            catch (Throwable throwable) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"getSessionMode", (Object)new Object[]{sessionMode});
                }
                throw throwable;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getSessionMode", (Object)new Object[]{sessionMode});
        }
        return sessionMode;
    }

    public boolean getTransacted() throws JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getTransacted");
        }
        boolean transacted = false;
        try {
            transacted = this.jmsSession.getTransacted();
        }
        catch (JMSException jmse) {
            try {
                throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
            }
            catch (Throwable throwable) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"getTransacted", (Object)new Object[]{transacted});
                }
                throw throwable;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getTransacted", (Object)new Object[]{transacted});
        }
        return transacted;
    }

    public void recover() throws IllegalStateRuntimeException, JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"recover");
        }
        try {
            this.jmsSession.recover();
        }
        catch (IllegalStateException ise) {
            throw (IllegalStateRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)ise), IllegalStateRuntimeException.class);
        }
        catch (JMSException jmse) {
            throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"recover");
            }
        }
    }

    public void rollback() throws IllegalStateRuntimeException, JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"rollback");
        }
        try {
            this.jmsSession.rollback();
        }
        catch (IllegalStateException ise) {
            throw (IllegalStateRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)ise), IllegalStateRuntimeException.class);
        }
        catch (JMSException jmse) {
            throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"rollback");
            }
        }
    }

    public void setAutoStart(boolean autoStart) throws IllegalStateRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setAutoStart", (Object)new Object[]{autoStart});
        }
        try {
            this.autoStart = autoStart;
        }
        catch (Throwable throwable) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"setAutoStart", (Object)new Object[]{this.autoStart});
            }
            throw throwable;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setAutoStart", (Object)new Object[]{this.autoStart});
        }
    }

    public void setClientID(String clientID) throws InvalidClientIDRuntimeException, IllegalStateRuntimeException, JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setClientID", (Object)new Object[]{clientID});
        }
        try {
            this.jmsConnection.setClientID(clientID);
        }
        catch (InvalidClientIDException icie) {
            throw (InvalidClientIDRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)icie), InvalidClientIDRuntimeException.class);
        }
        catch (IllegalStateException ise) {
            throw (IllegalStateRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)ise), IllegalStateRuntimeException.class);
        }
        catch (JMSException jmse) {
            throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"setClientID");
            }
        }
    }

    public void setExceptionListener(ExceptionListener eListener) throws IllegalStateRuntimeException, JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setExceptionListener", (Object)new Object[]{eListener});
        }
        try {
            this.jmsConnection.setExceptionListener(eListener);
        }
        catch (IllegalStateException ise) {
            throw (IllegalStateRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)ise), IllegalStateRuntimeException.class);
        }
        catch (JMSException jmse) {
            throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"setExceptionListener");
            }
        }
    }

    public void start() throws IllegalStateRuntimeException, JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"start");
        }
        try {
            this.jmsConnection.start();
        }
        catch (IllegalStateException ise) {
            throw (IllegalStateRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)ise), IllegalStateRuntimeException.class);
        }
        catch (JMSException jmse) {
            throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"start");
            }
        }
    }

    public void stop() throws IllegalStateRuntimeException, JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"stop");
        }
        try {
            this.jmsConnection.stop();
        }
        catch (IllegalStateException ise) {
            throw (IllegalStateRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)ise), IllegalStateRuntimeException.class);
        }
        catch (JMSException jmse) {
            throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"stop");
            }
        }
    }

    public void unsubscribe(String subName) throws JMSRuntimeException, InvalidDestinationRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"unsubscribe", (Object)new Object[]{subName});
        }
        try {
            this.jmsSession.unsubscribe(subName);
        }
        catch (InvalidDestinationException ide) {
            throw (InvalidDestinationRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)ide), InvalidDestinationRuntimeException.class);
        }
        catch (JMSException jmse) {
            throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"unsubscribe");
            }
        }
    }
}

