/*
 * Decompiled with CFR 0.152.
 */
package jain.protocol.ip.sip;

import jain.protocol.ip.sip.SipException;
import jain.protocol.ip.sip.SipPeerUnavailableException;
import jain.protocol.ip.sip.SipStack;
import jain.protocol.ip.sip.address.AddressFactory;
import jain.protocol.ip.sip.header.HeaderFactory;
import jain.protocol.ip.sip.message.MessageFactory;

public class SipFactory {
    private String pathName = "com.ibm.ws";
    private static SipFactory myFactory;

    public MessageFactory createMessageFactory() throws SipPeerUnavailableException {
        return (MessageFactory)this.createSipObject("jain.protocol.ip.sip.message.MessageFactoryImpl");
    }

    public void setPathName(String pathName) {
        this.pathName = pathName;
    }

    public String getPathName() {
        return this.pathName;
    }

    public HeaderFactory createHeaderFactory() throws SipPeerUnavailableException {
        return (HeaderFactory)this.createSipObject("jain.protocol.ip.sip.header.HeaderFactoryImpl");
    }

    public AddressFactory createAddressFactory() throws SipPeerUnavailableException {
        return (AddressFactory)this.createSipObject("jain.protocol.ip.sip.address.AddressFactoryImpl");
    }

    public SipStack createSipStack() throws SipPeerUnavailableException, SipException {
        return (SipStack)this.createSipObject("jain.protocol.ip.sip.SipStackImpl");
    }

    public static synchronized SipFactory getInstance() {
        if (myFactory == null) {
            myFactory = new SipFactory();
        }
        return myFactory;
    }

    private Object createSipObject(String objectClassName) throws SipPeerUnavailableException {
        if (objectClassName == null) {
            throw new SipPeerUnavailableException();
        }
        try {
            Class<?> peerObjectClass = Class.forName(this.getPathName() + "." + objectClassName);
            Object newPeerObject = peerObjectClass.newInstance();
            return newPeerObject;
        }
        catch (Exception e2) {
            String errmsg = "The Peer JAIN SIP Object: " + this.getPathName() + "." + objectClassName + " could not be instantiated. Ensure the Path Name has been set.";
            throw new SipPeerUnavailableException(errmsg + "\n" + e2.getMessage());
        }
    }

    private SipFactory() {
    }
}

