/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.context;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.stack.context.MessageContext;
import com.ibm.ws.sip.stack.transaction.transport.BackupMessageSenderFactory;
import com.ibm.ws.sip.stack.transaction.transport.IBackupMessageSender;
import com.ibm.ws.sip.stack.transaction.transport.SIPTransportException;
import com.ibm.ws.sip.stack.transaction.transport.TransportCommLayerMgr;
import com.ibm.ws.sip.stack.util.SipStackUtil;
import jain.protocol.ip.sip.header.CSeqHeader;
import jain.protocol.ip.sip.message.Message;

public class ResponseContext
extends MessageContext {
    private static final LogMgr s_logger = Log.get(ResponseContext.class);
    private boolean m_sendToReceivedAddress = true;

    @Override
    public void handleFailure() {
        if (this.m_sendToReceivedAddress) {
            this.m_sendToReceivedAddress = false;
            String method = this.getMethod();
            if (method != null && (method.equals("STARTUP") || method.equals("KEEPALIVE"))) {
                if (s_logger.isTraceDebugEnabled()) {
                    s_logger.traceDebug(this, "hanleFailure", "not applying response-failover to [" + method + ']');
                }
                return;
            }
            try {
                if (SipStackUtil.topViaHasReceivedTag(this.sipMessage)) {
                    TransportCommLayerMgr.instance().sendMessage(this, null, null);
                    return;
                }
            }
            catch (SIPTransportException e2) {
                e2.printStackTrace();
            }
        }
        if (this.getSender() == null) {
            IBackupMessageSender backupMessageSender = BackupMessageSenderFactory.instance().getBackupSender();
            this.setSender(backupMessageSender);
        }
        this.getSender().sendMessageToBackup(this);
    }

    @Override
    protected void doneWithContext() {
        BackupMessageSenderFactory.instance().finishToUseSender(this.getSender());
    }

    @Override
    public void cleanItself() {
        this.m_sendToReceivedAddress = true;
        super.cleanItself();
    }

    private String getMethod() {
        Message message = this.getSipMessage();
        if (message == null) {
            return null;
        }
        CSeqHeader cseq = message.getCSeqHeader();
        if (cseq == null) {
            return null;
        }
        String method = cseq.getMethod();
        return method;
    }
}

