/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.timer;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.internal.SipContainerComponent;
import com.ibm.ws.sip.container.parser.SipAppDesc;
import com.ibm.ws.sip.container.servlets.SipApplicationSessionImpl;
import com.ibm.ws.sip.container.timer.BaseTimerService;
import com.ibm.ws.sip.container.timer.ServletTimerImpl;
import java.io.Serializable;
import javax.servlet.sip.ServletTimer;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.TimerService;

public class ExternTimerService
implements TimerService {
    private static final LogMgr c_logger = Log.get(ExternTimerService.class);
    private BaseTimerService timerService = SipContainerComponent.getTimerService();
    private static ExternTimerService instance = new ExternTimerService();

    public static ExternTimerService getInstance() {
        return instance;
    }

    @Override
    public ServletTimer createTimer(SipApplicationSession appSession, long delay, boolean isPersistent, Serializable info) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{appSession, new Long(delay), new Boolean(isPersistent), info};
            c_logger.traceEntry((Object)this, "createTimer", params);
        }
        SipApplicationSessionImpl appSessionImpl = (SipApplicationSessionImpl)appSession;
        this.checkIfSessionValid(appSessionImpl);
        ServletTimerImpl timer = null;
        timer = new ServletTimerImpl((SipApplicationSessionImpl)appSession, info);
        this.timerService.schedule(timer, isPersistent, delay);
        appSessionImpl.addTimer(timer);
        return timer;
    }

    @Override
    public ServletTimer createTimer(SipApplicationSession appSession, long delay, long period, boolean fixedDelay, boolean isPersistent, Serializable info) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{appSession, new Long(delay), new Long(period), new Boolean(fixedDelay), new Boolean(isPersistent), info};
            c_logger.traceEntry((Object)this, "createTimer", params);
        }
        SipApplicationSessionImpl appSessionImpl = (SipApplicationSessionImpl)appSession;
        this.checkIfSessionValid(appSessionImpl);
        ServletTimerImpl timer = null;
        timer = new ServletTimerImpl((SipApplicationSessionImpl)appSession, info);
        this.timerService.schedule(timer, isPersistent, delay, period, fixedDelay);
        appSessionImpl.addTimer(timer);
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "createTimer", timer);
        }
        return timer;
    }

    private void checkIfSessionValid(SipApplicationSessionImpl appSessionImpl) throws IllegalStateException {
        if (appSessionImpl == null || !appSessionImpl.isValid()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "createTimer", "Null or Invalid App Session: " + appSessionImpl);
            }
            throw new IllegalStateException("Session is null or invalid " + appSessionImpl);
        }
        SipAppDesc appDesc = appSessionImpl.getAppDescriptor();
        if (appDesc == null || appDesc.getTimerListener() == null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "createTimer", "Timer listener not associated with Application Session  " + appDesc);
            }
            throw new IllegalStateException("Timer Listener not associated with Application Session " + appDesc);
        }
    }
}

