/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.protocol;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.protocol.Flow;
import com.ibm.ws.sip.container.protocol.FlowTokenSecurity;
import com.ibm.ws.sip.container.proxy.SipProxyInfo;
import com.ibm.ws.sip.container.servlets.SipServletRequestImpl;
import com.ibm.ws.sip.container.servlets.SipServletsFactoryImpl;
import com.ibm.ws.sip.parser.util.Base64Parser;
import com.ibm.ws.sip.stack.transaction.util.SIPStackUtil;
import com.ibm.ws.sip.stack.util.AddressUtils;
import jain.protocol.ip.sip.ListeningPoint;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.SipProvider;
import jain.protocol.ip.sip.address.NameAddress;
import jain.protocol.ip.sip.address.SipURL;
import jain.protocol.ip.sip.address.URI;
import jain.protocol.ip.sip.header.ContactHeader;
import jain.protocol.ip.sip.header.HeaderIterator;
import jain.protocol.ip.sip.header.HeaderParseException;
import jain.protocol.ip.sip.header.NameAddressHeader;
import jain.protocol.ip.sip.header.ViaHeader;
import jain.protocol.ip.sip.message.Message;
import jain.protocol.ip.sip.message.Request;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ListIterator;
import javax.crypto.Mac;
import javax.servlet.sip.Address;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipURI;

public class OutboundProcessor {
    private static final LogMgr s_logger = Log.get(OutboundProcessor.class);
    private static final OutboundProcessor s_instance = new OutboundProcessor();
    private final boolean m_standalone;
    private static final ThreadLocal<Address[]> s_topRoutes = new ThreadLocal<Address[]>(){

        @Override
        protected Address[] initialValue() {
            return new Address[2];
        }
    };

    public static OutboundProcessor instance() {
        return s_instance;
    }

    private OutboundProcessor() {
        this.m_standalone = true;
    }

    public boolean processRequest(SipServletRequestImpl inRequest) {
        try {
            if (!this.isOutboundExtensionRegisterRequest(inRequest)) {
                return false;
            }
        }
        catch (SipParseException e2) {
            if (s_logger.isTraceFailureEnabled()) {
                s_logger.traceFailure(this, "processRequest", "", e2);
            }
            return false;
        }
        if (s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug(this, "processRequest", "request qualifies for outbound extension processing");
        }
        this.processRegisterRequest(inRequest);
        return true;
    }

    private boolean isOutboundExtensionRegisterRequest(SipServletRequestImpl inRequest) throws SipParseException {
        Request request = inRequest.getRequest();
        if (!request.getMethod().equals("REGISTER")) {
            return false;
        }
        if (!this.isDirect(request)) {
            return false;
        }
        HeaderIterator contacts = request.getContactHeaders();
        if (contacts == null) {
            return false;
        }
        while (contacts.hasNext()) {
            ContactHeader contact = (ContactHeader)contacts.next();
            if (contact.getParameter("reg-id") != null) continue;
            return false;
        }
        return true;
    }

    private void processRegisterRequest(SipServletRequestImpl inRequest) {
        String flowToken = this.createFlowToken(inRequest);
        boolean sips = inRequest.getRequestURI().getScheme().equalsIgnoreCase("sips");
        String transport = inRequest.getTransport();
        String selfHost = this.getSelfHost(inRequest);
        int selfPort = this.getSelfPort(inRequest);
        SipServletsFactoryImpl sipFactory = SipServletsFactoryImpl.getInstance();
        SipURI uri = sipFactory.createSipURI(flowToken, selfHost);
        uri.setSecure(sips);
        uri.setPort(selfPort);
        if (sips && transport.equals("tls")) {
            transport = "tcp";
        }
        uri.setTransportParam(transport);
        uri.setParameter("ob", "");
        uri.setLrParam(true);
        Address address = sipFactory.createAddress(uri);
        inRequest.addAddressHeader("Path", address, true);
        if (s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug(this, "processRegisterRequest", "path header added to request [" + address + ']');
        }
    }

    private String createFlowToken(SipServletRequestImpl request) {
        int proxyPort;
        String proxyHost;
        String transport = request.getTransport();
        String localHost = request.getLocalAddr();
        int localPort = request.getLocalPort();
        String remoteHost = request.getRemoteAddr();
        int remotePort = request.getRemotePort();
        if (this.m_standalone) {
            proxyHost = null;
            proxyPort = 0;
        } else {
            Request jainRequest = request.getRequest();
            try {
                ViaHeader via = (ViaHeader)jainRequest.getHeader("Via", true);
                proxyHost = via.getReceived();
                if (proxyHost == null) {
                    proxyHost = via.getHost();
                }
                proxyPort = via.getPort();
            }
            catch (Exception e2) {
                if (s_logger.isTraceFailureEnabled()) {
                    s_logger.traceFailure(this, "createFlowToken", "", e2);
                }
                proxyHost = null;
                proxyPort = 0;
            }
        }
        localHost = SIPStackUtil.getHostAddress(localHost);
        String flowToken = this.encodeFlowToken(transport, remoteHost, remotePort, localHost, localPort, proxyHost, proxyPort);
        return flowToken;
    }

    private String encodeFlowToken(String transport, String remoteHost, int remotePort, String localHost, int localPort, String proxyHost, int proxyPort) {
        int transportValue;
        int macSize;
        int localHostSize;
        if (s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug(this, "encodeFlowToken", "remote [" + remoteHost + ':' + remotePort + "] local [" + localHost + ':' + localPort + "] proxy [" + proxyHost + ':' + proxyPort + ']');
        }
        int remoteHostSize = remoteHost.indexOf(58) == -1 ? 4 : 16;
        int n = localHostSize = localHost.indexOf(58) == -1 ? 4 : 16;
        int proxyHostSize = proxyHost == null ? 0 : (proxyHost.indexOf(58) == -1 ? 4 : 16);
        FlowTokenSecurity flowTokenSecurity = FlowTokenSecurity.instance();
        FlowTokenSecurity.Secret secret = flowTokenSecurity.getLatestSecret();
        Mac mac = secret == null ? null : secret.m_mac;
        int n2 = macSize = mac == null ? 0 : mac.getMacLength();
        if (macSize > 255) {
            macSize = 255;
        }
        int tokenSize = 5 + remoteHostSize + 2 + 1 + localHostSize + 2 + 1 + proxyHostSize + 2 + 1 + macSize;
        byte[] byteArray = new byte[tokenSize];
        int byteArrayIndex = 0;
        byteArray[byteArrayIndex++] = 105;
        byteArray[byteArrayIndex++] = 98;
        byteArray[byteArrayIndex++] = 109;
        if (transport.equalsIgnoreCase("udp")) {
            transportValue = 0;
        } else if (transport.equalsIgnoreCase("tcp")) {
            transportValue = 1;
        } else if (transport.equalsIgnoreCase("tls")) {
            transportValue = 2;
        } else {
            throw new RuntimeException("invalid transport [" + transport + ']');
        }
        byteArray[byteArrayIndex++] = transportValue;
        if (remoteHostSize != 4 && remoteHostSize != 16) {
            throw new RuntimeException("invalid remote host [" + remoteHost + ']');
        }
        byte[] remoteHostBytes = AddressUtils.convertIP(remoteHost);
        byteArray[byteArrayIndex++] = (byte)(remoteHostSize & 0xFF);
        System.arraycopy(remoteHostBytes, 0, byteArray, byteArrayIndex, remoteHostSize);
        byteArrayIndex += remoteHostSize;
        byteArray[byteArrayIndex++] = (byte)((remotePort & 0xFF00) >> 8);
        byteArray[byteArrayIndex++] = (byte)(remotePort & 0xFF);
        if (localHostSize != 4 && localHostSize != 16) {
            throw new RuntimeException("invalid local host [" + localHost + ']');
        }
        byteArray[byteArrayIndex++] = (byte)(localHostSize & 0xFF);
        byte[] localHostBytes = AddressUtils.convertIP(localHost);
        System.arraycopy(localHostBytes, 0, byteArray, byteArrayIndex, localHostSize);
        byteArrayIndex += localHostSize;
        byteArray[byteArrayIndex++] = (byte)((localPort & 0xFF00) >> 8);
        byteArray[byteArrayIndex++] = (byte)(localPort & 0xFF);
        byteArray[byteArrayIndex++] = (byte)(proxyHostSize & 0xFF);
        if (proxyHostSize > 0) {
            if (proxyHostSize != 4 && proxyHostSize != 16) {
                throw new RuntimeException("invalid proxy host [" + proxyHost + ']');
            }
            byte[] proxyHostBytes = AddressUtils.convertIP(proxyHost);
            System.arraycopy(proxyHostBytes, 0, byteArray, byteArrayIndex, proxyHostSize);
            byteArrayIndex += proxyHostSize;
        }
        byteArray[byteArrayIndex++] = (byte)((proxyPort & 0xFF00) >> 8);
        byteArray[byteArrayIndex++] = (byte)(proxyPort & 0xFF);
        byteArray[byteArrayIndex++] = (byte)(macSize & 0xFF);
        if (macSize > 0) {
            if (s_logger.isTraceDebugEnabled()) {
                s_logger.traceDebug(this, "encodeFlowToken", "calculating MAC using [" + secret + ']');
            }
            byte[] macBytes = flowTokenSecurity.calculateMac(byteArray, 0, byteArrayIndex, mac, macSize);
            System.arraycopy(macBytes, 0, byteArray, byteArrayIndex, macSize);
            byteArrayIndex += macSize;
        }
        if (s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug(this, "encodeFlowToken", "encoding " + Arrays.toString(byteArray));
        }
        String flowToken = Base64Parser.encode(byteArray);
        return flowToken;
    }

    public Flow decodeFlowToken(String flowToken) {
        boolean tampered;
        String proxyHost;
        int proxyHostSize;
        int localHostSize;
        int remoteHostSize;
        String transport;
        int byteArrayIndex;
        int byteArrayLength;
        byte[] byteArray = Base64Parser.decode(flowToken);
        int n = byteArrayLength = byteArray == null ? 0 : byteArray.length;
        if (byteArrayLength == 0) {
            if (s_logger.isTraceDebugEnabled()) {
                s_logger.traceDebug(this, "decodeFlowToken", "not a flow token [" + flowToken + ']');
            }
            return null;
        }
        if (s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug(this, "decodeFlowToken", "decoding " + Arrays.toString(byteArray));
        }
        if ((byteArrayIndex = 0) + 3 > byteArrayLength) {
            if (s_logger.isTraceDebugEnabled()) {
                s_logger.traceDebug(this, "decodeFlowToken", "no flow token signatue in [" + flowToken + ']');
            }
            return null;
        }
        if (byteArray[byteArrayIndex++] != 105 || byteArray[byteArrayIndex++] != 98 || byteArray[byteArrayIndex++] != 109) {
            if (s_logger.isTraceDebugEnabled()) {
                s_logger.traceDebug(this, "decodeFlowToken", "not a locally-generated flow token [" + flowToken + ']');
            }
            return null;
        }
        if (byteArrayIndex >= byteArrayLength) {
            if (s_logger.isTraceFailureEnabled()) {
                s_logger.traceFailure(this, "decodeFlowToken", "expected transport but got end of flow token [" + flowToken + ']');
            }
            return null;
        }
        byte transportValue = byteArray[byteArrayIndex++];
        switch (transportValue) {
            case 0: {
                transport = "udp";
                break;
            }
            case 1: {
                transport = "tcp";
                break;
            }
            case 2: {
                transport = "tls";
                break;
            }
            default: {
                if (s_logger.isTraceFailureEnabled()) {
                    s_logger.traceFailure(this, "decodeFlowToken", "expected transport (0-2) but got [" + transportValue + "] in flow token [" + flowToken + ']');
                }
                return null;
            }
        }
        if (byteArrayIndex >= byteArrayLength) {
            if (s_logger.isTraceFailureEnabled()) {
                s_logger.traceFailure(this, "decodeFlowToken", "expected remote host size but got end of flow token [" + flowToken + ']');
            }
            return null;
        }
        if (byteArrayIndex + (remoteHostSize = byteArray[byteArrayIndex++] & 0xFF) > byteArrayLength) {
            if (s_logger.isTraceFailureEnabled()) {
                s_logger.traceFailure(this, "decodeFlowToken", "expected remote host but got end of flow token [" + flowToken + ']');
            }
            return null;
        }
        String remoteHost = AddressUtils.convertIP(byteArray, byteArrayIndex, remoteHostSize);
        if (remoteHost == null) {
            if (s_logger.isTraceFailureEnabled()) {
                s_logger.traceFailure(this, "decodeFlowToken", "bad remote host in [" + Arrays.toString(byteArray) + ']');
            }
            return null;
        }
        if ((byteArrayIndex += remoteHostSize) + 2 > byteArrayLength) {
            if (s_logger.isTraceFailureEnabled()) {
                s_logger.traceFailure(this, "decodeFlowToken", "expected remote port but got end of flow token [" + flowToken + ']');
            }
            return null;
        }
        int remotePort = (byteArray[byteArrayIndex++] & 0xFF) << 8 | byteArray[byteArrayIndex++] & 0xFF;
        if (byteArrayIndex >= byteArrayLength) {
            if (s_logger.isTraceFailureEnabled()) {
                s_logger.traceFailure(this, "decodeFlowToken", "expected local host size but got end of flow token [" + flowToken + ']');
            }
            return null;
        }
        if (byteArrayIndex + (localHostSize = byteArray[byteArrayIndex++] & 0xFF) > byteArrayLength) {
            if (s_logger.isTraceFailureEnabled()) {
                s_logger.traceFailure(this, "decodeFlowToken", "expected local host but got end of flow token [" + flowToken + ']');
            }
            return null;
        }
        String localHost = AddressUtils.convertIP(byteArray, byteArrayIndex, localHostSize);
        if (localHost == null) {
            if (s_logger.isTraceFailureEnabled()) {
                s_logger.traceFailure(this, "decodeFlowToken", "bad local host in [" + Arrays.toString(byteArray) + ']');
            }
            return null;
        }
        if ((byteArrayIndex += localHostSize) + 2 > byteArrayLength) {
            if (s_logger.isTraceFailureEnabled()) {
                s_logger.traceFailure(this, "decodeFlowToken", "expected local port but got end of flow token [" + flowToken + ']');
            }
            return null;
        }
        int localPort = (byteArray[byteArrayIndex++] & 0xFF) << 8 | byteArray[byteArrayIndex++] & 0xFF;
        if (byteArrayIndex >= byteArrayLength) {
            if (s_logger.isTraceFailureEnabled()) {
                s_logger.traceFailure(this, "decodeFlowToken", "expected proxy host size but got end of flow token [" + flowToken + ']');
            }
            return null;
        }
        if (byteArrayIndex + (proxyHostSize = byteArray[byteArrayIndex++] & 0xFF) > byteArrayLength) {
            if (s_logger.isTraceFailureEnabled()) {
                s_logger.traceFailure(this, "decodeFlowToken", "expected proxy host but got end of flow token [" + flowToken + ']');
            }
            return null;
        }
        if (proxyHostSize == 0) {
            proxyHost = null;
        } else {
            proxyHost = AddressUtils.convertIP(byteArray, byteArrayIndex, proxyHostSize);
            if (proxyHost == null) {
                if (s_logger.isTraceFailureEnabled()) {
                    s_logger.traceFailure(this, "decodeFlowToken", "bad proxy host in [" + Arrays.toString(byteArray) + ']');
                }
                return null;
            }
        }
        if ((byteArrayIndex += proxyHostSize) + 2 > byteArrayLength) {
            if (s_logger.isTraceFailureEnabled()) {
                s_logger.traceFailure(this, "decodeFlowToken", "expected proxy port but got end of flow token [" + flowToken + ']');
            }
            return null;
        }
        int proxyPort = (byteArray[byteArrayIndex++] & 0xFF) << 8 | byteArray[byteArrayIndex++] & 0xFF;
        int expectedMacSize = byteArrayIndex < byteArrayLength ? byteArray[byteArrayIndex++] & 0xFF : 0;
        FlowTokenSecurity flowTokenSecurity = FlowTokenSecurity.instance();
        ArrayList<FlowTokenSecurity.Secret> secrets = flowTokenSecurity.getSecretSet();
        if (expectedMacSize > 0) {
            if (secrets == null) {
                if (s_logger.isTraceFailureEnabled()) {
                    s_logger.traceFailure(this, "decodeFlowToken", "encoded MAC but no local MAC");
                }
                tampered = true;
            } else {
                int bytesLeft = byteArrayLength - byteArrayIndex;
                if (bytesLeft < expectedMacSize) {
                    if (s_logger.isTraceFailureEnabled()) {
                        s_logger.traceFailure(this, "decodeFlowToken", "expected MAC of [" + expectedMacSize + "] but only [" + bytesLeft + "] bytes left");
                    }
                    tampered = true;
                } else {
                    tampered = !flowTokenSecurity.authenticateMac(secrets, byteArray, 0, byteArrayIndex, expectedMacSize);
                    byteArrayIndex += expectedMacSize;
                }
            }
        } else if (secrets == null) {
            tampered = false;
        } else {
            if (s_logger.isTraceFailureEnabled()) {
                s_logger.traceFailure(this, "decodeFlowToken", "no encoded MAC");
            }
            tampered = true;
        }
        if (tampered) {
            if (s_logger.isTraceFailureEnabled()) {
                s_logger.traceFailure(this, "decodeFlowToken", "MAC rejected");
            }
        } else if (s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug(this, "decodeFlowToken", "MAC validation passed");
        }
        Flow flow = new Flow(transport, remoteHost, remotePort, localHost, localPort, proxyHost, proxyPort, tampered);
        return flow;
    }

    public void forwardingRequest(SipServletRequestImpl inRequest, SipServletRequestImpl outRequest, SipURI recordRoute) {
        Address route;
        if (s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug(this, "forwardingRequest", inRequest.getMethod());
        }
        Address[] routes = this.getTopRoute(inRequest);
        int iRoute = 0;
        boolean incoming = false;
        SipURI routeURI = null;
        Flow flow = null;
        while (iRoute < routes.length && (route = routes[iRoute++]) != null) {
            javax.servlet.sip.URI uri = route.getURI();
            if (!(uri instanceof SipURI)) continue;
            routeURI = (SipURI)uri;
            boolean topRouteIsSelf = this.isSelfRoute(routeURI, inRequest);
            if (!topRouteIsSelf) {
                routeURI = null;
                continue;
            }
            String flowToken = routeURI.getUser();
            if (flowToken == null || (flow = this.decodeFlowToken(flowToken)) == null) continue;
            String flowTokenRemoteHost = flow.getRemoteHost();
            int flowTokenRemotePort = flow.getRemotePort();
            int remotePort = inRequest.getRemotePort();
            String remoteHost = inRequest.getRemoteAddr();
            incoming = flowTokenRemotePort != remotePort || !SIPStackUtil.isSameHost(flowTokenRemoteHost, remoteHost);
            break;
        }
        if (incoming) {
            this.processIncomingRequest(inRequest, outRequest, routeURI, recordRoute, flow);
        } else {
            this.processOutgoingRequest(inRequest, outRequest, routeURI, recordRoute);
        }
    }

    private void processIncomingRequest(SipServletRequestImpl inRequest, SipServletRequestImpl outRequest, SipURI topRoute, SipURI recordRoute, Flow flow) {
        int iface;
        String flowToken = topRoute.getUser();
        this.removeRoute(outRequest, flowToken);
        if (outRequest.getHeader("IBM-Destination") != null) {
            if (s_logger.isTraceFailureEnabled()) {
                s_logger.traceFailure(this, "processIncomingRequest", "not copying flow token because there already is an IBM-Destination in the forwarded request");
            }
            return;
        }
        if (s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug(this, "processIncomingRequest", "copying flow [" + flow + "] token [" + flowToken + "] to forwarded request");
        }
        String transport = flow.getTransport();
        String remoteHost = flow.getRemoteHost();
        int remotePort = flow.getRemotePort();
        SipURI destinationURI = (SipURI)topRoute.clone();
        destinationURI.setUser("");
        destinationURI.setTransportParam(transport);
        destinationURI.setHost(remoteHost);
        destinationURI.setPort(remotePort);
        if (!transport.equalsIgnoreCase("udp")) {
            destinationURI.setParameter("ibm-ob", "");
            destinationURI.setParameter("ob", "");
        }
        if (!this.m_standalone) {
            String proxyHost = flow.getProxyHost();
            int proxyPort = flow.getProxyPort();
            if (proxyHost != null) {
                destinationURI.setParameter("ibm-proxyhost", proxyHost);
                destinationURI.setParameter("ibm-proxyport", String.valueOf(proxyPort));
            }
        }
        if (flow.isTampered()) {
            destinationURI.setParameter("ibm-tampered", "");
        }
        SipServletsFactoryImpl sipFactory = SipServletsFactoryImpl.getInstance();
        Address destination = sipFactory.createAddress(destinationURI);
        outRequest.addAddressHeader("IBM-Destination", destination, true);
        String localHost = flow.getLocalHost();
        int localPort = flow.getLocalPort();
        SipProxyInfo sipProxyInfo = SipProxyInfo.getInstance();
        int nInterfaces = sipProxyInfo.getNumberOfInterfaces(transport);
        int n = iface = nInterfaces == 1 ? 0 : sipProxyInfo.getIndexOfIface(transport, localHost, localPort);
        if (iface >= 0) {
            if (s_logger.isTraceDebugEnabled()) {
                s_logger.traceDebug(this, "processIncomingRequest", outRequest.getHeader("IBM-PO") == null ? "setting [" : "replacing [" + iface + "] in IBM-PO header");
            }
            sipProxyInfo.addPreferedOutboundHeader(outRequest, iface);
        } else if (s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug(this, "processIncomingRequest", "no matching listening point");
        }
        if (recordRoute != null && topRoute.getParameter("ob") != null) {
            if (s_logger.isTraceDebugEnabled()) {
                s_logger.traceDebug(this, "processIncomingRequest", "setting [" + flowToken + "] in Record-Route [" + recordRoute + ']');
            }
            recordRoute.setUser(flowToken);
        }
    }

    private void processOutgoingRequest(SipServletRequestImpl inRequest, SipServletRequestImpl outRequest, SipURI topRoute, SipURI recordRoute) {
        boolean ob;
        if (s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug(this, "processOutgoingRequest", inRequest.getMethod());
        }
        if (recordRoute == null) {
            return;
        }
        if (!this.isDirect(inRequest.getRequest())) {
            return;
        }
        boolean bl = ob = topRoute != null && topRoute.getParameter("ob") != null;
        if (!ob) {
            block8: {
                try {
                    javax.servlet.sip.URI uri;
                    Address contact = inRequest.getAddressHeader("Contact");
                    if (contact != null && (uri = contact.getURI()) instanceof SipURI) {
                        SipURI sipURI = (SipURI)uri;
                        ob = sipURI.getParameter("ob") != null;
                    }
                }
                catch (ServletParseException e2) {
                    if (!s_logger.isTraceFailureEnabled()) break block8;
                    s_logger.traceFailure(this, "processOutgoingRequest", "", (Throwable)((Object)e2));
                }
            }
            if (!ob) {
                return;
            }
        }
        String flowToken = this.createFlowToken(inRequest);
        recordRoute.setUser(flowToken);
    }

    private boolean isDirect(Request request) {
        int expectedVias = this.m_standalone ? 1 : 2;
        int requestVias = 0;
        HeaderIterator vias = request.getViaHeaders();
        if (vias != null) {
            while (vias.hasNext()) {
                ++requestVias;
                try {
                    vias.next();
                }
                catch (HeaderParseException e2) {
                    if (s_logger.isTraceFailureEnabled()) {
                        s_logger.traceFailure(this, "isDirect", "", e2);
                    }
                    return false;
                }
            }
        }
        return requestVias <= expectedVias;
    }

    private Address[] getTopRoute(SipServletRequestImpl inRequest) {
        Address route1;
        Address route0 = inRequest.getPoppedRoute();
        if (route0 == null) {
            try {
                route0 = inRequest.getAddressHeader("Route");
            }
            catch (ServletParseException e2) {
                if (s_logger.isTraceFailureEnabled()) {
                    s_logger.traceFailure(this, "getTopRoute", "", (Throwable)((Object)e2));
                }
                route0 = null;
            }
            if (route0 == null) {
                route1 = null;
            } else {
                try {
                    ListIterator<Address> routeI = inRequest.getAddressHeaders("Route");
                    route1 = routeI.hasNext() && routeI.next() != null && routeI.hasNext() ? routeI.next() : null;
                }
                catch (ServletParseException e3) {
                    if (s_logger.isTraceFailureEnabled()) {
                        s_logger.traceFailure(this, "getTopRoute", "", (Throwable)((Object)e3));
                    }
                    route1 = null;
                }
            }
        } else {
            try {
                route1 = inRequest.getAddressHeader("Route");
            }
            catch (ServletParseException e4) {
                if (s_logger.isTraceFailureEnabled()) {
                    s_logger.traceFailure(this, "getTopRoute", "", (Throwable)((Object)e4));
                }
                route1 = null;
            }
        }
        Address[] routes = s_topRoutes.get();
        routes[0] = route0;
        routes[1] = route1;
        return routes;
    }

    private boolean isSelfRoute(SipURI route, SipServletRequestImpl inRequest) {
        boolean self;
        String routeTransport;
        String selfHost = this.getSelfHost(inRequest);
        int selfPort = this.getSelfPort(inRequest);
        String routeHost = route.getHost();
        int routePort = route.getPort();
        if (route.isSecure()) {
            routeTransport = "tls";
        } else {
            routeTransport = route.getTransportParam();
            if (routeTransport == null) {
                routeTransport = "udp";
            }
        }
        if (routePort == -1) {
            int n = routePort = routeTransport.equalsIgnoreCase("tls") ? 5061 : 5060;
        }
        if (s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug(this, "isSelfRoute", "selfHost [" + selfHost + "] selfPort [" + selfPort + "] route [" + route + ']');
        }
        boolean bl = self = routePort == selfPort && routeHost.equalsIgnoreCase(selfHost);
        if (!self) {
            SipProxyInfo sipProxyInfo = SipProxyInfo.getInstance();
            int index = sipProxyInfo.getIndexOfIface(routeTransport, routeHost, routePort);
            boolean bl2 = self = index >= 0;
        }
        if (s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug(this, "isSelfRoute", "self [" + self + ']');
        }
        return self;
    }

    private String getSelfHost(SipServletRequestImpl inRequest) {
        SipProvider provider = inRequest.getSipProvider();
        ListeningPoint listeningPoint = provider.getListeningPoint();
        return listeningPoint.getSentBy();
    }

    private int getSelfPort(SipServletRequestImpl inRequest) {
        SipProvider provider = inRequest.getSipProvider();
        ListeningPoint listeningPoint = provider.getListeningPoint();
        return listeningPoint.getPort();
    }

    private boolean removeRoute(SipServletRequestImpl outRequest, String flowToken) {
        block6: {
            Message message = outRequest.getMessage();
            try {
                NameAddressHeader route0 = (NameAddressHeader)message.getHeader("Route", true);
                if (route0 == null) {
                    return false;
                }
                message.removeHeader("Route", true);
                if (OutboundProcessor.hasFlowToken(route0, flowToken)) {
                    return true;
                }
                NameAddressHeader route1 = (NameAddressHeader)message.getHeader("Route", true);
                if (route1 == null) {
                    message.addHeader(route0, true);
                    return false;
                }
                if (OutboundProcessor.hasFlowToken(route1, flowToken)) {
                    message.removeHeader("Route", true);
                    message.addHeader(route0, true);
                    return true;
                }
            }
            catch (HeaderParseException e2) {
                if (!s_logger.isTraceFailureEnabled()) break block6;
                s_logger.traceFailure(this, "removeRoute", "", e2);
            }
        }
        return false;
    }

    private static boolean hasFlowToken(NameAddressHeader header, String flowToken) {
        NameAddress nameAddress = header.getNameAddress();
        URI uri = nameAddress.getAddress();
        if (!(uri instanceof SipURL)) {
            return false;
        }
        SipURL sipURI = (SipURL)uri;
        String user = sipURI.getUserName();
        return user != null && user.equals(flowToken);
    }
}

