/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.protocol;

public class Flow {
    private final String m_transport;
    private final String m_remoteHost;
    private final int m_remotePort;
    private final String m_localHost;
    private final int m_localPort;
    private final String m_proxyHost;
    private final int m_proxyPort;
    private final boolean m_tampered;

    public Flow(String transport, String remoteHost, int remotePort, String localHost, int localPort, String proxyHost, int proxyPort, boolean tampered) {
        this.m_transport = transport;
        this.m_remoteHost = remoteHost;
        this.m_remotePort = remotePort;
        this.m_localHost = localHost;
        this.m_localPort = localPort;
        this.m_proxyHost = proxyHost;
        this.m_proxyPort = proxyPort;
        this.m_tampered = tampered;
    }

    public String getTransport() {
        return this.m_transport;
    }

    public String getRemoteHost() {
        return this.m_remoteHost;
    }

    public int getRemotePort() {
        return this.m_remotePort;
    }

    public String getLocalHost() {
        return this.m_localHost;
    }

    public int getLocalPort() {
        return this.m_localPort;
    }

    public String getProxyHost() {
        return this.m_proxyHost;
    }

    public int getProxyPort() {
        return this.m_proxyPort;
    }

    public boolean isTampered() {
        return this.m_tampered;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof Flow)) {
            return false;
        }
        Flow otherFlow = (Flow)other;
        if (otherFlow.m_remotePort != this.m_remotePort) {
            return false;
        }
        if (otherFlow.m_localPort != this.m_localPort) {
            return false;
        }
        if (otherFlow.m_proxyPort != this.m_proxyPort) {
            return false;
        }
        if (otherFlow.m_localHost == null ? this.m_localHost != null : !otherFlow.m_localHost.equals(this.m_localHost)) {
            return false;
        }
        if (otherFlow.m_remoteHost == null ? this.m_remoteHost != null : !otherFlow.m_remoteHost.equals(this.m_remoteHost)) {
            return false;
        }
        return !(otherFlow.m_proxyHost == null ? this.m_proxyHost != null : !otherFlow.m_proxyHost.equals(this.m_proxyHost));
    }

    public int hashCode() {
        return this.m_transport.hashCode() * this.m_localPort * this.m_remotePort * this.m_proxyPort * (this.m_localHost == null ? 1 : this.m_localHost.hashCode()) * (this.m_remoteHost == null ? 1 : this.m_remoteHost.hashCode()) * (this.m_proxyHost == null ? 1 : this.m_proxyHost.hashCode());
    }

    public String toString() {
        StringBuilder s = new StringBuilder(256);
        s.append(this.m_transport).append('/');
        s.append(this.m_localHost).append(':').append(this.m_localPort).append('-');
        s.append(this.m_remoteHost).append(':').append(this.m_remotePort).append('-');
        s.append(this.m_proxyHost).append(':').append(this.m_proxyPort);
        s.append('-').append(this.m_tampered ? "X" : "V");
        return s.toString();
    }
}

