/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.load;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.load.ConcurentLoadListener;
import com.ibm.ws.sip.container.load.LoadCounterAbs;

public class ApplicationSessionCounter
extends LoadCounterAbs {
    private static final LogMgr c_logger = Log.get(ApplicationSessionCounter.class);
    private int _counter = 0;
    private ConcurentLoadListener _lstr = null;

    public ApplicationSessionCounter(int maximumAllowed, int waterMarkSize, int initialWeight, ConcurentLoadListener lstr) {
        super(maximumAllowed, waterMarkSize, initialWeight, 0);
        this._lstr = lstr;
    }

    @Override
    public void increment() {
        ++this._counter;
        this.updateNewWeight();
    }

    @Override
    public void decrement() {
        --this._counter;
        this.updateNewWeight();
    }

    private void updateNewWeight() {
        long counter = this._counter;
        if (this.calculateNewWeight(counter)) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "updateNewWeight", "Try to set new weight = " + this.getWeight());
            }
            this._lstr.setNewWeight(this, counter);
        }
    }

    @Override
    public long getCurrentLoad() {
        return this._counter;
    }

    @Override
    void reset() {
    }

    @Override
    public void setCounter(long counter) {
    }

    @Override
    public String getCurrentState() {
        StringBuffer buff = new StringBuffer();
        buff.append(this._myInfo);
        buff.append(" Counter = ");
        buff.append(this._counter);
        return buff.toString();
    }
}

