/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jain.protocol.ip.sip.address;

import com.ibm.ws.sip.parser.util.CharsBuffer;
import com.ibm.ws.sip.parser.util.CharsBuffersPool;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TelephoneNumber {
    public static final String POSTDIAL = "postd";
    public static final String PHONE_CONTEXT_TAG = "phone-context";
    public static final String ISUB = "isub";
    public static final String PROVIDER_TAG = "tsp";
    boolean m_isGlobal;
    String m_phoneNumber;
    Map m_params = new HashMap(16);

    public void setParameter(String name, String value) {
        this.m_params.put(name, value);
    }

    public void removeParameter(String name) {
        this.m_params.remove(name);
    }

    public boolean hasParameter(String pname) {
        return this.m_params.containsKey(pname);
    }

    public String getPhoneNumber() {
        return this.m_phoneNumber;
    }

    public String getPostDial() {
        return (String)this.m_params.get(POSTDIAL);
    }

    public String getIsdnSubaddress() {
        return (String)this.m_params.get(ISUB);
    }

    public boolean hasPostDial() {
        return this.hasParameter(POSTDIAL);
    }

    public boolean hasIsdnSubaddress() {
        return this.hasParameter(ISUB);
    }

    public boolean isGlobal() {
        return this.m_isGlobal;
    }

    public void removePostDial() {
        this.removeParameter(POSTDIAL);
    }

    public void removeIsdnSubaddress() {
        this.removeParameter(ISUB);
    }

    public void setGlobal(boolean g) {
        this.m_isGlobal = g;
    }

    public void setPostDial(String p) {
        this.setParameter(POSTDIAL, p);
    }

    public void setIsdnSubaddress(String isub) {
        this.setParameter(ISUB, isub);
    }

    public void setPhoneNumber(String num) {
        this.m_phoneNumber = num;
    }

    public String toString() {
        CharsBuffer buffer = CharsBuffersPool.getBuffer();
        this.writeToCharBuffer(buffer);
        String value = buffer.toString();
        CharsBuffersPool.putBufferBack(buffer);
        return value;
    }

    public void writeToCharBuffer(CharsBuffer ret) {
        if (this.m_isGlobal) {
            ret.append("+");
        }
        ret.append(this.m_phoneNumber);
        if (!this.m_params.isEmpty()) {
            ret.append(';');
            this.encodeParams(ret, this.m_params);
        }
    }

    private void encodeParams(CharsBuffer buffer, Map map) {
        Iterator i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            buffer.append(entry.getKey());
            buffer.append('=');
            buffer.append(entry.getValue());
            if (!i.hasNext()) continue;
            buffer.append(';');
        }
    }
}

