/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jain.protocol.ip.sip.address;

import com.ibm.ws.jain.protocol.ip.sip.address.URIImpl;
import com.ibm.ws.sip.parser.Lexer;
import com.ibm.ws.sip.parser.util.CharsBuffer;
import com.ibm.ws.sip.parser.util.CharsBuffersPool;
import com.ibm.ws.sip.stack.transaction.SIPTransactionStack;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.address.NameAddress;
import jain.protocol.ip.sip.address.URI;

public class NameAddressImpl
implements NameAddress {
    private static final long serialVersionUID = 4441607612063633851L;
    private static final boolean s_forceDisplayNameQuoting = SIPTransactionStack.instance().getConfiguration().forceDisplayNameQuoting();
    private static final boolean s_allowDisplayNameQuotingByApp = SIPTransactionStack.instance().getConfiguration().allowDisplayNameQuotingByApp();
    private static final boolean s_forceNameAddr = SIPTransactionStack.instance().getConfiguration().forceNameAddr();
    URI m_address;
    String m_displayName;

    public NameAddressImpl() {
    }

    NameAddressImpl(URI address) {
        this.m_address = address;
    }

    NameAddressImpl(String displayName, URI address) {
        this.m_displayName = displayName;
        this.m_address = address;
    }

    @Override
    public String getDisplayName() {
        return this.m_displayName;
    }

    @Override
    public boolean hasDisplayName() {
        return this.m_displayName != null;
    }

    @Override
    public void removeDisplayName() {
        this.m_displayName = null;
    }

    @Override
    public void setDisplayName(String displayName) throws IllegalArgumentException, SipParseException {
        this.m_displayName = displayName;
    }

    @Override
    public URI getAddress() {
        return this.m_address;
    }

    @Override
    public void setAddress(URI addr) throws IllegalArgumentException {
        if (addr == null) {
            throw new IllegalArgumentException("NameAddress: null address");
        }
        if (!(addr instanceof URIImpl)) {
            throw new IllegalArgumentException("NameAddress: Address from another impl " + addr.getClass().getName());
        }
        this.m_address = addr;
    }

    @Override
    public String toString() {
        CharsBuffer buffer = CharsBuffersPool.getBuffer();
        this.writeToCharBuffer(buffer, true);
        String value = buffer.toString();
        CharsBuffersPool.putBufferBack(buffer);
        return value;
    }

    public void writeToCharBuffer(CharsBuffer buf, boolean addrSpecFormatAllowed) {
        String displayName = this.m_displayName;
        if (displayName != null && displayName.length() > 0) {
            NameAddressImpl.writeDisplayName(displayName, buf);
            buf.append(' ');
            addrSpecFormatAllowed = false;
        } else if (s_forceNameAddr) {
            addrSpecFormatAllowed = false;
        }
        URIImpl uri = (URIImpl)this.m_address;
        if (uri == null) {
            return;
        }
        if (!addrSpecFormatAllowed) {
            buf.append('<');
        }
        int uriStart = buf.getCharCount();
        uri.writeToCharBuffer(buf);
        if (addrSpecFormatAllowed) {
            int i;
            int uriEnd = buf.getCharCount();
            int uriLength = uriEnd - uriStart;
            char[] chars = buf.getCharArray();
            for (i = 0; i < uriLength; ++i) {
                char c = chars[uriStart + i];
                if (c != ',' && c != ';' && c != '?') continue;
                addrSpecFormatAllowed = false;
                break;
            }
            if (!addrSpecFormatAllowed) {
                buf.append('x');
                chars = buf.getCharArray();
                for (i = uriLength; i > 0; --i) {
                    chars[uriStart + i] = chars[uriStart + i - 1];
                }
                buf.rewind(uriStart);
                buf.append('<');
                buf.rewind(uriEnd + 1);
            }
        }
        if (!addrSpecFormatAllowed) {
            buf.append('>');
        }
    }

    private static void writeDisplayName(String displayName, CharsBuffer buffer) {
        if (s_allowDisplayNameQuotingByApp && displayName.charAt(0) == '\"') {
            buffer.append(displayName);
            return;
        }
        if (s_forceDisplayNameQuoting) {
            buffer.append('\"');
            Lexer.writeNoQuotes(displayName, buffer);
            buffer.append('\"');
            return;
        }
        int length = displayName.length();
        int start = buffer.getCharCount();
        boolean quotes = false;
        block3: for (int i = 0; i < length; ++i) {
            char c = displayName.charAt(i);
            if ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9') {
                buffer.append(c);
                continue;
            }
            switch (c) {
                case '\t': 
                case ' ': 
                case '!': 
                case '%': 
                case '\'': 
                case '*': 
                case '+': 
                case '-': 
                case '.': 
                case '_': 
                case '`': 
                case '~': {
                    buffer.append(c);
                    continue block3;
                }
                default: {
                    quotes = true;
                    break block3;
                }
            }
        }
        if (quotes) {
            buffer.rewind(start);
            buffer.append('\"');
            Lexer.writeNoQuotes(displayName, buffer);
            buffer.append('\"');
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof NameAddressImpl)) {
            return false;
        }
        NameAddressImpl other = (NameAddressImpl)obj;
        return this.m_address.equals(other.m_address);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public Object clone() {
        try {
            NameAddressImpl ret = (NameAddressImpl)super.clone();
            if (this.m_address != null) {
                ret.m_address = (URI)this.m_address.clone();
            }
            return ret;
        }
        catch (CloneNotSupportedException e2) {
            e2.printStackTrace();
            throw new Error("Clone Error.");
        }
    }
}

