/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.webcontainer;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxws.metadata.JaxWsModuleInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.wsspi.adaptable.module.NonPersistentCache;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import java.util.ArrayList;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JaxWsRouterServletContainerInitializer
implements ServletContainerInitializer {
    private static final TraceComponent tc = Tr.register(JaxWsRouterServletContainerInitializer.class, (String)"JaxWsWebContainer", (String)"com.ibm.ws.jaxws.webcontainer.internal.resources.JaxWsWebContainerMessages");
    static final long serialVersionUID = 51318866291635516L;

    public void onStartup(Set<Class<?>> classes, ServletContext sc) throws ServletException {
        if (sc instanceof WebApp) {
            WebApp wapp = (WebApp)WebApp.class.cast(sc);
            String moduleName = wapp.getModuleMetaData().getName();
            if (moduleName.indexOf("-Router") == -1) {
                return;
            }
            try {
                NonPersistentCache overlayCache = (NonPersistentCache)wapp.getModuleContainer().adapt(NonPersistentCache.class);
                JaxWsModuleInfo jaxwsModuleInfo = (JaxWsModuleInfo)overlayCache.getFromCache(JaxWsModuleInfo.class);
                if (jaxwsModuleInfo == null) {
                    return;
                }
            }
            catch (UnableToAdaptException overlayCache) {
                FFDCFilter.processException((Throwable)overlayCache, (String)"com.ibm.ws.jaxws.webcontainer.JaxWsRouterServletContainerInitializer", (String)"52", (Object)this, (Object[])new Object[]{classes, sc});
                return;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Jaxws EJB Router module '" + moduleName + "' is detected"), (Object[])new Object[]{moduleName});
            }
            ArrayList sca = wapp.getServletContextListeners();
            int index = -1;
            for (int i = 0; i < sca.size(); ++i) {
                ServletContextListener scl = (ServletContextListener)sca.get(i);
                if (!scl.getClass().getName().equals("org.apache.myfaces.webapp.StartupServletContextListener")) continue;
                index = i;
                break;
            }
            if (index != -1) {
                ServletContextListener scl = (ServletContextListener)sca.remove(index);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("org.apache.myfaces.webapp.StartupServletContextListener is removed from Jaxws EJB Router module '" + moduleName + "'"), (Object[])new Object[]{moduleName, scl});
                }
            }
        }
    }
}

