/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.clients.common;

import com.google.gson.JsonObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.common.encoder.Base64Coder;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.genericbnf.PasswordNullifier;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.crypto.HashUtils;
import com.ibm.ws.security.common.http.HttpUtils;
import com.ibm.ws.security.common.web.WebUtils;
import com.ibm.ws.security.openidconnect.clients.common.ConvergedClientConfig;
import com.ibm.ws.security.openidconnect.token.IDToken;
import com.ibm.ws.webcontainer.security.ReferrerURLCookieHandler;
import com.ibm.ws.webcontainer.security.WebAppSecurityCollaboratorImpl;
import com.ibm.ws.webcontainer.security.WebAppSecurityConfig;
import io.openliberty.security.oidcclientcore.http.OidcClientHttpUtil;
import io.openliberty.security.oidcclientcore.storage.CookieBasedStorage;
import io.openliberty.security.oidcclientcore.storage.CookieStorageProperties;
import io.openliberty.security.oidcclientcore.storage.StorageProperties;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.HttpException;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OidcClientUtil {
    private static final long serialVersionUID = 1L;
    private static final TraceComponent tc = Tr.register(OidcClientUtil.class, (String)"OPENIDCONNECT", (String)"com.ibm.ws.security.openidconnect.clients.common.resources.OidcClientMessages");
    OidcClientHttpUtil oidcHttpUtil = null;
    public HttpUtils httpUtils;
    static AtomicReference<ReferrerURLCookieHandler> referrerURLCookieHandlerRef = new AtomicReference();
    static AtomicReference<WebAppSecurityConfig> webAppSecurityConfigRef = new AtomicReference();

    public OidcClientUtil() {
        this.init(OidcClientHttpUtil.getInstance());
        this.httpUtils = new HttpUtils();
    }

    void init(OidcClientHttpUtil oidcHttpUtil) {
        this.oidcHttpUtil = oidcHttpUtil;
    }

    public void handleCustomParams(@Sensitive List<NameValuePair> params, HashMap<String, String> customParams) {
        if (customParams != null && !customParams.isEmpty()) {
            Set<Map.Entry<String, String>> entries = customParams.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                if (entry.getKey() == null || entry.getValue() == null) continue;
                params.add((NameValuePair)new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
        }
    }

    public Map<String, Object> checkToken(String tokenInfor, String clientId, @Sensitive String clientSecret, String accessToken, boolean isHostnameVerification, String authMethod, SSLSocketFactory sslSocketFactory, boolean useSystemPropertiesForHttpClientConnections) throws Exception {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("token", accessToken));
        if (authMethod.equals("post")) {
            params.add((NameValuePair)new BasicNameValuePair("client_id", clientId));
            params.add((NameValuePair)new BasicNameValuePair("client_secret", clientSecret));
        }
        Map<String, Object> postResponseMap = this.postToCheckTokenEndpoint(tokenInfor, params, clientId, clientSecret, isHostnameVerification, authMethod, sslSocketFactory, useSystemPropertiesForHttpClientConnections);
        return postResponseMap;
    }

    public Map<String, Object> getUserinfo(String userInfor, String accessToken, SSLSocketFactory sslSocketFactory, boolean isHostnameVerification, boolean useSystemPropertiesForHttpClientConnections) throws Exception {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        Map<String, Object> getResponseMap = this.getFromUserinfoEndpoint(userInfor, params, accessToken, sslSocketFactory, isHostnameVerification, useSystemPropertiesForHttpClientConnections);
        return getResponseMap;
    }

    Map<String, Object> postToCheckTokenEndpoint(String tokenEnpoint, @Sensitive List<NameValuePair> params, String baUsername, @Sensitive String baPassword, boolean isHostnameVerification, String authMethod, SSLSocketFactory sslSocketFactory, boolean useSystemPropertiesForHttpClientConnections) throws Exception {
        return this.oidcHttpUtil.postToIntrospectEndpoint(tokenEnpoint, params, baUsername, baPassword, null, sslSocketFactory, isHostnameVerification, authMethod, useSystemPropertiesForHttpClientConnections);
    }

    Map<String, Object> getFromUserinfoEndpoint(String userInforEndpoint, List<NameValuePair> params, String accessToken, SSLSocketFactory sslSocketFactory, boolean isHostnameVerification, boolean useSystemPropertiesForHttpClientConnections) throws HttpException, IOException {
        return this.oidcHttpUtil.getFromEndpoint(userInforEndpoint, params, null, null, accessToken, sslSocketFactory, isHostnameVerification, useSystemPropertiesForHttpClientConnections);
    }

    public String getRedirectUrl(HttpServletRequest req, String uri) {
        String hostName = req.getServerName();
        Integer httpsPort = new WebUtils().getRedirectPortFromRequest(req);
        String entryPoint = uri;
        if (httpsPort == null && req.isSecure()) {
            int port = req.getServerPort();
            String httpSchema = req.getScheme();
            return httpSchema + "://" + hostName + (port > 0 && port != 443 ? ":" + port : "") + entryPoint;
        }
        return "https://" + hostName + (httpsPort == null ? "" : ":" + httpsPort) + entryPoint;
    }

    public IDToken createIDToken(String tokenString, @Sensitive Object key, String clientId, String issuer, String signingAlgorithm, String accessToken) {
        return new IDToken(tokenString, key, clientId, issuer, signingAlgorithm, accessToken);
    }

    public static void invalidateReferrerURLCookie(HttpServletRequest req, HttpServletResponse res, String cookieName) {
        CookieBasedStorage store = new CookieBasedStorage(req, res, OidcClientUtil.getReferrerURLCookieHandler());
        store.remove(cookieName);
    }

    public static void invalidateReferrerURLCookies(HttpServletRequest req, HttpServletResponse res, String[] cookieNames) {
        if (cookieNames == null || req == null || res == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"invalidateReferrerURLCookies param is null, return", (Object[])new Object[0]);
            }
            return;
        }
        CookieBasedStorage store = new CookieBasedStorage(req, res, OidcClientUtil.getReferrerURLCookieHandler());
        for (String name : cookieNames) {
            store.remove(name);
        }
    }

    static WebAppSecurityConfig getWebAppSecurityConfig() {
        if (webAppSecurityConfigRef.get() == null) {
            webAppSecurityConfigRef.set(WebAppSecurityCollaboratorImpl.getGlobalWebAppSecurityConfig());
        }
        return webAppSecurityConfigRef.get();
    }

    public static ReferrerURLCookieHandler getReferrerURLCookieHandler() {
        ReferrerURLCookieHandler handler = referrerURLCookieHandlerRef.get();
        if (handler == null) {
            handler = OidcClientUtil.getWebAppSecurityConfig().createReferrerURLCookieHandler();
            referrerURLCookieHandlerRef.set(handler);
        }
        return handler;
    }

    public static void setReferrerURLCookieHandler(ReferrerURLCookieHandler referrerURLCookieHandler) {
        if (OidcClientUtil.getReferrerURLCookieHandler() != referrerURLCookieHandler) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Old and new CookieHandler", (Object[])new Object[]{OidcClientUtil.getReferrerURLCookieHandler(), referrerURLCookieHandler});
            }
            webAppSecurityConfigRef.set(WebAppSecurityCollaboratorImpl.getGlobalWebAppSecurityConfig());
            referrerURLCookieHandlerRef.set(referrerURLCookieHandler);
        }
    }

    @FFDCIgnore(value={Exception.class})
    public static void verifyReferrerHostIsValid(HttpServletRequest req, @Sensitive String requestUrl, String cookieNameOrPrefix) throws Exception {
        try {
            ReferrerURLCookieHandler.isReferrerHostValid((String)PasswordNullifier.nullifyParams((String)req.getRequestURL().toString()), (String)PasswordNullifier.nullifyParams((String)requestUrl), (List)OidcClientUtil.getWebAppSecurityConfig().getWASReqURLRedirectDomainNames());
        }
        catch (Exception re) {
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"MALFORMED_URL_IN_ORIGIN_REQUEST_URL_COOKIE", (Object[])new Object[]{req.getRequestURL(), cookieNameOrPrefix, new URL(requestUrl).getHost()});
            throw new Exception(errorMsg, re);
        }
    }

    public static void setWebAppSecurityConfig(WebAppSecurityConfig webAppSecurityConfig) {
        webAppSecurityConfigRef.set(webAppSecurityConfig);
    }

    public static void setCookieForRequestParameter(HttpServletRequest request, HttpServletResponse response, String id, String state, boolean isHttpsRequest, ConvergedClientConfig clientCfg) {
        Map map = request.getParameterMap();
        JsonObject jsonObject = new JsonObject();
        Set entries = map.entrySet();
        for (Map.Entry entry : entries) {
            String[] strs;
            String key = (String)entry.getKey();
            if ("access_token".equals(key) || "id_token".equals(key) || (strs = (String[])entry.getValue()) == null || strs.length <= 0) continue;
            jsonObject.addProperty(key, strs[0]);
        }
        String requestParameters = jsonObject.toString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("requestParameters:" + requestParameters), (Object[])new Object[0]);
        }
        String encodedReqParams = Base64Coder.toString((byte[])Base64Coder.base64Encode((byte[])requestParameters.getBytes(StandardCharsets.UTF_8)));
        String encodedHash = null;
        if (encodedReqParams != null) {
            encodedHash = OidcClientUtil.addSignatureToStringValue(encodedReqParams, clientCfg);
        }
        CookieBasedStorage store = new CookieBasedStorage(request, response, OidcClientUtil.getReferrerURLCookieHandler());
        CookieStorageProperties cookieProps = new CookieStorageProperties();
        if (clientCfg.isHttpsRequired() && isHttpsRequest) {
            cookieProps.setSecure(true);
        }
        store.store("WASOidcCode", encodedHash, (StorageProperties)cookieProps);
    }

    public static String addSignatureToStringValue(String encoded, ConvergedClientConfig clientCfg) {
        String retVal = new String(encoded);
        String uniqueSecretValue = clientCfg.getClientSecret();
        if (uniqueSecretValue == null) {
            uniqueSecretValue = clientCfg.toString();
        }
        String signatureValue = new String(encoded) + "_" + uniqueSecretValue;
        retVal = retVal + "_" + HashUtils.digest((String)signatureValue);
        return retVal;
    }
}

