/*
 * Decompiled with CFR 0.152.
 */
package graphql.introspection;

import graphql.ErrorClassification;
import graphql.ExecutionResult;
import graphql.GraphQLContext;
import graphql.GraphQLError;
import graphql.PublicApi;
import graphql.com.google.common.collect.ImmutableCollection;
import graphql.com.google.common.collect.ImmutableListMultimap;
import graphql.execution.ExecutionContext;
import graphql.language.SourceLocation;
import graphql.normalized.ExecutableNormalizedField;
import graphql.normalized.ExecutableNormalizedOperation;
import graphql.normalized.ExecutableNormalizedOperationFactory;
import graphql.schema.FieldCoordinates;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;

@PublicApi
public class GoodFaithIntrospection {
    public static final String GOOD_FAITH_INTROSPECTION_DISABLED = "GOOD_FAITH_INTROSPECTION_DISABLED";
    private static final AtomicBoolean ENABLED_STATE = new AtomicBoolean(true);
    public static final int GOOD_FAITH_MAX_FIELDS_COUNT = 500;
    public static final int GOOD_FAITH_MAX_DEPTH_COUNT = 20;
    private static final Map<FieldCoordinates, Integer> ALLOWED_FIELD_INSTANCES = new HashMap<FieldCoordinates, Integer>();

    public static boolean isEnabledJvmWide() {
        return ENABLED_STATE.get();
    }

    public static boolean enabledJvmWide(boolean flag) {
        return ENABLED_STATE.getAndSet(flag);
    }

    public static Optional<ExecutionResult> checkIntrospection(ExecutionContext executionContext) {
        if (GoodFaithIntrospection.isIntrospectionEnabled(executionContext.getGraphQLContext())) {
            ExecutableNormalizedOperation operation = GoodFaithIntrospection.mkOperation(executionContext);
            ImmutableListMultimap<FieldCoordinates, ExecutableNormalizedField> coordinatesToENFs = operation.getCoordinatesToNormalizedFields();
            for (Map.Entry<FieldCoordinates, Integer> entry : ALLOWED_FIELD_INSTANCES.entrySet()) {
                FieldCoordinates coordinates = entry.getKey();
                Integer allowSize = entry.getValue();
                ImmutableCollection normalizedFields = coordinatesToENFs.get((Object)coordinates);
                if (normalizedFields.size() <= allowSize) continue;
                BadFaithIntrospectionError error = new BadFaithIntrospectionError(coordinates.toString());
                return Optional.of(ExecutionResult.newExecutionResult().addError(error).build());
            }
        }
        return Optional.empty();
    }

    private static ExecutableNormalizedOperation mkOperation(ExecutionContext executionContext) {
        ExecutableNormalizedOperationFactory.Options options = ExecutableNormalizedOperationFactory.Options.defaultOptions().maxFieldsCount(500).maxChildrenDepth(20).locale(executionContext.getLocale()).graphQLContext(executionContext.getGraphQLContext());
        return ExecutableNormalizedOperationFactory.createExecutableNormalizedOperation(executionContext.getGraphQLSchema(), executionContext.getOperationDefinition(), executionContext.getFragmentsByName(), executionContext.getCoercedVariables(), options);
    }

    private static boolean isIntrospectionEnabled(GraphQLContext graphQlContext) {
        if (!GoodFaithIntrospection.isEnabledJvmWide()) {
            return false;
        }
        return graphQlContext.getOrDefault(GOOD_FAITH_INTROSPECTION_DISABLED, false) == false;
    }

    static {
        ALLOWED_FIELD_INSTANCES.put(FieldCoordinates.coordinates("Query", "__schema"), 1);
        ALLOWED_FIELD_INSTANCES.put(FieldCoordinates.coordinates("Query", "__type"), 1);
        ALLOWED_FIELD_INSTANCES.put(FieldCoordinates.coordinates("__Type", "fields"), 1);
        ALLOWED_FIELD_INSTANCES.put(FieldCoordinates.coordinates("__Type", "inputFields"), 1);
        ALLOWED_FIELD_INSTANCES.put(FieldCoordinates.coordinates("__Type", "interfaces"), 1);
        ALLOWED_FIELD_INSTANCES.put(FieldCoordinates.coordinates("__Type", "possibleTypes"), 1);
    }

    public static class BadFaithIntrospectionError
    implements GraphQLError {
        private final String message;

        public BadFaithIntrospectionError(String qualifiedField) {
            this.message = String.format("This request is not asking for introspection in good faith - %s is present too often!", qualifiedField);
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public ErrorClassification getErrorType() {
            return ErrorClassification.errorClassification("BadFaithIntrospection");
        }

        @Override
        public List<SourceLocation> getLocations() {
            return null;
        }
    }
}

