/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.abstractrecords;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
import com.arjuna.ats.arjuna.coordinator.OnePhaseResource;
import com.arjuna.ats.arjuna.logging.tsLogger;
import java.io.PrintWriter;

public class LastResourceRecord
extends AbstractRecord {
    private OnePhaseResource _lro;
    private static final Uid ONE_PHASE_RESOURCE_UID = Uid.lastResourceUid();
    private static final boolean ALLOW_MULTIPLE_LAST_RESOURCES = arjPropertyManager.getCoreEnvironmentBean().isAllowMultipleLastResources();
    private static final boolean _disableMLRWarning = arjPropertyManager.getCoreEnvironmentBean().isDisableMultipleLastResourcesWarning();
    private static boolean _issuedWarning = false;

    public LastResourceRecord(OnePhaseResource opr) {
        super(ONE_PHASE_RESOURCE_UID);
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)"LastResourceRecord()");
        }
        this._lro = opr;
    }

    public boolean propagateOnCommit() {
        return false;
    }

    public int typeIs() {
        return Integer.MAX_VALUE;
    }

    public int nestedAbort() {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("LastResourceRecord::nestedAbort() for " + this.order()));
        }
        return 7;
    }

    public int nestedCommit() {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("LastResourceRecord::nestedCommit() for " + this.order()));
        }
        return 8;
    }

    public int nestedPrepare() {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("LastResourceRecord::nestedPrepare() for " + this.order()));
        }
        return 1;
    }

    public int topLevelAbort() {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("LastResourceRecord::topLevelAbort() for " + this.order()));
        }
        if (this._lro != null) {
            return this._lro.rollback();
        }
        return 7;
    }

    public int topLevelCommit() {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("LastResourceRecord::topLevelCommit() for " + this.order()));
        }
        return 7;
    }

    public int topLevelPrepare() {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("LastResourceRecord::topLevelPrepare() for " + this.order()));
        }
        if (this._lro == null) {
            return 1;
        }
        switch (this._lro.commit()) {
            case 7: {
                return 0;
            }
            case 10: {
                return 10;
            }
        }
        return 1;
    }

    public int topLevelOnePhaseCommit() {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("LastResourceRecord::topLevelOnePhase() for " + this.order()));
        }
        if (this._lro == null) {
            return 1;
        }
        switch (this._lro.commit()) {
            case 7: {
                return 7;
            }
            case 10: {
                return 10;
            }
        }
        return 5;
    }

    public String toString() {
        return "LastResourceRecord(" + this._lro + ")";
    }

    public void print(PrintWriter strm) {
        strm.println("LastResource for:");
        super.print(strm);
    }

    public String type() {
        return "/StateManager/AbstractRecord/LastResourceRecord";
    }

    public boolean shouldAdd(AbstractRecord a) {
        if (a.typeIs() == this.typeIs()) {
            if (ALLOW_MULTIPLE_LAST_RESOURCES) {
                if (!_disableMLRWarning || _disableMLRWarning && !_issuedWarning) {
                    tsLogger.i18NLogger.warn_lastResource_multipleWarning(a.toString());
                    _issuedWarning = true;
                }
                return true;
            }
            tsLogger.i18NLogger.warn_lastResource_disallow(this.toString(), a.toString());
            return false;
        }
        return false;
    }

    public boolean shouldMerge(AbstractRecord a) {
        return false;
    }

    public boolean shouldReplace(AbstractRecord a) {
        return false;
    }

    public boolean shouldAlter(AbstractRecord a) {
        return false;
    }

    public void merge(AbstractRecord a) {
    }

    public void alter(AbstractRecord a) {
    }

    public Object value() {
        return this._lro;
    }

    public void setValue(Object o) {
    }

    public LastResourceRecord() {
        this._lro = null;
    }

    static {
        if (ALLOW_MULTIPLE_LAST_RESOURCES) {
            tsLogger.i18NLogger.warn_lastResource_startupWarning();
        }
        if (_disableMLRWarning) {
            tsLogger.i18NLogger.warn_lastResource_disableWarning();
        }
    }
}

