/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache;

import net.sf.ehcache.Element;
import net.sf.ehcache.ElementEvictionData;

public class DefaultElementEvictionData
implements ElementEvictionData {
    private long creationTime;
    private long lastAccessTime;

    public DefaultElementEvictionData(long creationTime) {
        this.creationTime = creationTime;
    }

    public DefaultElementEvictionData(long creationTime, long lastAccessTime) {
        this.creationTime = creationTime;
        this.lastAccessTime = lastAccessTime;
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void updateLastAccessTime(long time, Element element) {
        this.lastAccessTime = time;
    }

    public void resetLastAccessTime(Element element) {
        this.lastAccessTime = System.currentTimeMillis();
    }

    public final ElementEvictionData clone() throws CloneNotSupportedException {
        DefaultElementEvictionData result = (DefaultElementEvictionData)super.clone();
        result.creationTime = this.creationTime;
        result.lastAccessTime = this.lastAccessTime;
        return result;
    }

    public boolean canParticipateInSerialization() {
        return true;
    }
}

