/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.openidconnect.backchannellogout;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.WSSubject;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.web.OAuth20Request;
import com.ibm.ws.webcontainer.security.UnprotectedResourceService;
import com.ibm.ws.webcontainer.security.openidconnect.OidcServerConfig;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceSet;
import com.ibm.wsspi.kernel.service.utils.ServiceAndServiceReferencePair;
import io.openliberty.security.common.jwt.JwtParsingUtils;
import io.openliberty.security.openidconnect.backchannellogout.BackchannelLogoutRequestHelper;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={UnprotectedResourceService.class})
public class BackchannelLogoutService
implements UnprotectedResourceService {
    private static TraceComponent tc = Tr.register(BackchannelLogoutService.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.server.internal.resources.OidcServerMessages");
    private static final ConcurrentServiceReferenceSet<OidcServerConfig> oidcServerConfigRef = new ConcurrentServiceReferenceSet("oidcServerConfigService");
    private static final Pattern ACCESS_ID_PATTERN = Pattern.compile("^[^:]+:.*/([^/]+)$");
    static final long serialVersionUID = 9013146958230700390L;

    @Reference(name="oidcServerConfigService", service=OidcServerConfig.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE)
    protected void setOidcClientConfigService(ServiceReference<OidcServerConfig> reference) {
        oidcServerConfigRef.addReference(reference);
    }

    protected void unsetOidcClientConfigService(ServiceReference<OidcServerConfig> reference) {
        oidcServerConfigRef.removeReference(reference);
    }

    public void activate(ComponentContext cc) {
        oidcServerConfigRef.activate(cc);
    }

    public void deactivate(ComponentContext cc) {
        oidcServerConfigRef.deactivate(cc);
    }

    public boolean isAuthenticationRequired(HttpServletRequest request) {
        return false;
    }

    public boolean postLogout(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    public boolean logout(HttpServletRequest request, HttpServletResponse response, String userName) {
        if (!this.hasBackchannelLogoutConfigured()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No client has a back-channel logout uri set up, so back-channel logout will not be performed.", (Object[])new Object[0]);
            }
            return true;
        }
        if (userName != null && !userName.isEmpty()) {
            userName = this.normalizeUserName(userName);
        }
        String idTokenString = request.getParameter("id_token_hint");
        String requestUri = request.getRequestURI();
        OidcServerConfig oidcServerConfig = this.getMatchingConfig(requestUri, idTokenString);
        if (oidcServerConfig == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Failed to find a matching OIDC provider for the request sent to [" + requestUri + "]"), (Object[])new Object[0]);
            }
            return false;
        }
        this.sendBackchannelLogoutRequests(request, oidcServerConfig, userName, idTokenString);
        return true;
    }

    boolean hasBackchannelLogoutConfigured() {
        Iterator servicesWithRefs = oidcServerConfigRef.getServicesWithReferences();
        while (servicesWithRefs.hasNext()) {
            ServiceAndServiceReferencePair configServiceAndRef = (ServiceAndServiceReferencePair)servicesWithRefs.next();
            OidcServerConfig config = (OidcServerConfig)configServiceAndRef.getService();
            if (!BackchannelLogoutRequestHelper.hasClientWithBackchannelLogoutUri(config)) continue;
            return true;
        }
        return false;
    }

    String normalizeUserName(String userName) {
        Matcher userNameMatcher = ACCESS_ID_PATTERN.matcher(userName);
        if (userNameMatcher.matches()) {
            userName = userNameMatcher.group(1);
        }
        return userName;
    }

    OidcServerConfig getMatchingConfig(String requestUri, String idTokenHintString) {
        OidcServerConfig config = this.getMatchingConfigFromRequestUri(requestUri);
        if (config == null) {
            config = this.getMatchingConfigFromIdTokenHint(idTokenHintString);
        }
        return config;
    }

    OidcServerConfig getMatchingConfigFromRequestUri(String requestUri) {
        Iterator servicesWithRefs = oidcServerConfigRef.getServicesWithReferences();
        while (servicesWithRefs.hasNext()) {
            ServiceAndServiceReferencePair configServiceAndRef = (ServiceAndServiceReferencePair)servicesWithRefs.next();
            OidcServerConfig config = (OidcServerConfig)configServiceAndRef.getService();
            String configId = config.getProviderId();
            if (!this.isEndpointThatMatchesConfig(requestUri, configId) && !this.isDelegatedLogoutRequestForConfig(requestUri, configId)) continue;
            return config;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    OidcServerConfig getMatchingConfigFromIdTokenHint(String idTokenHintString) {
        String issuerFromIdTokenHint = null;
        try {
            issuerFromIdTokenHint = this.getIssuerFromIdTokenHint(idTokenHintString);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.security.openidconnect.backchannellogout.BackchannelLogoutService", (String)"154", (Object)this, (Object[])new Object[]{idTokenHintString});
            Tr.error((TraceComponent)tc, (String)Tr.formatMessage((TraceComponent)tc, (String)"LOGOUT_TOKEN_ERROR_GETTING_CLAIMS_FROM_ID_TOKEN", (Object[])new Object[]{e}), (Object[])new Object[0]);
            return null;
        }
        if (issuerFromIdTokenHint == null || issuerFromIdTokenHint.isEmpty()) {
            return null;
        }
        Iterator servicesWithRefs = oidcServerConfigRef.getServicesWithReferences();
        while (servicesWithRefs.hasNext()) {
            ServiceAndServiceReferencePair configServiceAndRef = (ServiceAndServiceReferencePair)servicesWithRefs.next();
            OidcServerConfig config = (OidcServerConfig)configServiceAndRef.getService();
            String configId = config.getProviderId();
            if (!this.isIdTokenHintIssuedByConfig(configId, config, issuerFromIdTokenHint)) continue;
            return config;
        }
        return null;
    }

    String getIssuerFromIdTokenHint(String idTokenHint) throws InvalidJwtException, MalformedClaimException {
        if (idTokenHint == null || idTokenHint.isEmpty()) {
            return null;
        }
        JwtContext jwtContext = JwtParsingUtils.parseJwtWithoutValidation((String)idTokenHint);
        JwtClaims claims = jwtContext.getJwtClaims();
        return claims.getIssuer();
    }

    boolean isEndpointThatMatchesConfig(String requestUri, String providerId) {
        return requestUri.endsWith("/" + providerId + "/" + OAuth20Request.EndpointType.end_session.name()) || requestUri.endsWith("/" + providerId + "/" + OAuth20Request.EndpointType.logout.name()) || requestUri.endsWith("/" + providerId + "/ibm_security_logout");
    }

    boolean isDelegatedLogoutRequestForConfig(String requestUri, String providerId) {
        String getOpFromSubject = this.getPropertyFromRunAsSubjectPrivateCredentials("io.openliberty.security.sso.oidc.op");
        if (!providerId.equals(getOpFromSubject)) {
            return false;
        }
        String samlIdpFromSubject = this.getPropertyFromRunAsSubjectPrivateCredentials("io.openliberty.security.sso.saml.idp");
        return samlIdpFromSubject != null && requestUri.endsWith("/" + samlIdpFromSubject + "/slo");
    }

    boolean isIdTokenHintIssuedByConfig(String providerId, OidcServerConfig config, String issuerFromIdTokenHint) {
        String issuerIdentifier = config.getIssuerIdentifier();
        if (issuerIdentifier != null && !issuerIdentifier.isEmpty() && issuerIdentifier.equals(issuerFromIdTokenHint)) {
            return true;
        }
        return issuerFromIdTokenHint.endsWith("/" + providerId);
    }

    String getPropertyFromRunAsSubjectPrivateCredentials(String key) {
        Set<Hashtable> hashtableCreds;
        Subject runAsSubject = this.getRunAsSubject();
        if (runAsSubject != null && (hashtableCreds = runAsSubject.getPrivateCredentials(Hashtable.class)) != null) {
            for (Hashtable hashtable : hashtableCreds) {
                String propertyValue = (String)hashtable.get(key);
                if (propertyValue == null) continue;
                return propertyValue;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    Subject getRunAsSubject() {
        try {
            return WSSubject.getRunAsSubject();
        }
        catch (WSSecurityException wSSecurityException) {
            FFDCFilter.processException((Throwable)wSSecurityException, (String)"io.openliberty.security.openidconnect.backchannellogout.BackchannelLogoutService", (String)"228", (Object)this, (Object[])new Object[0]);
            if (tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)"Exception while getting runAsSubject:", (Object[])new Object[]{e.getCause()});
            }
            return null;
        }
    }

    void sendBackchannelLogoutRequests(HttpServletRequest request, OidcServerConfig oidcServerConfig, String userName, String idTokenString) {
        BackchannelLogoutRequestHelper bclRequestCreator = new BackchannelLogoutRequestHelper(request, oidcServerConfig);
        bclRequestCreator.sendBackchannelLogoutRequests(userName, idTokenString);
    }
}

