/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.cxf.validator;

import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.SerializableProtectedString;
import java.util.Collection;
import java.util.Map;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.wss4j.WSS4JUtils;
import org.apache.wss4j.common.cache.ReplayCache;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.policy.SP12Constants;
import org.apache.wss4j.policy.model.UsernameToken;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class Utils {
    private static final TraceComponent tc = Tr.register(Utils.class, (String)"WSSecurity", (String)"com.ibm.ws.wssecurity.resources.WSSecurityMessages");
    static final long serialVersionUID = 3855154204939726376L;

    public static ReplayCache getReplayCache(@Sensitive SoapMessage message, String booleanKey, String instanceKey) throws WSSecurityException {
        return WSS4JUtils.getReplayCache((SoapMessage)message, (String)booleanKey, (String)instanceKey);
    }

    public static Object getSecurityPropertyValue(String property, SoapMessage message) {
        Object value = message.getContextualProperty(property);
        if (value != null) {
            return value;
        }
        return message.getContextualProperty("ws-" + property);
    }

    public static boolean checkPolicyNoPassword(@Sensitive SoapMessage message) throws WSSecurityException {
        boolean bRet = false;
        AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
        Collection ais = aim.getAssertionInfo(SP12Constants.USERNAME_TOKEN);
        UsernameToken tok = null;
        for (AssertionInfo ai : ais) {
            tok = (UsernameToken)ai.getAssertion();
            if (!UsernameToken.PasswordType.NoPassword.equals((Object)tok.getPasswordType())) continue;
            bRet = true;
        }
        return bRet;
    }

    @Sensitive
    public static String changePasswordType(SerializableProtectedString protectedString) {
        char[] password_array;
        String clearString = null;
        if (protectedString != null && (password_array = protectedString.getChars()).length > 0) {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < password_array.length; ++i) {
                buf.append(password_array[i]);
            }
            clearString = PasswordUtil.passwordDecode((String)buf.toString());
        }
        return clearString;
    }

    @Sensitive
    public static void modifyConfigMap(Map<String, Object> configMap) {
        String pwd;
        if (configMap.containsKey("ws-security.password")) {
            pwd = Utils.changePasswordType((SerializableProtectedString)configMap.get("ws-security.password"));
            configMap.put("ws-security.password", pwd);
        }
        if (configMap.containsKey("org.apache.ws.security.crypto.merlin.keystore.private.password")) {
            pwd = Utils.changePasswordType((SerializableProtectedString)configMap.get("org.apache.ws.security.crypto.merlin.keystore.private.password"));
            configMap.put("org.apache.ws.security.crypto.merlin.keystore.private.password", pwd);
        }
        if (configMap.containsKey("org.apache.wss4j.crypto.merlin.keystore.private.password")) {
            pwd = PasswordUtil.passwordDecode((String)((String)configMap.get("org.apache.wss4j.crypto.merlin.keystore.private.password")));
            configMap.put("org.apache.wss4j.crypto.merlin.keystore.private.password", pwd);
        }
        if (configMap.containsKey("org.apache.ws.security.crypto.merlin.keystore.password")) {
            pwd = Utils.changePasswordType((SerializableProtectedString)configMap.get("org.apache.ws.security.crypto.merlin.keystore.password"));
            configMap.put("org.apache.ws.security.crypto.merlin.keystore.password", pwd);
        }
        if (configMap.containsKey("org.apache.wss4j.crypto.merlin.keystore.password")) {
            pwd = PasswordUtil.passwordDecode((String)((String)configMap.get("org.apache.wss4j.crypto.merlin.keystore.password")));
            configMap.put("org.apache.wss4j.crypto.merlin.keystore.password", pwd);
        }
        if (configMap.containsKey("org.apache.ws.security.crypto.merlin.truststore.password")) {
            pwd = Utils.changePasswordType((SerializableProtectedString)configMap.get("org.apache.ws.security.crypto.merlin.truststore.password"));
            configMap.put("org.apache.ws.security.crypto.merlin.truststore.password", pwd);
        }
        if (configMap.containsKey("org.apache.wss4j.crypto.merlin.truststore.password")) {
            pwd = PasswordUtil.passwordDecode((String)((String)configMap.get("org.apache.wss4j.crypto.merlin.truststore.password")));
            configMap.put("org.apache.wss4j.crypto.merlin.truststore.password", pwd);
        }
    }
}

