/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.el.unified;

import jakarta.el.ArrayELResolver;
import jakarta.el.BeanELResolver;
import jakarta.el.CompositeELResolver;
import jakarta.el.ELResolver;
import jakarta.el.ExpressionFactory;
import jakarta.el.ListELResolver;
import jakarta.el.MapELResolver;
import jakarta.el.ResourceBundleELResolver;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.myfaces.cdi.util.CDIUtils;
import org.apache.myfaces.config.RuntimeConfig;
import org.apache.myfaces.el.FlashELResolver;
import org.apache.myfaces.el.unified.ELResolverBuilder;
import org.apache.myfaces.el.unified.ResolverBuilderBase;
import org.apache.myfaces.el.unified.resolver.CompositeComponentELResolver;
import org.apache.myfaces.el.unified.resolver.FacesCompositeELResolver;
import org.apache.myfaces.el.unified.resolver.ImportConstantsELResolver;
import org.apache.myfaces.el.unified.resolver.ImportHandlerResolver;
import org.apache.myfaces.el.unified.resolver.ManagedBeanResolver;
import org.apache.myfaces.el.unified.resolver.ResourceBundleResolver;
import org.apache.myfaces.el.unified.resolver.ResourceResolver;
import org.apache.myfaces.el.unified.resolver.ScopedAttributeResolver;
import org.apache.myfaces.el.unified.resolver.implicitobject.ImplicitObjectResolver;
import org.apache.myfaces.shared.config.MyfacesConfig;
import org.apache.myfaces.shared.util.ClassUtils;

public class ResolverBuilderForFaces
extends ResolverBuilderBase
implements ELResolverBuilder {
    private static final Class STATIC_FIELD_EL_RESOLVER_CLASS;
    private static final Method GET_STREAM_EL_RESOLVER_METHOD;

    public ResolverBuilderForFaces(RuntimeConfig config) {
        super(config);
    }

    @Override
    public void build(CompositeELResolver compositeElResolver) {
        this.build(FacesContext.getCurrentInstance(), compositeElResolver);
    }

    @Override
    public void build(FacesContext facesContext, CompositeELResolver compositeElResolver) {
        MyfacesConfig config = MyfacesConfig.getCurrentInstance((ExternalContext)FacesContext.getCurrentInstance().getExternalContext());
        ArrayList<ELResolver> list = new ArrayList<ELResolver>();
        if (this.isReplaceImplicitObjectResolverWithCDIResolver(facesContext)) {
            list.add(ImplicitObjectResolver.makeResolverForFacesCDI());
            BeanManager beanManager = CDIUtils.getBeanManager(FacesContext.getCurrentInstance().getExternalContext());
            list.add(beanManager.getELResolver());
        } else {
            list.add(ImplicitObjectResolver.makeResolverForFaces());
        }
        list.add(new CompositeComponentELResolver());
        this.addFromRuntimeConfig(list);
        list.add(new FlashELResolver());
        if (config.isSupportManagedBeans()) {
            list.add(new ManagedBeanResolver());
        }
        list.add(new ResourceResolver());
        list.add((ELResolver)new ResourceBundleELResolver());
        list.add(new ResourceBundleResolver());
        list.add(new ImportConstantsELResolver());
        if (STATIC_FIELD_EL_RESOLVER_CLASS != null && GET_STREAM_EL_RESOLVER_METHOD != null) {
            try {
                ELResolver streamElResolver = (ELResolver)GET_STREAM_EL_RESOLVER_METHOD.invoke((Object)this.getRuntimeConfig().getExpressionFactory(), new Object[0]);
                if (streamElResolver != null) {
                    list.add(streamElResolver);
                }
                list.add((ELResolver)STATIC_FIELD_EL_RESOLVER_CLASS.newInstance());
            }
            catch (IllegalAccessException streamElResolver) {
            }
            catch (IllegalArgumentException streamElResolver) {
            }
            catch (InvocationTargetException streamElResolver) {
            }
            catch (InstantiationException streamElResolver) {
                // empty catch block
            }
        }
        list.add((ELResolver)new MapELResolver());
        list.add((ELResolver)new ListELResolver());
        list.add((ELResolver)new ArrayELResolver());
        list.add((ELResolver)new BeanELResolver());
        this.sortELResolvers(list, FacesCompositeELResolver.Scope.Faces);
        Iterable<ELResolver> filteredELResolvers = this.filterELResolvers(list, FacesCompositeELResolver.Scope.Faces);
        for (ELResolver resolver : filteredELResolvers) {
            compositeElResolver.add(resolver);
        }
        if (config.isSupportEL3ImportHandler()) {
            compositeElResolver.add((ELResolver)new ImportHandlerResolver());
        }
        compositeElResolver.add((ELResolver)new ScopedAttributeResolver());
    }

    static {
        Class staticFieldELResolverClass = null;
        Method getStreamELResolverMethod = null;
        try {
            staticFieldELResolverClass = ClassUtils.classForName("jakarta.el.StaticFieldELResolver");
            getStreamELResolverMethod = ExpressionFactory.class.getMethod("getStreamELResolver", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        STATIC_FIELD_EL_RESOLVER_CLASS = staticFieldELResolverClass;
        GET_STREAM_EL_RESOLVER_METHOD = getStreamELResolverMethod;
    }
}

