/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.objectManager;

import com.ibm.ws.objectManager.AbstractMapView;
import com.ibm.ws.objectManager.AbstractSetView;
import com.ibm.ws.objectManager.Iterator;
import com.ibm.ws.objectManager.ObjectManager;
import com.ibm.ws.objectManager.ObjectManagerException;
import com.ibm.ws.objectManager.Set;
import com.ibm.ws.objectManager.Transaction;
import com.ibm.ws.objectManager.utils.Printable;
import com.ibm.ws.objectManager.utils.Trace;
import com.ibm.ws.objectManager.utils.Tracing;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;

public class BTree
extends AbstractMapView
implements Printable {
    private static final Class cclass = BTree.class;
    private static Trace trace = ObjectManager.traceFactory.getTrace(BTree.class, "ObjectManagerMaps");
    Node root;
    private int minimumNodeSize;
    private Comparator comparator = null;
    private transient Set entrySet = null;

    public BTree(int minimumNodeSize) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", new Object[]{new Integer(minimumNodeSize)});
        }
        if (minimumNodeSize < 2) {
            throw new IllegalArgumentException("Illegal minimum Node Size (less than 2): " + minimumNodeSize);
        }
        this.minimumNodeSize = minimumNodeSize;
        this.root = this.makeNode(null);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "<init>");
        }
    }

    public int getMinimumNodeSize() {
        return this.minimumNodeSize;
    }

    @Override
    public synchronized long size() throws ObjectManagerException {
        String methodName = "size";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "size");
        }
        long size = this.root.size();
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "size", new Object[]{new Long(size)});
        }
        return size;
    }

    public synchronized Object put(Object key, Object value) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "put", new Object[]{key});
        }
        Entry newEntry = this.makeEntry(key, value);
        Entry existingEntry = this.putEntry(newEntry);
        Object returnValue = null;
        if (existingEntry != null) {
            returnValue = existingEntry.getValue();
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "put", new Object[]{returnValue});
        }
        return returnValue;
    }

    public synchronized Entry putEntry(Entry newEntry) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "putEntry", new Object[]{newEntry});
        }
        if (this.root.numberOfKeys == this.minimumNodeSize * 2 - 1) {
            Node newRoot = this.makeNode(null);
            newRoot.isLeaf = false;
            this.root.parent = newRoot;
            ++newRoot.numberOfKeys;
            newRoot.first = this.root.split();
            newRoot.first.next = this.makeEntry(null, null);
            newRoot.first.next.setChild(this.root);
            this.root = newRoot;
        }
        Entry returnEntry = this.root.insert(newEntry);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "putEntry", new Object[]{returnEntry});
        }
        return returnEntry;
    }

    public synchronized Object get(Object key) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "get", new Object[]{key});
        }
        Object returnValue = null;
        Entry entry = this.root.get(key);
        if (entry != null) {
            returnValue = entry.getValue();
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "get", new Object[]{returnValue});
        }
        return returnValue;
    }

    public synchronized Entry getEntry(Object key) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "get", new Object[]{key});
        }
        Entry entry = this.root.get(key);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "get", new Object[]{entry});
        }
        return entry;
    }

    public synchronized Object remove(Object key) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "remove", new Object[]{key});
        }
        Object returnValue = null;
        Entry entry = this.root.get(key);
        if (entry != null) {
            entry = this.root.delete(key);
            returnValue = entry.getValue();
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "remove", new Object[]{returnValue});
        }
        return returnValue;
    }

    public synchronized Entry removeEntry(Object key) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "removeEntry", new Object[]{key});
        }
        Entry returnEntry = null;
        Entry entry = this.root.get(key);
        if (entry != null) {
            returnEntry = this.root.delete(key);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "removeEntry", new Object[]{returnEntry});
        }
        return returnEntry;
    }

    public void clear() throws ObjectManagerException {
        this.root.clear();
    }

    @Override
    public Iterator iterator() throws ObjectManagerException {
        return this.values().iterator();
    }

    void setRoot(Node newRoot) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "setRoot", new Object[]{newRoot});
        }
        this.root = newRoot;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "setRoot");
        }
    }

    Entry makeEntry(Object key, Object value) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "makeEntry", new Object[]{key, value});
        }
        Entry returnEntry = new Entry(key, value);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "makeEntry", new Object[]{returnEntry});
        }
        return returnEntry;
    }

    Node makeNode(Node parent) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "makeNode", new Object[]{parent});
        }
        Node returnNode = new Node(parent);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "makeNode", new Object[]{returnNode});
        }
        return returnNode;
    }

    private int compare(Object key1, Object key2) {
        return this.comparator == null ? ((Comparable)key1).compareTo(key2) : this.comparator.compare(key1, key2);
    }

    @Override
    public synchronized void print(PrintWriter printWriter) {
        printWriter.println("Dump of BTree minimumNodeSize=" + this.minimumNodeSize + "(int)");
        try {
            Node.EntryIterator iterator = this.root.entryIterator();
            while (iterator.hasNext()) {
                Entry entry = iterator.nextEntry();
                int[] index = iterator.getIndex();
                String indexLabel = "";
                for (int i = 0; i < index.length - 1; ++i) {
                    indexLabel = indexLabel + index[i] + ",";
                }
                indexLabel = indexLabel + index[index.length - 1];
                printWriter.println((indexLabel + "                    ").substring(0, 20) + " Key=" + entry.getKey() + " Value=" + entry.getValue());
            }
        }
        catch (ObjectManagerException objectManagerException) {
            printWriter.println("Caught objectManagerException=" + objectManagerException);
            objectManagerException.printStackTrace(printWriter);
        }
    }

    public synchronized boolean validate(PrintStream printStream) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "validate", new Object[]{printStream});
        }
        boolean valid = true;
        int leafDepth = 0;
        Node.EntryIterator iterator = this.root.entryIterator();
        Entry previous = null;
        if (iterator.hasNext()) {
            previous = iterator.nextEntry();
        }
        while (iterator.hasNext()) {
            Entry entry = iterator.nextEntry();
            if (this.compare(entry.getKey(), previous.getKey()) < 0) {
                valid = false;
                printStream.println("key=" + previous.getKey() + " < following key=" + entry.getKey());
            }
            previous = entry;
            Node child = entry.getChild();
            if (child == null) {
                int[] index = iterator.getIndex();
                if (leafDepth == 0) {
                    leafDepth = index.length;
                }
                if (leafDepth == index.length) continue;
                valid = false;
                String indexLabel = "";
                for (int i = 0; i < index.length - 1; ++i) {
                    indexLabel = indexLabel + index[i] + ",";
                }
                indexLabel = indexLabel + index[index.length - 1];
                printStream.println((indexLabel + "                    ").substring(0, 20) + " Key=" + entry.getKey() + " Value=" + entry.getValue() + " Leaf not at depth=" + leafDepth);
                continue;
            }
            if (!child.isLeaf) continue;
            Entry e = child.first;
            while (e != null) {
                if (e.getChild() != null) {
                    valid = false;
                    printStream.println("Leaf Node " + child + " has a child=" + e.getChild() + " in entry=" + e);
                }
                e = e.next;
            }
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "validate", new Object[]{new Boolean(valid)});
        }
        return valid;
    }

    @Override
    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSetView(){

                @Override
                public Iterator iterator() throws ObjectManagerException {
                    return BTree.this.root.entryIterator();
                }

                @Override
                public long size(Transaction transaction) throws ObjectManagerException {
                    throw new UnsupportedOperationException();
                }

                @Override
                public long size() throws ObjectManagerException {
                    return BTree.this.size();
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public String toString() {
        return new String(cclass.getName() + "/" + Integer.toHexString(System.identityHashCode(this)));
    }

    class Node {
        private final Class cclass = Node.class;
        Node parent;
        int numberOfKeys = 0;
        Entry first = null;
        boolean isLeaf;

        Node(Node parent) {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, this.cclass, "<init>", new Object[]{parent});
            }
            this.parent = parent;
            this.isLeaf = true;
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, this.cclass, "<init>");
            }
        }

        public long size() throws ObjectManagerException {
            long size;
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry(this, this.cclass, "size");
            }
            Entry entry = this.first;
            if (this.isLeaf) {
                size = this.numberOfKeys;
            } else {
                size = -1L;
                while (entry != null) {
                    size += entry.getChild().size();
                    ++size;
                    entry = entry.next;
                }
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, this.cclass, "size", new Object[]{new Long(size)});
            }
            return size;
        }

        Entry get(Object key) throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, this.cclass, "get", new Object[]{key});
            }
            Entry returnEntry = null;
            Entry previous = null;
            Entry entry = this.first;
            while (entry != null) {
                if (entry.key == null) {
                    returnEntry = entry.getChild().get(key);
                    break;
                }
                int comparison = BTree.this.compare(key, entry.getKey());
                if (comparison == 0) {
                    returnEntry = entry;
                    break;
                }
                if (comparison < 0) {
                    if (this.isLeaf) break;
                    returnEntry = entry.getChild().get(key);
                    break;
                }
                previous = entry;
                entry = entry.next;
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, this.cclass, "get", new Object[]{returnEntry});
            }
            return returnEntry;
        }

        Entry split() throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry(this, this.cclass, "split");
            }
            Entry last = this.getEntry(BTree.this.minimumNodeSize - 2);
            Entry middle = last.next;
            Node left = BTree.this.makeNode(this.parent);
            left.first = this.first;
            left.numberOfKeys = BTree.this.minimumNodeSize - 1;
            if (this.isLeaf) {
                last.next = null;
            } else {
                left.isLeaf = false;
                last.next = BTree.this.makeEntry(null, null);
                last.next.setChild(middle.getChild());
            }
            this.numberOfKeys = BTree.this.minimumNodeSize - 1;
            this.first = middle.next;
            middle.setChild(left);
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, this.cclass, "split", new Object[]{middle});
            }
            return middle;
        }

        void insertFirst(Entry entry) {
            entry.next = this.first;
            this.first = entry;
            ++this.numberOfKeys;
        }

        void insertLast(Entry entry, Node rightNode) throws ObjectManagerException {
            Entry previous = this.first;
            for (int i = 0; i < this.numberOfKeys - 1; ++i) {
                previous = previous.next;
            }
            if (this.isLeaf) {
                entry.setChild(null);
                entry.next = null;
            } else {
                entry.next = previous.next;
                entry.setChild(previous.next.getChild());
                entry.next.setChild(rightNode);
            }
            previous.next = entry;
            ++this.numberOfKeys;
        }

        Entry insert(Entry newEntry) throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, this.cclass, "insert", new Object[]{newEntry});
            }
            Entry replacedEntry = null;
            Entry previous = null;
            Entry entry = this.first;
            int comparison = 1;
            if (this.isLeaf) {
                while (entry != null && (comparison = BTree.this.compare(newEntry.getKey(), entry.getKey())) > 0) {
                    previous = entry;
                    entry = entry.next;
                }
                if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                    trace.debug((Object)this, this.cclass, "insert", new Object[]{"isLeaf", new Integer(comparison)});
                }
                if (previous == null) {
                    if (comparison == 0) {
                        replacedEntry = this.first;
                        newEntry.next = this.first.next;
                        this.first = newEntry;
                    } else {
                        newEntry.next = this.first;
                        this.first = newEntry;
                        ++this.numberOfKeys;
                    }
                } else {
                    if (comparison == 0) {
                        replacedEntry = entry;
                        if (entry != null) {
                            newEntry.next = entry.next;
                        }
                    } else {
                        newEntry.next = entry;
                        ++this.numberOfKeys;
                    }
                    previous.next = newEntry;
                }
            } else {
                while (entry.key != null && (comparison = BTree.this.compare(newEntry.getKey(), entry.getKey())) > 0) {
                    previous = entry;
                    entry = entry.next;
                }
                if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                    trace.debug((Object)this, this.cclass, "delete", new Object[]{"!isLeaf", new Integer(comparison)});
                }
                if (previous == null) {
                    if (comparison == 0) {
                        replacedEntry = this.first;
                        newEntry.next = this.first.next;
                        newEntry.setChild(this.first.getChild());
                        this.first = newEntry;
                        replacedEntry.next = null;
                        replacedEntry.setChild(null);
                    } else {
                        Node node = entry.getChild();
                        if (node.numberOfKeys == BTree.this.minimumNodeSize * 2 - 1) {
                            Entry promoted = node.split();
                            promoted.next = entry;
                            this.first = promoted;
                            ++this.numberOfKeys;
                            comparison = BTree.this.compare(newEntry.getKey(), promoted.getKey());
                            if (comparison < 0) {
                                replacedEntry = this.first.getChild().insert(newEntry);
                            } else if (comparison == 0) {
                                replacedEntry = promoted;
                                newEntry.next = entry;
                                this.first = newEntry;
                                newEntry.setChild(promoted.getChild());
                                replacedEntry.next = null;
                                replacedEntry.setChild(null);
                            } else {
                                replacedEntry = promoted.next.getChild().insert(newEntry);
                            }
                        } else {
                            replacedEntry = node.insert(newEntry);
                        }
                    }
                } else if (comparison == 0) {
                    replacedEntry = entry;
                    if (entry != null) {
                        newEntry.next = entry.next;
                        newEntry.setChild(entry.getChild());
                    }
                    previous.next = newEntry;
                    replacedEntry.next = null;
                    replacedEntry.setChild(null);
                } else {
                    Node node = entry.getChild();
                    if (node.numberOfKeys == BTree.this.minimumNodeSize * 2 - 1) {
                        Entry promoted = node.split();
                        promoted.next = entry;
                        previous.next = promoted;
                        ++this.numberOfKeys;
                        comparison = BTree.this.compare(newEntry.getKey(), promoted.getKey());
                        if (comparison < 0) {
                            replacedEntry = promoted.getChild().insert(newEntry);
                        } else if (comparison == 0) {
                            replacedEntry = promoted;
                            newEntry.next = entry;
                            previous.next = newEntry;
                            newEntry.setChild(promoted.getChild());
                            replacedEntry.next = null;
                            replacedEntry.setChild(null);
                        } else {
                            replacedEntry = promoted.next.getChild().insert(newEntry);
                        }
                    } else {
                        replacedEntry = node.insert(newEntry);
                    }
                }
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, this.cclass, "insert", new Object[]{replacedEntry});
            }
            return replacedEntry;
        }

        Entry delete(Object key) throws ObjectManagerException {
            Entry returnEntry;
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, this.cclass, "delete", new Object[]{key, new Boolean(this.isLeaf)});
            }
            Entry previousPrevious = null;
            Entry previous = null;
            Entry entry = this.first;
            int comparison = 1;
            if (this.isLeaf) {
                while (entry != null && (comparison = BTree.this.compare(key, entry.getKey())) > 0) {
                    previous = entry;
                    entry = entry.next;
                }
                if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                    trace.debug((Object)this, this.cclass, "delete", new Object[]{"isLeaf", new Integer(comparison)});
                }
                if (comparison == 0) {
                    returnEntry = entry;
                    if (previous == null) {
                        this.first = entry.next;
                    } else {
                        previous.next = entry.next;
                    }
                    entry.next = null;
                    --this.numberOfKeys;
                } else {
                    returnEntry = null;
                }
            } else {
                while (entry.key != null && (comparison = BTree.this.compare(key, entry.getKey())) > 0) {
                    previousPrevious = previous;
                    previous = entry;
                    entry = entry.next;
                }
                if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                    trace.debug((Object)this, this.cclass, "delete", new Object[]{"!isLeaf", new Integer(comparison)});
                }
                if (comparison == 0) {
                    returnEntry = entry;
                    Node leftNode = entry.getChild();
                    if (leftNode.numberOfKeys > BTree.this.minimumNodeSize - 1) {
                        Node preNode = leftNode;
                        while (!preNode.isLeaf) {
                            preNode = preNode.getEntry(preNode.numberOfKeys).getChild();
                        }
                        Entry preEntry = preNode.swapLast(returnEntry);
                        if (previous == null) {
                            this.first = preEntry;
                        } else {
                            previous.next = preEntry;
                        }
                        leftNode.delete(key);
                    } else if (entry.next.getChild().numberOfKeys > BTree.this.minimumNodeSize - 1) {
                        Node rightNode = entry.next.getChild();
                        Node successorNode = entry.next.getChild();
                        while (!successorNode.isLeaf) {
                            successorNode = successorNode.first.getChild();
                        }
                        Entry successorEntry = successorNode.swapFirst(returnEntry);
                        if (previous == null) {
                            this.first = successorEntry;
                        } else {
                            previous.next = successorEntry;
                        }
                        rightNode.delete(key);
                    } else {
                        Entry nextEntry = entry.next;
                        Node deleteNode = entry.getChild();
                        if (previous == null) {
                            this.first = entry.next;
                        } else {
                            previous.next = entry.next;
                        }
                        entry.mergeChildWithGreaterThanChild();
                        --this.numberOfKeys;
                        if (this.numberOfKeys == 0) {
                            BTree.this.root = deleteNode;
                        }
                        deleteNode.delete(key);
                    }
                } else {
                    Node deleteNode = entry.getChild();
                    Node leftNode = null;
                    if (previous != null) {
                        leftNode = previous.getChild();
                    }
                    if (entry.getChild().numberOfKeys == BTree.this.minimumNodeSize - 1) {
                        if (previous != null && previous.getChild().numberOfKeys > BTree.this.minimumNodeSize - 1) {
                            Entry fromLeft = previous.getChild().removeLastEntryAndFollowingNode();
                            Node leftChild = previous.getChild().isLeaf ? null : fromLeft.next.getChild();
                            fromLeft.next = entry;
                            fromLeft.setChild(previous.getChild());
                            if (previousPrevious == null) {
                                this.first = fromLeft;
                            } else {
                                previousPrevious.next = fromLeft;
                            }
                            previous.setChild(leftChild);
                            entry.getChild().insertFirst(previous);
                            returnEntry = entry.getChild().delete(key);
                        } else if (entry.next != null && entry.next.getChild().numberOfKeys > BTree.this.minimumNodeSize - 1) {
                            Entry fromRight = entry.next.getChild().removeFirstEntryAndPrecedingNode();
                            fromRight.next = entry.next;
                            deleteNode.insertLast(entry, fromRight.getChild());
                            fromRight.setChild(deleteNode);
                            if (previous == null) {
                                this.first = fromRight;
                            } else {
                                previous.next = fromRight;
                            }
                            returnEntry = deleteNode.delete(key);
                        } else if (entry.next != null) {
                            Entry nextEntry = entry.next;
                            if (previous == null) {
                                this.first = entry.next;
                            } else {
                                previous.next = entry.next;
                            }
                            entry.mergeChildWithGreaterThanChild();
                            --this.numberOfKeys;
                            if (this.numberOfKeys == 0) {
                                BTree.this.root = deleteNode;
                            }
                            returnEntry = deleteNode.delete(key);
                        } else {
                            if (previousPrevious == null) {
                                this.first = entry;
                            } else {
                                previousPrevious.next = entry;
                            }
                            previous.mergeChildWithGreaterThanChild();
                            --this.numberOfKeys;
                            if (this.numberOfKeys == 0) {
                                BTree.this.setRoot(entry.getChild());
                            }
                            returnEntry = entry.getChild().delete(key);
                        }
                    } else {
                        returnEntry = deleteNode.delete(key);
                    }
                }
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, this.cclass, "delete", new Object[]{returnEntry});
            }
            return returnEntry;
        }

        Entry removeLastEntryAndFollowingNode() throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry(this, this.cclass, "removeLastEntryAndFollowingNode");
            }
            Entry entry = this.first;
            Entry previous = null;
            for (int i = 0; i < this.numberOfKeys - 1; ++i) {
                previous = entry;
                entry = entry.next;
            }
            if (this.isLeaf) {
                previous.next = null;
            } else {
                previous.next = BTree.this.makeEntry(null, null);
                previous.next.setChild(entry.getChild());
                entry.setChild(null);
            }
            --this.numberOfKeys;
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, this.cclass, "removeLastEntryAndFollowingNode", new Object[]{entry, new Integer(this.numberOfKeys)});
            }
            return entry;
        }

        Entry removeFirstEntryAndPrecedingNode() {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry(this, this.cclass, "removeFirstEntryAndPrecedingNode");
            }
            Entry entry = this.first;
            this.first = this.first.next;
            --this.numberOfKeys;
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, this.cclass, "removeFirstEntryAndPrecedingNode", new Object[]{entry, new Integer(this.numberOfKeys)});
            }
            return entry;
        }

        Entry getEntry(int index) {
            Entry entry = this.first;
            for (int i = 0; i < index; ++i) {
                entry = entry.next;
            }
            return entry;
        }

        Entry swapFirst(Entry newEntry) throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, this.cclass, "swapFirst", new Object[]{newEntry});
            }
            Entry existing = this.first;
            Entry firstNext = newEntry.next;
            Node firstChild = newEntry.getChild();
            newEntry.next = this.first.next;
            newEntry.setChild(this.first.getChild());
            this.first = newEntry;
            existing.next = firstNext;
            existing.setChild(firstChild);
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, this.cclass, "swapFirst", new Object[]{existing});
            }
            return existing;
        }

        Entry swapLast(Entry newEntry) throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, this.cclass, "swapLast", new Object[]{newEntry});
            }
            Entry previous = null;
            Entry entry = this.first;
            while (entry.next != null) {
                previous = entry;
                entry = entry.next;
            }
            Entry next = newEntry.next;
            Node child = newEntry.getChild();
            newEntry.next = entry.next;
            newEntry.setChild(entry.getChild());
            if (previous == null) {
                this.first = newEntry;
            } else {
                previous.next = newEntry;
            }
            entry.next = next;
            entry.setChild(child);
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, this.cclass, "swapLast", new Object[]{entry});
            }
            return entry;
        }

        final EntryIterator entryIterator() throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry(this, this.cclass, "entryIterator");
            }
            EntryIterator entryIterator = new EntryIterator();
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, this.cclass, "entryIterator", entryIterator);
            }
            return entryIterator;
        }

        public void clear() throws ObjectManagerException {
            if (!this.isLeaf) {
                Entry entry = this.first;
                while (entry != null) {
                    entry.getChild().clear();
                    entry = entry.next;
                }
            }
            this.first = null;
            this.numberOfKeys = 0;
            this.isLeaf = true;
        }

        private class EntryIterator
        implements Iterator {
            Entry current;
            Entry previous = null;
            boolean foundHere;
            EntryIterator currentChildNodeIterator;
            int index = 0;

            EntryIterator() throws ObjectManagerException {
                this.current = Node.this.first;
                if (Node.this.isLeaf) {
                    this.foundHere = true;
                    this.currentChildNodeIterator = null;
                } else {
                    this.foundHere = false;
                    this.currentChildNodeIterator = Node.this.first.getChild().entryIterator();
                }
            }

            @Override
            public boolean hasNext() throws ObjectManagerException {
                return this.current != null && (this.current.key != null || this.currentChildNodeIterator.hasNext());
            }

            @Override
            public boolean hasNext(Transaction transaction) {
                throw new UnsupportedOperationException();
            }

            final Entry nextEntry() throws ObjectManagerException {
                if (Node.this.isLeaf) {
                    if (this.current == null) {
                        throw new NoSuchElementException();
                    }
                    this.previous = this.current;
                    this.current = this.current.next;
                    ++this.index;
                } else if (this.currentChildNodeIterator.hasNext()) {
                    this.previous = this.currentChildNodeIterator.nextEntry();
                    this.foundHere = false;
                } else {
                    if (this.current == null) {
                        throw new ConcurrentModificationException();
                    }
                    this.previous = this.current;
                    this.foundHere = true;
                    this.current = this.current.next;
                    if (this.current == null) {
                        throw new NoSuchElementException();
                    }
                    this.currentChildNodeIterator = this.current.getChild().entryIterator();
                    ++this.index;
                }
                return this.previous;
            }

            @Override
            public Object next() throws ObjectManagerException {
                return this.nextEntry();
            }

            @Override
            public Object next(Transaction transaction) {
                throw new UnsupportedOperationException();
            }

            public void remove() throws ObjectManagerException {
                if (this.previous == null) {
                    throw new IllegalStateException();
                }
                BTree.this.remove(this.previous.key);
                this.previous = null;
            }

            @Override
            public Object remove(Transaction transaction) {
                throw new UnsupportedOperationException();
            }

            protected int[] getIndex() {
                if (this.foundHere) {
                    return new int[]{this.index - 1};
                }
                int[] childIndex = this.currentChildNodeIterator.getIndex();
                int[] returnIndex = new int[childIndex.length + 1];
                returnIndex[0] = this.index;
                for (int i = 0; i < childIndex.length; ++i) {
                    returnIndex[i + 1] = childIndex[i];
                }
                return returnIndex;
            }
        }
    }

    class Entry
    implements Map.Entry {
        private final Class cclass = Entry.class;
        private Object key;
        private Object value;
        protected Entry next = null;
        Node child = null;

        Entry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            Object existingValue = this.value;
            this.value = value;
            return existingValue;
        }

        Node getChild() throws ObjectManagerException {
            return this.child;
        }

        void setChild(Node child) {
            this.child = child;
        }

        void mergeChildWithGreaterThanChild() throws ObjectManagerException {
            Entry rightEntry = this.next;
            Node rightNode = this.next.getChild();
            Node mergeNode = this.getChild();
            Entry last = mergeNode.first;
            while (last.next != null && last.next.key != null) {
                last = last.next;
            }
            this.next = rightNode.first;
            if (last.next != null) {
                this.setChild(last.next.getChild());
            } else {
                this.setChild(null);
            }
            last.next = this;
            rightEntry.setChild(mergeNode);
            mergeNode.numberOfKeys = BTree.this.minimumNodeSize * 2 - 1;
        }

        public String toString() {
            return new String("BTree.Entry(key=" + this.key + " value=" + this.value + ")/hashCode=" + Integer.toHexString(this.hashCode()));
        }
    }
}

