/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.spi.impl;

import jakarta.faces.context.ExternalContext;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.config.annotation.DefaultAnnotationProvider;
import org.apache.myfaces.spi.AnnotationProvider;
import org.apache.myfaces.spi.AnnotationProviderFactory;
import org.apache.myfaces.spi.ServiceProviderFinderFactory;
import org.apache.myfaces.util.lang.ClassUtils;

public class DefaultAnnotationProviderFactory
extends AnnotationProviderFactory {
    public static final String ANNOTATION_PROVIDER = AnnotationProvider.class.getName();
    public static final String ANNOTATION_PROVIDER_LIST = AnnotationProvider.class.getName() + ".LIST";
    public static final String ANNOTATION_PROVIDER_INSTANCE = AnnotationProvider.class.getName() + ".INSTANCE";

    private Logger getLogger() {
        return Logger.getLogger(DefaultAnnotationProviderFactory.class.getName());
    }

    @Override
    public AnnotationProvider getAnnotationProvider(ExternalContext externalContext) {
        AnnotationProvider annotationProvider = (AnnotationProvider)externalContext.getApplicationMap().get(ANNOTATION_PROVIDER_INSTANCE);
        if (annotationProvider == null) {
            annotationProvider = this.createAnnotationProvider(externalContext);
            externalContext.getApplicationMap().put(ANNOTATION_PROVIDER_INSTANCE, annotationProvider);
        }
        return annotationProvider;
    }

    @Override
    public AnnotationProvider createAnnotationProvider(ExternalContext externalContext) {
        AnnotationProvider instance = null;
        try {
            instance = this.resolveAnnotationProviderFromService(externalContext);
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            this.getLogger().log(Level.SEVERE, "", e);
        }
        return instance;
    }

    private AnnotationProvider resolveAnnotationProviderFromService(ExternalContext externalContext) throws ClassNotFoundException, NoClassDefFoundError, InstantiationException, IllegalAccessException, InvocationTargetException {
        List<String> classList = (List<String>)externalContext.getApplicationMap().get(ANNOTATION_PROVIDER_LIST);
        if (classList == null) {
            classList = ServiceProviderFinderFactory.getServiceProviderFinder(externalContext).getServiceProviderList(ANNOTATION_PROVIDER);
            externalContext.getApplicationMap().put(ANNOTATION_PROVIDER_LIST, classList);
        }
        return ClassUtils.buildApplicationObject(AnnotationProvider.class, classList, new DefaultAnnotationProvider());
    }
}

