/*
 * Decompiled with CFR 0.152.
 */
package jakarta.data.constraint;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.data.constraint.Like;
import jakarta.data.constraint.NotLike;
import jakarta.data.constraint.NotLikeRecord;
import jakarta.data.expression.TextExpression;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
record LikeRecord(TextExpression<?> pattern, Character escape) implements Like
{
    static final char CHAR_WILDCARD = '_';
    static final char ESCAPE = '\\';
    static final char STRING_WILDCARD = '%';
    static final long serialVersionUID = -3317681710474495352L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    static String escape(String literal) {
        StringBuilder s = new StringBuilder();
        for (int c = 0; c < literal.length(); ++c) {
            char ch = literal.charAt(c);
            if (ch == '_' || ch == '\\' || ch == '%') {
                s.append('\\');
            }
            s.append(ch);
        }
        return s.toString();
    }

    public NotLike negate() {
        return new NotLikeRecord(this.pattern, this.escape);
    }

    @Override
    public String toString() {
        return "LIKE " + String.valueOf(this.pattern) + (String)(this.escape == null ? "" : " ESCAPE '" + this.escape + "'");
    }

    static String translate(String pattern, char charWildcard, char stringWildcard, char escape) {
        if (charWildcard == stringWildcard) {
            throw new IllegalArgumentException(Character.toString(charWildcard));
        }
        if (charWildcard == escape || stringWildcard == escape) {
            throw new IllegalArgumentException(Character.toString(escape));
        }
        StringBuilder result = new StringBuilder();
        for (int c = 0; c < pattern.length(); ++c) {
            char ch = pattern.charAt(c);
            if (ch == charWildcard) {
                result.append('_');
                continue;
            }
            if (ch == stringWildcard) {
                result.append('%');
                continue;
            }
            if (ch == '_' || ch == escape || ch == '%') {
                result.append(escape);
            }
            result.append(ch);
        }
        return result.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"jakarta.data.constraint.LikeRecord", LikeRecord.class, null, null);
    }
}

